/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.effects;

import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.paladins.effect.Effects;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;
import net.sweenus.simplyskills.SimplySkills;
import net.sweenus.simplyskills.abilities.SignatureAbilities;
import net.sweenus.simplyskills.abilities.compat.SimplySwordsGemEffects;
import net.sweenus.simplyskills.registry.SoundRegistry;
import net.sweenus.simplyskills.util.HelperMethods;
import net.sweenus.simplyskills.util.SkillReferencePosition;

public class SacredOnslaughtEffect
extends MobEffect {
    public SacredOnslaughtEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
    }

    public void m_6742_(LivingEntity livingEntity, int amplifier) {
        if (!livingEntity.m_9236_().m_5776_() && livingEntity.m_20096_() && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            int velocity = SimplySkills.crusaderConfig.signatureCrusaderSacredOnslaughtVelocity;
            int radius = SimplySkills.crusaderConfig.signatureCrusaderSacredOnslaughtRadius;
            double damageMultiplier = SimplySkills.crusaderConfig.signatureCrusaderSacredOnslaughtDMGMultiplier;
            double healing = SpellPower.getSpellPower((SpellSchool)SpellSchools.HEALING, (LivingEntity)player).baseValue() * damageMultiplier;
            int hitFrequency = 10;
            int stunDuration = SimplySkills.crusaderConfig.signatureCrusaderSacredOnslaughtStunDuration;
            player.m_20256_(livingEntity.m_20154_().m_82490_((double)velocity));
            player.m_20334_(livingEntity.m_20184_().f_82479_, 0.0, livingEntity.m_20184_().f_82481_);
            player.f_19864_ = true;
            double damage = (double)player.m_21230_() * damageMultiplier;
            AABB box = HelperMethods.createBox((Entity)player, radius * 2);
            for (Entity entities : livingEntity.m_9236_().m_6249_((Entity)livingEntity, box, EntitySelector.f_20403_)) {
                if (entities == null || !(entities instanceof LivingEntity)) continue;
                LivingEntity le = (LivingEntity)entities;
                if (player.f_19797_ % hitFrequency != 0) continue;
                if (HelperMethods.checkFriendlyFire(le, player) && player.m_21254_()) {
                    le.m_20334_((le.m_20185_() - player.m_20185_()) / 4.0, (le.m_20186_() - player.m_20186_()) / 4.0, (le.m_20189_() - player.m_20189_()) / 4.0);
                    le.m_6469_(player.m_269291_().m_269075_(player), (float)damage);
                    player.m_9236_().m_6269_(null, (Entity)player, SoundRegistry.SOUNDEFFECT32, SoundSource.PLAYERS, 0.6f, 1.0f);
                    if (HelperMethods.isUnlocked("simplyskills:crusader", SkillReferencePosition.crusaderSpecialisationSacredOnslaughtStun, (LivingEntity)player)) {
                        le.m_7292_(new MobEffectInstance(Effects.JUDGEMENT, stunDuration));
                    }
                }
                if (!HelperMethods.checkFriendlyFire(le, player) && HelperMethods.isUnlocked("simplyskills:crusader", SkillReferencePosition.crusaderSpecialisationSacredOnslaughtHeal, (LivingEntity)player)) {
                    SignatureAbilities.castSpellEngineIndirectTarget(player, "paladins:divine_protection", 32, (Entity)le, null);
                    le.m_5634_((float)healing);
                }
                HelperMethods.spawnParticlesPlane(player.m_9236_(), (ParticleOptions)ParticleTypes.f_123796_, player.m_20183_(), radius - 2, 0.0, 1.0, 0.0);
            }
        }
        super.m_6742_(livingEntity, amplifier);
    }

    public void m_6386_(LivingEntity entity, AttributeMap attributes, int amplifier) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (FabricLoader.getInstance().isModLoaded("simplyswords")) {
                SimplySwordsGemEffects.warStandard(player);
            }
        }
        super.m_6386_(entity, attributes, amplifier);
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }
}

