/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.entities;

import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.sweenus.simplyskills.abilities.NecromancerAbilities;
import net.sweenus.simplyskills.entities.ai.DirectionalFlightMoveControl;
import net.sweenus.simplyskills.registry.SoundRegistry;
import net.sweenus.simplyskills.util.HelperMethods;
import net.sweenus.simplyskills.util.SkillReferencePosition;
import org.jetbrains.annotations.Nullable;

public class DreadglareEntity
extends TamableAnimal
implements NeutralMob,
FlyingAnimal {
    public static int lifespan = 2400;

    public DreadglareEntity(EntityType<? extends TamableAnimal> entityType, Level world) {
        super(entityType, world);
        this.f_21342_ = new DirectionalFlightMoveControl((Mob)this, 1, true);
        this.m_20242_(true);
    }

    public static AttributeSupplier.Builder createDreadglareAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22280_, (double)1.6f).m_22268_(Attributes.f_22279_, (double)0.6f).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22278_, 0.1).m_22268_(Attributes.f_22277_, 48.0);
    }

    public void m_8119_() {
        if (!this.m_9236_().m_5776_()) {
            double threshold;
            Vec3 toTargetVec;
            Vec3 entityLookVec;
            double dotProduct;
            Player owner;
            boolean ownerNotInWorld = true;
            if (this.m_21805_() != null) {
                owner = this.m_9236_().m_46003_(this.m_21805_());
                boolean bl = ownerNotInWorld = owner == null || !owner.m_6084_();
            }
            if (this.f_19797_ > lifespan || this.f_19797_ > 120 && (this.m_269323_() == null || ownerNotInWorld)) {
                this.m_6469_(this.m_269291_().m_269264_(), this.m_21233_());
                this.m_142687_(Entity.RemovalReason.UNLOADED_WITH_PLAYER);
            }
            if (this.m_5448_() != null && this.m_21805_() != null && (owner = this.m_9236_().m_46003_(this.m_21805_())) != null && this.m_5448_() != owner && (dotProduct = (entityLookVec = this.m_20252_(1.0f)).m_82526_(toTargetVec = this.m_5448_().m_20182_().m_82546_(this.m_20182_()).m_82541_())) > (threshold = Math.cos(Math.toRadians(15.0))) && this.m_20270_((Entity)this.m_5448_()) > 2.0f) {
                float damage = (float)this.m_21133_(Attributes.f_22281_) * 2.0f;
                float distance = this.m_20270_((Entity)this.m_5448_());
                DamageSource damageSource = this.m_269291_().m_269075_(owner);
                Level world = this.m_9236_();
                int timeDifference = this.m_217043_().m_188503_(15);
                if (this.f_19797_ % (15 + timeDifference) == 0) {
                    world.m_5594_(null, this.m_20183_(), SoundEvents.f_215771_, this.m_5720_(), 0.4f, 1.6f);
                    HelperMethods.spawnDirectionalParticles((ServerLevel)world, (ParticleOptions)ParticleTypes.f_235902_, (Entity)this, 5, distance);
                    HelperMethods.spawnDirectionalParticles((ServerLevel)world, (ParticleOptions)ParticleTypes.f_123759_, (Entity)this, 5, distance);
                    HelperMethods.damageEntitiesInTrajectory((ServerLevel)world, (Entity)this, owner, distance, damage, damageSource);
                    this.m_20256_(this.m_20154_().m_82548_().m_82490_(0.8));
                    this.m_20334_(this.m_20184_().f_82479_, 0.0, this.m_20184_().f_82481_);
                }
            }
            if (!this.m_20068_()) {
                this.m_20242_(true);
            }
            this.f_19860_ = this.m_146909_();
            this.f_19859_ = this.m_146908_();
            if (this.m_5448_() == null && this.m_269323_() != null) {
                this.m_6710_(this.m_269323_());
            } else if (this.m_5448_() != null && !this.m_5448_().equals((Object)this.m_269323_()) && this.m_20270_((Entity)this.m_5448_()) > 20.0f) {
                this.m_6710_(this.m_269323_());
            }
        }
        super.m_8119_();
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (Objects.equals(source.m_7639_(), this.m_269323_())) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_7327_(Entity target) {
        LivingEntity livingEntity;
        MoveControl moveControl = this.m_21566_();
        if (moveControl instanceof DirectionalFlightMoveControl) {
            ((DirectionalFlightMoveControl)moveControl).onAttack();
        }
        if (this.m_269323_() != null && (livingEntity = this.m_269323_()) instanceof Player) {
            Player player = (Player)livingEntity;
            if (target.equals((Object)player)) {
                return false;
            }
            float siphonAmount = (float)this.m_21133_(Attributes.f_22281_) * 0.3f;
            if (HelperMethods.isUnlocked("simplyskills:necromancer", SkillReferencePosition.necromancerSpecialisationBloodHarvest, (LivingEntity)player)) {
                this.m_5634_(siphonAmount);
                player.m_5634_(siphonAmount / 2.0f);
            }
            if (target instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)target;
                NecromancerAbilities.effectPestilence(player, (LivingEntity)this, livingTarget);
            }
        }
        float random = (float)((double)this.f_19796_.m_188503_(5) * 0.1);
        this.m_9236_().m_6269_(null, (Entity)this, SoundRegistry.MAW, SoundSource.PLAYERS, 0.1f, 1.3f + random);
        target.f_19802_ = 0;
        return super.m_7327_(target);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 20.0f, 2.0f, true));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, false));
    }

    public void m_8107_() {
        super.m_8107_();
        Vec3 velocity = this.m_20184_();
        if (!velocity.equals((Object)Vec3.f_82478_)) {
            float yaw = (float)(Mth.m_14136_((double)velocity.f_82481_, (double)velocity.f_82479_) * 57.29577951308232) - 90.0f;
            float pitch = (float)(-(Mth.m_14136_((double)velocity.f_82480_, (double)Math.sqrt(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)) * 57.29577951308232));
            this.m_146922_(yaw);
            this.f_20883_ = yaw;
            this.m_146926_(pitch);
        }
    }

    public void m_6667_(DamageSource damageSource) {
        LivingEntity livingEntity;
        if (!this.m_9236_().m_5776_() && this.m_269323_() != null && (livingEntity = this.m_269323_()) instanceof Player) {
            Player player = (Player)livingEntity;
            NecromancerAbilities.effectNecromancerEnrage((LivingEntity)this, player);
            NecromancerAbilities.effectNecromancerDeathEssence(player);
            NecromancerAbilities.effectShadowCombust(player, this);
            NecromancerAbilities.effectEndlessServitude(player, this);
        }
        super.m_6667_(damageSource);
    }

    public EntityGetter m_9236_() {
        return this.m_9236_();
    }

    public int m_6784_() {
        return 0;
    }

    public void m_7870_(int angerTime) {
    }

    @Nullable
    public UUID m_6120_() {
        return null;
    }

    public void m_6925_(@Nullable UUID angryAt) {
    }

    public void m_6825_() {
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        return null;
    }

    public boolean m_29443_() {
        return true;
    }

    protected void m_7840_(double heightDifference, boolean onGround, BlockState landedState, BlockPos landedPosition) {
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    protected PathNavigation m_6037_(Level world) {
        FlyingPathNavigation birdNavigation = new FlyingPathNavigation((Mob)this, world){};
        birdNavigation.m_26440_(false);
        birdNavigation.m_7008_(false);
        birdNavigation.m_26443_(false);
        return birdNavigation;
    }
}

