/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.mixins;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.sweenus.simplyskills.abilities.AbilityEffects;
import net.sweenus.simplyskills.abilities.WayfarerAbilities;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.util.HelperMethods;
import net.sweenus.simplyskills.util.SkillReferencePosition;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BowItem.class})
public abstract class BowItemMixin {
    @Shadow
    public abstract int m_8105_(ItemStack var1);

    @Invoker
    public static float callGetPullProgress(int useTicks) {
        throw new AssertionError();
    }

    @Inject(at={@At(value="HEAD")}, method={"onStoppedUsing"}, cancellable=true)
    public void simplyskills$onStoppedUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks, CallbackInfo ci) {
        Player player;
        if (user instanceof Player && (player = (Player)user) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            float requiredPullProgress = 1.0f;
            if (stack.m_41786_().toString().contains("Shortbow") || stack.m_41786_().toString().contains("shortbow") || stack.m_41786_().toString().contains("love")) {
                requiredPullProgress = 0.5f;
            }
            int useTicks = this.m_8105_(stack) - remainingUseTicks;
            if (player.m_21023_(EffectRegistry.ELEMENTALARROWS)) {
                if (BowItemMixin.callGetPullProgress(useTicks) >= requiredPullProgress && AbilityEffects.effectRangerElementalArrows(player)) {
                    ci.cancel();
                }
            } else if (player.m_21023_(EffectRegistry.ARROWRAIN)) {
                if (BowItemMixin.callGetPullProgress(useTicks) >= requiredPullProgress && AbilityEffects.effectRangerArrowRain(player)) {
                    ci.cancel();
                }
            } else if (player.m_21023_(EffectRegistry.MARKSMAN) && BowItemMixin.callGetPullProgress(useTicks) >= requiredPullProgress && AbilityEffects.effectRangerMarksman(player)) {
                ci.cancel();
            }
            if (player.m_21023_(EffectRegistry.STEALTH)) {
                WayfarerAbilities.passiveWayfarerBreakStealth(null, player, false, false);
            }
            if (BowItemMixin.callGetPullProgress(useTicks) >= requiredPullProgress && HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.wayfarerQuickfire, (LivingEntity)player)) {
                HelperMethods.incrementStatusEffect(user, EffectRegistry.MARKSMANSHIP, 40, 1, 6);
            }
        }
    }
}

