/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.mixins;

import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.sweenus.simplyskills.SimplySkills;
import net.sweenus.simplyskills.abilities.AbilityEffects;
import net.sweenus.simplyskills.abilities.AbilityLogic;
import net.sweenus.simplyskills.abilities.AscendancyAbilities;
import net.sweenus.simplyskills.abilities.BerserkerAbilities;
import net.sweenus.simplyskills.abilities.ClericAbilities;
import net.sweenus.simplyskills.abilities.CrusaderAbilities;
import net.sweenus.simplyskills.abilities.InitiateAbilities;
import net.sweenus.simplyskills.abilities.NecromancerAbilities;
import net.sweenus.simplyskills.abilities.ProminenceAbilities;
import net.sweenus.simplyskills.abilities.RangerAbilities;
import net.sweenus.simplyskills.abilities.RogueAbilities;
import net.sweenus.simplyskills.abilities.SignatureAbilities;
import net.sweenus.simplyskills.abilities.WarriorAbilities;
import net.sweenus.simplyskills.abilities.WayfarerAbilities;
import net.sweenus.simplyskills.abilities.WizardAbilities;
import net.sweenus.simplyskills.abilities.compat.ProminenceInternalAbilities;
import net.sweenus.simplyskills.abilities.compat.SimplySwordsGemEffects;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.registry.SoundRegistry;
import net.sweenus.simplyskills.util.HelperMethods;
import net.sweenus.simplyskills.util.SkillReferencePosition;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerEntityMixin {
    @Inject(at={@At(value="HEAD")}, method={"damage"}, cancellable=true)
    public void simplyskills$damage(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        ServerPlayer serverPlayer;
        Player player = (Player)this;
        if (player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).m_6084_()) {
            if (player.m_21023_(EffectRegistry.BARRIER)) {
                HelperMethods.decrementStatusEffect((LivingEntity)player, EffectRegistry.BARRIER);
                cir.setReturnValue((Object)false);
                player.m_9236_().m_6269_(null, (Entity)player, SoundRegistry.FX_SKILL_BACKSTAB, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            if (player.m_21023_(EffectRegistry.GHOSTWALK)) {
                cir.setReturnValue((Object)false);
                player.m_9236_().m_6269_(null, (Entity)player, SoundRegistry.FX_SKILL_BACKSTAB, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            if (AscendancyAbilities.tormentEffect(player, source, amount)) {
                cir.setReturnValue((Object)false);
            }
            if (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.warriorHeavyArmorMastery, (LivingEntity)serverPlayer) || HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.warriorMediumArmorMastery, (LivingEntity)serverPlayer)) {
                WarriorAbilities.passiveWarriorArmorMastery(player);
            }
            if (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.warriorSpellbreaker, (LivingEntity)player)) {
                WarriorAbilities.passiveWarriorSpellbreaker(player);
            }
            if (HelperMethods.isUnlocked("simplyskills:rogue", SkillReferencePosition.rogueSmokeBomb, (LivingEntity)serverPlayer)) {
                RogueAbilities.passiveRogueSmokeBomb(player);
            }
            if (HelperMethods.isUnlocked("simplyskills:rogue", SkillReferencePosition.rogueEvasionMastery, (LivingEntity)serverPlayer) && !RogueAbilities.passiveRogueEvasionMastery(player)) {
                cir.setReturnValue((Object)false);
            }
            if (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.initiateHasty, (LivingEntity)player)) {
                InitiateAbilities.passiveInitiateHasty(player);
            }
            if (HelperMethods.isUnlocked("simplyskills:berserker", SkillReferencePosition.berserkerSpecialisationRampage, (LivingEntity)serverPlayer)) {
                AbilityEffects.effectBerserkerRampage(player);
            }
            if (player.m_21023_(EffectRegistry.STEALTH) && !player.m_21023_(EffectRegistry.BARRIER)) {
                WayfarerAbilities.passiveWayfarerBreakStealth(null, player, true, false);
            }
            if (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.berserkerPath, (LivingEntity)serverPlayer) && !player.m_6673_(source)) {
                HelperMethods.incrementStatusEffect((LivingEntity)player, EffectRegistry.RAGE, 300, 1, 99);
            }
            if (HelperMethods.isUnlocked("simplyskills:cleric", SkillReferencePosition.clericSpecialisationAnointWeaponUndying, (LivingEntity)player) && FabricLoader.getInstance().isModLoaded("paladins")) {
                ClericAbilities.signatureClericAnointWeaponUndying(player);
            }
            if (HelperMethods.isUnlocked("simplyskills:necromancer", SkillReferencePosition.necromancerSpecialisationDeathWarden, (LivingEntity)player) && player.m_21223_() < player.m_21233_() / 2.0f) {
                NecromancerAbilities.effectDeathWarden(player);
            }
            AscendancyAbilities.boneArmorEffect(serverPlayer);
            ProminenceAbilities.boneArmorEffect(serverPlayer);
        }
    }

    @ModifyVariable(method={"damage"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    private float simplyskills$damageResult(float amount) {
        Player player = (Player)this;
        if (player.m_21023_(EffectRegistry.RAGE)) {
            float damageModifier = 1.0f + (float)player.m_21124_(EffectRegistry.RAGE).m_19564_() / 200.0f;
            return amount * damageModifier;
        }
        if (player.m_21023_(EffectRegistry.MELODYOFPROTECTION)) {
            return ProminenceAbilities.melodyOfProtection(amount);
        }
        return amount;
    }

    @Inject(at={@At(value="HEAD")}, method={"tickFallStartPos"})
    public void simplyskills$tickFallStartPos(CallbackInfo ci) {
        ServerPlayer player = (ServerPlayer)this;
        float slowfallActivateDistance = SimplySkills.initiateConfig.passiveInitiateSlowFallDistanceToActivate;
        float goliathActivateDistance = SimplySkills.warriorConfig.passiveWarriorGoliathFallDistance;
        if (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.initiateSlowfall, (LivingEntity)player) && player.f_19789_ > slowfallActivateDistance && !player.m_21023_(MobEffects.f_19591_)) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 20, 0, false, false, true));
        }
        if (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.warriorGoliath, (LivingEntity)player) && player.f_19789_ > goliathActivateDistance && !player.m_21023_(MobEffects.f_19591_)) {
            WarriorAbilities.passiveWarriorGoliath((Player)player);
            if (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.warriorBound, (LivingEntity)player)) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 80, 2, false, false, true));
                player.m_7292_(new MobEffectInstance(EffectRegistry.RAGINGJAVELIN, 80, 0, false, false, true));
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    public void simplyskills$tick(CallbackInfo ci) {
        ServerPlayer serverPlayer;
        Player player = (Player)this;
        if (player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).m_6084_()) {
            if (player.m_21023_(EffectRegistry.STEALTH)) {
                player.m_6842_(player.m_21023_(EffectRegistry.STEALTH));
            }
            if (player.f_19797_ % 10 == 0 && WayfarerAbilities.passiveWayfarerStealth(player)) {
                player.m_7292_(new MobEffectInstance(EffectRegistry.STEALTH, 20, 0, false, false, true));
            }
            if (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.warriorDeathDefy, (LivingEntity)player)) {
                WarriorAbilities.passiveWarriorDeathDefy(player);
            }
            if (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.warriorCarnage, (LivingEntity)player)) {
                WarriorAbilities.passiveWarriorCarnage(player);
            }
            if (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.wayfarerSneak, (LivingEntity)player) && player.m_6144_() && player.f_19797_ % 10 == 0) {
                int sneakSpeedAmplifier = SimplySkills.wayfarerConfig.passiveWayfarerSneakSpeedAmplifier;
                player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 15, sneakSpeedAmplifier, false, false, true));
                if (player.m_21023_(EffectRegistry.STEALTH)) {
                    HelperMethods.incrementStatusEffect((LivingEntity)player, EffectRegistry.MIGHT, 15, 1, 22);
                }
            }
            if (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.wayfarerGuarding, (LivingEntity)player)) {
                WayfarerAbilities.passiveWayfarerGuarding(player);
            }
            if (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.initiateNullification, (LivingEntity)player)) {
                InitiateAbilities.passiveInitiateNullification(player);
            }
            if (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.initiateLightningRod, (LivingEntity)player)) {
                InitiateAbilities.passiveInitiateLightningRod(player);
            }
            if (HelperMethods.isUnlocked("simplyskills:ranger", SkillReferencePosition.rangerReveal, (LivingEntity)player)) {
                RangerAbilities.passiveRangerReveal(player);
            }
            if (HelperMethods.isUnlocked("simplyskills:ranger", SkillReferencePosition.rangerBonded, (LivingEntity)player)) {
                RangerAbilities.passiveRangerBonded(player);
            }
            if (HelperMethods.isUnlocked("simplyskills:ranger", SkillReferencePosition.rangerTamer, (LivingEntity)player)) {
                RangerAbilities.passiveRangerTamer(player);
            }
            if (HelperMethods.isUnlocked("simplyskills:ranger", SkillReferencePosition.rangerTrained, (LivingEntity)player)) {
                RangerAbilities.passiveRangerTrained(player);
            }
            if (HelperMethods.isUnlocked("simplyskills:ranger", SkillReferencePosition.rangerIncognito, (LivingEntity)player)) {
                RangerAbilities.passiveRangerIncognito(player);
            }
            if (HelperMethods.isUnlocked("simplyskills:berserker", SkillReferencePosition.berserkerSwordMastery, (LivingEntity)player)) {
                BerserkerAbilities.passiveBerserkerSwordMastery(player);
            }
            if (HelperMethods.isUnlocked("simplyskills:berserker", SkillReferencePosition.berserkerAxeMastery, (LivingEntity)player)) {
                BerserkerAbilities.passiveBerserkerAxeMastery(player);
            }
            if (HelperMethods.isUnlocked("simplyskills:berserker", SkillReferencePosition.berserkerIgnorePain, (LivingEntity)player)) {
                BerserkerAbilities.passiveBerserkerIgnorePain(player);
            }
            if (HelperMethods.isUnlocked("simplyskills:berserker", SkillReferencePosition.berserkerPath, (LivingEntity)player)) {
                BerserkerAbilities.passiveBerserkerRecklessness(player);
            }
            if (HelperMethods.isUnlocked("simplyskills:berserker", SkillReferencePosition.berserkerChallenge, (LivingEntity)player)) {
                BerserkerAbilities.passiveBerserkerChallenge(player);
            }
            if (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.bulwarkShieldMastery, (LivingEntity)player)) {
                WarriorAbilities.passiveWarriorShieldMastery(player);
            }
            if (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.roguePath, (LivingEntity)player) || HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.rangerPath, (LivingEntity)player) || HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.wizardPath, (LivingEntity)player)) {
                WayfarerAbilities.passiveWayfarerSlender(player);
            }
            if (HelperMethods.isUnlocked("simplyskills:rogue", SkillReferencePosition.rogueBackstab, (LivingEntity)player)) {
                RogueAbilities.passiveRogueBackstabStealth(player);
            }
            if (HelperMethods.isUnlocked("simplyskills:wizard", SkillReferencePosition.wizardSpecialisationIceCometVolley, (LivingEntity)player)) {
                AbilityEffects.effectWizardFrostVolley(player);
            }
            if (HelperMethods.isUnlocked("simplyskills:wizard", SkillReferencePosition.wizardSpecialisationArcaneBoltVolley, (LivingEntity)player)) {
                AbilityEffects.effectWizardArcaneVolley(player);
            }
            if (HelperMethods.isUnlocked("simplyskills:wizard", SkillReferencePosition.wizardSpecialisationMeteorShowerWrath, (LivingEntity)player)) {
                AbilityEffects.effectWizardMeteoricWrath(player);
            }
            if (HelperMethods.isUnlocked("simplyskills:rogue", SkillReferencePosition.rogueSpecialisationEvasionFanOfBlades, (LivingEntity)player)) {
                AbilityEffects.effectRogueFanOfBlades(player);
            }
            if (HelperMethods.isUnlocked("simplyskills:crusader", SkillReferencePosition.crusaderAegis, (LivingEntity)player) && FabricLoader.getInstance().isModLoaded("paladins")) {
                CrusaderAbilities.passiveCrusaderAegis(player);
            }
            if (FabricLoader.getInstance().isModLoaded("paladins")) {
                CrusaderAbilities.effectDivineAdjudication(player);
            }
            if (HelperMethods.isUnlocked("simplyskills:wizard", SkillReferencePosition.wizardSpecialisationStaticDischargeLightningOrb, (LivingEntity)player)) {
                WizardAbilities.signatureWizardLightningOrbBuff(player);
            }
            if (HelperMethods.isUnlocked("simplyskills:cleric", SkillReferencePosition.clericAltruism, (LivingEntity)player) && FabricLoader.getInstance().isModLoaded("paladins")) {
                ClericAbilities.passiveClericAltruism(player);
            }
            if (HelperMethods.isUnlocked("simplyskills:ascendancy", SkillReferencePosition.ascendancyRighteousShield, (LivingEntity)player) && AscendancyAbilities.getAscendancyPoints(player) > 29 && player.f_19797_ % 400 == 0) {
                AscendancyAbilities.goldenAegis(player);
            }
            if (FabricLoader.getInstance().isModLoaded("prominent") && HelperMethods.isUnlocked("puffish_skills:prom", SkillReferencePosition.ascendancyRighteousShield, (LivingEntity)player) && ProminenceAbilities.getAscendancyPoints(player) > 29 && player.f_19797_ % 400 == 0) {
                AscendancyAbilities.goldenAegis(player);
            }
            if (HelperMethods.isUnlocked("simplyskills:necromancer", SkillReferencePosition.necromancerSpecialisationWinterborn, (LivingEntity)player) && player.f_19797_ % 200 == 0) {
                NecromancerAbilities.effectNecromancerWinterborn(player);
            }
            NecromancerAbilities.effectPlague(player);
            if (FabricLoader.getInstance().isModLoaded("prominent")) {
                ProminenceAbilities.warriorsDevotion(player);
                if (FabricLoader.getInstance().isModLoaded("immersive_melodies")) {
                    ProminenceInternalAbilities.bardAbility(player);
                }
            }
            if (FabricLoader.getInstance().isModLoaded("simplyswords")) {
                SimplySwordsGemEffects.spellforged(player);
                SimplySwordsGemEffects.soulshock(player);
            }
            if (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.initiateLightningRod, (LivingEntity)player) && player.f_19797_ % 40 == 0 && player.m_21023_(EffectRegistry.SOULSHOCK)) {
                SignatureAbilities.castSpellEngineAOE(player, "simplyskills:lightning_rod", 5, 100, false, true);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"onDeath"})
    public void simplyskills$onDeath(DamageSource damageSource, CallbackInfo ci) {
        ServerPlayer player = (ServerPlayer)this;
        HelperMethods.treeResetOnDeath(player);
    }

    @Inject(at={@At(value="HEAD")}, method={"attack"})
    public void simplyskills$attack(Entity target, CallbackInfo ci) {
        ServerPlayer serverPlayer;
        Player player = (Player)this;
        if (player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).m_6084_() && target.m_6097_() && !target.m_7313_((Entity)player)) {
            AbilityLogic.doMeleeOnHit(serverPlayer, target);
        }
    }
}

