/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.mixins;

import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.SpellInfo;
import net.spell_engine.entity.SpellProjectile;
import net.spell_engine.internals.SpellHelper;
import net.sweenus.simplyskills.abilities.AbilityLogic;
import net.sweenus.simplyskills.abilities.AscendancyAbilities;
import net.sweenus.simplyskills.abilities.ClericAbilities;
import net.sweenus.simplyskills.abilities.RangerAbilities;
import net.sweenus.simplyskills.abilities.WizardAbilities;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.util.HelperMethods;
import net.sweenus.simplyskills.util.SkillReferencePosition;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SpellProjectile.class})
public abstract class SpellProjectileMixin
extends Projectile {
    @Shadow
    private Spell.ProjectileData.Perks perks;
    @Shadow
    public float range;
    @Shadow
    private ResourceLocation spellId;
    @Shadow
    private SpellHelper.ImpactContext context;
    @Shadow
    private Entity followedTarget;

    @Shadow
    public abstract Spell getSpell();

    @Shadow
    public abstract void setVelocity(double var1, double var3, double var5, float var7, float var8, float var9);

    @Shadow
    public abstract SpellInfo getSpellInfo();

    public SpellProjectileMixin(EntityType<? extends Projectile> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    public void simplyskills$tick(CallbackInfo ci) {
        Entity entity;
        if (!this.m_9236_().f_46443_ && this.getSpell() != null && (entity = this.m_19749_()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            SpellProjectile spellProjectile = (SpellProjectile)this;
            RangerAbilities.signatureRangerElementalArtillery(player, spellProjectile, this.spellId, this.context, this.perks);
            WizardAbilities.signatureWizardStaticDischargeBall(player, spellProjectile, this.spellId, this.context, this.perks);
            WizardAbilities.signatureWizardLightningOrb(spellProjectile, this.followedTarget, this.spellId);
            ClericAbilities.signatureClericSacredOrbHoming(spellProjectile, this.spellId);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"onBlockHit"}, cancellable=true)
    protected void simplyskills$onBlockHit(CallbackInfo ci) {
        if (!this.m_9236_().f_46443_ && this.spellId != null && this.getSpell() != null) {
            String[] spellList = new String[]{"simplyskills:lightning_ball_homing", "simplyskills:physical_dagger_homing", "simplyskills:sacred_orb_lesser"};
            if (HelperMethods.stringContainsAny(this.spellId.toString(), spellList)) {
                ci.cancel();
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"onEntityHit"}, cancellable=true)
    protected void simplyskills$onEntityHit(EntityHitResult entityHitResult, CallbackInfo ci) {
        if (!this.m_9236_().f_46443_ && this.spellId != null && this.getSpell() != null) {
            Entity entity;
            if (entityHitResult.m_82443_() != null && (entity = entityHitResult.m_82443_()) instanceof LivingEntity) {
                Entity entity2;
                LivingEntity livingEntity = (LivingEntity)entity;
                if (this.m_19749_() != null && livingEntity.m_21023_(EffectRegistry.AGONY) && (entity2 = this.m_19749_()) instanceof Player) {
                    Player playerAttacker = (Player)entity2;
                    AscendancyAbilities.agonyEffect(playerAttacker, livingEntity);
                }
            }
            try {
                Entity entity3;
                SpellProjectile spellProjectile = (SpellProjectile)this;
                ClericAbilities.signatureClericSacredOrbImpact(entityHitResult, this.spellId, this.m_19749_(), spellProjectile);
                String[] spellList = new String[]{"simplyskills:lightning_ball_homing", "simplyskills:physical_dagger_homing"};
                if (HelperMethods.stringContainsAny(this.spellId.toString(), spellList) && (entity3 = this.m_19749_()) instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity3;
                    SpellHelper.projectileImpact((LivingEntity)player, (Entity)this, (Entity)entityHitResult.m_82443_(), (SpellInfo)this.getSpellInfo(), (SpellHelper.ImpactContext)this.context.position(entityHitResult.m_82450_()));
                    if (HelperMethods.isUnlocked("simplyskills:wizard", SkillReferencePosition.wizardSpecialisationStaticDischargeLightningOrbOnHit, (LivingEntity)player)) {
                        ArrayList<Entity> targets = new ArrayList<Entity>();
                        if (entityHitResult.m_82443_() != null) {
                            targets.add(entityHitResult.m_82443_());
                            AbilityLogic.onSpellCastEffects((Player)player, targets, this.spellId, null);
                        }
                    }
                    ci.cancel();
                }
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        }
    }
}

