/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.network;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.sweenus.simplyskills.SimplySkills;
import net.sweenus.simplyskills.client.gui.CustomHud;
import net.sweenus.simplyskills.network.StopSoundPacket;
import net.sweenus.simplyskills.network.UpdateUnspentPointsPacket;
import net.sweenus.simplyskills.util.HelperMethods;
import net.sweenus.simplyskills.util.SkillReferencePosition;

public class ModPacketHandler {
    private static final ResourceLocation UPDATE_UNSPENT_POINTS_ID = new ResourceLocation("simplyskills", "update_unspent_points");
    private static final ResourceLocation STOP_SOUND_ID = new ResourceLocation("simplyskills", "stop_sound");
    private static final ResourceLocation SYNC_ITEM_STACK_ID = new ResourceLocation("simplyskills", "sync_item_stack");
    private static final ResourceLocation SYNC_SIGNATURE_ABILITY = new ResourceLocation("simplyskills", "sync_signature_ability");

    public static void registerServer() {
        ServerPlayNetworking.registerGlobalReceiver((ResourceLocation)UPDATE_UNSPENT_POINTS_ID, (server, player, handler, buf, responseSender) -> {
            UpdateUnspentPointsPacket packet = UpdateUnspentPointsPacket.decode(buf);
            server.execute(() -> UpdateUnspentPointsPacket.handleServer(packet, handler, responseSender));
        });
    }

    public static void registerClient() {
        ClientPlayNetworking.registerGlobalReceiver((ResourceLocation)UPDATE_UNSPENT_POINTS_ID, (client, handler, buf, responseSender) -> {
            UpdateUnspentPointsPacket packet = UpdateUnspentPointsPacket.decode(buf);
            client.execute(() -> UpdateUnspentPointsPacket.handleClient(packet, handler, responseSender));
        });
        ClientPlayNetworking.registerGlobalReceiver((ResourceLocation)STOP_SOUND_ID, (client, handler, buf, responseSender) -> {
            StopSoundPacket packet = StopSoundPacket.decode(buf);
            client.execute(() -> Minecraft.m_91087_().m_91106_().m_120386_(packet.getSoundId(), SoundSource.PLAYERS));
        });
        ClientPlayNetworking.registerGlobalReceiver((ResourceLocation)SYNC_ITEM_STACK_ID, (client, handler, buf, responseSender) -> {
            int slot = buf.readInt();
            ItemStack stack = buf.m_130267_();
            client.execute(() -> {
                if (client.f_91074_ != null) {
                    client.f_91074_.m_150109_().m_6836_(slot, stack);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((ResourceLocation)SYNC_SIGNATURE_ABILITY, (client, handler, buf, responseSender) -> {
            ResourceLocation identifierPacket = buf.m_130281_();
            ResourceLocation identifierPacket2 = buf.m_130281_();
            String identifierString = identifierPacket.toString().replace("simplyskills:", "");
            String identifierString2 = identifierPacket2.toString().replace("simplyskills:", "");
            String stringPacket = buf.m_130277_().replace("simplyskills:", "") + "_signature_";
            String stringPacket2 = buf.m_130277_().replace("simplyskills:", "ascendancy_");
            String spritePath = null;
            String spritePath2 = null;
            if (stringPacket.contains("rogue")) {
                if (identifierString.equals(SkillReferencePosition.rogueSpecialisationSiphoningStrikes)) {
                    spritePath = "siphoning_strikes";
                } else if (identifierString.equals(SkillReferencePosition.rogueSpecialisationEvasion)) {
                    spritePath = "evasion";
                } else if (identifierString.equals(SkillReferencePosition.rogueSpecialisationPreparation)) {
                    spritePath = "preparation";
                }
            } else if (stringPacket.contains("ranger")) {
                if (identifierString.equals(SkillReferencePosition.rangerSpecialisationElementalArrows)) {
                    spritePath = "elemental_arrows";
                } else if (identifierString.equals(SkillReferencePosition.rangerSpecialisationArrowRain)) {
                    spritePath = "arrow_rain";
                } else if (identifierString.equals(SkillReferencePosition.rangerSpecialisationDisengage)) {
                    spritePath = "disengage";
                }
            } else if (stringPacket.contains("berserker")) {
                if (identifierString.equals(SkillReferencePosition.berserkerSpecialisationBloodthirsty)) {
                    spritePath = "bloodthirsty";
                } else if (identifierString.equals(SkillReferencePosition.berserkerSpecialisationBerserking)) {
                    spritePath = "berserking";
                } else if (identifierString.equals(SkillReferencePosition.berserkerSpecialisationRampage)) {
                    spritePath = "rampage";
                }
            } else if (stringPacket.contains("crusader")) {
                if (identifierString.equals(SkillReferencePosition.crusaderSpecialisationConsecration)) {
                    spritePath = "consecration";
                } else if (identifierString.equals(SkillReferencePosition.crusaderSpecialisationHeavensmithsCall)) {
                    spritePath = "heavensmiths_call";
                } else if (identifierString.equals(SkillReferencePosition.crusaderSpecialisationSacredOnslaught)) {
                    spritePath = "sacred_onslaught";
                }
            } else if (stringPacket.contains("cleric")) {
                if (identifierString.equals(SkillReferencePosition.clericSpecialisationSacredOrb)) {
                    spritePath = "sacred_orb";
                } else if (identifierString.equals(SkillReferencePosition.clericSpecialisationAnointWeapon)) {
                    spritePath = "anoint_weapon";
                } else if (identifierString.equals(SkillReferencePosition.clericSpecialisationDivineIntervention)) {
                    spritePath = "divine_intervention";
                }
            } else if (stringPacket.contains("wizard")) {
                if (identifierString.equals(SkillReferencePosition.wizardSpecialisationArcaneBolt)) {
                    spritePath = "arcane_bolt";
                } else if (identifierString.equals(SkillReferencePosition.wizardSpecialisationIceComet)) {
                    spritePath = "ice_comet";
                } else if (identifierString.equals(SkillReferencePosition.wizardSpecialisationMeteorShower)) {
                    spritePath = "meteor_shower";
                } else if (identifierString.equals(SkillReferencePosition.wizardSpecialisationStaticDischarge)) {
                    spritePath = "lightning_beam";
                }
            } else if (stringPacket.contains("spellblade")) {
                if (identifierString.equals(SkillReferencePosition.spellbladeSpecialisationElementalImpact)) {
                    spritePath = "elemental_impact";
                } else if (identifierString.equals(SkillReferencePosition.spellbladeSpecialisationElementalSurge)) {
                    spritePath = "elemental_surge";
                } else if (identifierString.equals(SkillReferencePosition.spellbladeSpecialisationSpellweaver)) {
                    spritePath = "spellweaver";
                }
            } else if (stringPacket.contains("necromancer") && identifierString.equals(SkillReferencePosition.necromancerSpecialisationSummoningRitual)) {
                spritePath = "summoning_ritual";
            }
            if (identifierString2.equals(SkillReferencePosition.ascendancyRighteousHammers)) {
                spritePath2 = "righteous_hammers";
            } else if (identifierString2.equals(SkillReferencePosition.ascendancyBoneArmor)) {
                spritePath2 = "bone_armor";
            } else if (identifierString2.equals(SkillReferencePosition.ascendancyCyclonicCleave)) {
                spritePath2 = "cyclonic_cleave";
            } else if (identifierString2.equals(SkillReferencePosition.ascendancyMagicCircle)) {
                spritePath2 = "magic_circle";
            } else if (identifierString2.equals(SkillReferencePosition.ascendancyArcaneSlash)) {
                spritePath2 = "arcane_slash";
            } else if (identifierString2.equals(SkillReferencePosition.ascendancyAgony)) {
                spritePath2 = "agony";
            } else if (identifierString2.equals(SkillReferencePosition.ascendancyTorment)) {
                spritePath2 = "torment";
            } else if (identifierString2.equals(SkillReferencePosition.ascendancyRapidfire)) {
                spritePath2 = "rapidfire";
            } else if (identifierString2.equals(SkillReferencePosition.ascendancyCataclysm)) {
                spritePath2 = "cataclysm";
            } else if (identifierString2.equals(SkillReferencePosition.ascendancyGhostwalk)) {
                spritePath2 = "ghostwalk";
            } else if (identifierString2.equals(SkillReferencePosition.ascendancySkywardSunder)) {
                spritePath2 = "skyward_sunder";
            } else if (identifierString2.equals(SkillReferencePosition.ascendancyRighteousShield)) {
                spritePath2 = "righteous_shield";
            } else if (identifierString2.equals(SkillReferencePosition.ascendancyChainbreaker)) {
                spritePath2 = "chainbreaker";
            }
            ResourceLocation newIdentifierPacket = null;
            ResourceLocation newIdentifierPacket2 = null;
            newIdentifierPacket = spritePath != null ? new ResourceLocation("simplyskills", "textures/icons/alternate_reduced/" + stringPacket + spritePath + ".png") : new ResourceLocation("simplyskills", "textures/gui/cooldown_overlay.png");
            newIdentifierPacket2 = spritePath2 != null ? new ResourceLocation("simplyskills", "textures/icons/alternate_reduced/ascendancy_" + spritePath2 + ".png") : new ResourceLocation("simplyskills", "textures/gui/cooldown_overlay.png");
            ResourceLocation finalNewIdentifierPacket = newIdentifierPacket;
            ResourceLocation finalNewIdentifierPacket2 = newIdentifierPacket2;
            client.execute(() -> {
                CustomHud.setSprite(finalNewIdentifierPacket);
                CustomHud.setSprite2(finalNewIdentifierPacket2);
            });
        });
    }

    public static void sendTo(ServerPlayer player, UpdateUnspentPointsPacket packet) {
        FriendlyByteBuf buf = PacketByteBufs.create();
        UpdateUnspentPointsPacket.encode(packet, buf);
        ServerPlayNetworking.send((ServerPlayer)player, (ResourceLocation)UPDATE_UNSPENT_POINTS_ID, (FriendlyByteBuf)buf);
    }

    public static void sendSignatureAbility(ServerPlayer player) {
        FriendlyByteBuf buf = PacketByteBufs.create();
        ResourceLocation identifier = new ResourceLocation("empty");
        ResourceLocation identifier2 = new ResourceLocation("empty");
        String stringSend = "empty";
        String stringSend2 = "empty";
        ArrayList<String> list = new ArrayList<String>();
        List<String> specialisationList = SimplySkills.getSpecialisationsAsArray();
        list.add(SkillReferencePosition.rogueSpecialisationPreparation);
        list.add(SkillReferencePosition.rogueSpecialisationEvasion);
        list.add(SkillReferencePosition.rogueSpecialisationSiphoningStrikes);
        list.add(SkillReferencePosition.rangerSpecialisationDisengage);
        list.add(SkillReferencePosition.rangerSpecialisationArrowRain);
        list.add(SkillReferencePosition.rangerSpecialisationElementalArrows);
        list.add(SkillReferencePosition.berserkerSpecialisationRampage);
        list.add(SkillReferencePosition.berserkerSpecialisationBerserking);
        list.add(SkillReferencePosition.berserkerSpecialisationBloodthirsty);
        list.add(SkillReferencePosition.crusaderSpecialisationConsecration);
        list.add(SkillReferencePosition.crusaderSpecialisationHeavensmithsCall);
        list.add(SkillReferencePosition.crusaderSpecialisationSacredOnslaught);
        list.add(SkillReferencePosition.clericSpecialisationAnointWeapon);
        list.add(SkillReferencePosition.clericSpecialisationSacredOrb);
        list.add(SkillReferencePosition.clericSpecialisationDivineIntervention);
        list.add(SkillReferencePosition.wizardSpecialisationIceComet);
        list.add(SkillReferencePosition.wizardSpecialisationMeteorShower);
        list.add(SkillReferencePosition.wizardSpecialisationArcaneBolt);
        list.add(SkillReferencePosition.wizardSpecialisationStaticDischarge);
        list.add(SkillReferencePosition.spellbladeSpecialisationElementalSurge);
        list.add(SkillReferencePosition.spellbladeSpecialisationElementalImpact);
        list.add(SkillReferencePosition.spellbladeSpecialisationSpellweaver);
        list.add(SkillReferencePosition.necromancerSpecialisationSummoningRitual);
        block0: for (String specialisations : specialisationList) {
            for (String string : list) {
                if (!HelperMethods.isUnlocked(specialisations, string, (LivingEntity)player)) continue;
                identifier = new ResourceLocation("simplyskills", string);
                stringSend = specialisations;
                continue block0;
            }
        }
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add(SkillReferencePosition.ascendancyRighteousHammers);
        list2.add(SkillReferencePosition.ascendancyBoneArmor);
        list2.add(SkillReferencePosition.ascendancyCyclonicCleave);
        list2.add(SkillReferencePosition.ascendancyMagicCircle);
        list2.add(SkillReferencePosition.ascendancyArcaneSlash);
        list2.add(SkillReferencePosition.ascendancyAgony);
        list2.add(SkillReferencePosition.ascendancyTorment);
        list2.add(SkillReferencePosition.ascendancyRapidfire);
        list2.add(SkillReferencePosition.ascendancyCataclysm);
        list2.add(SkillReferencePosition.ascendancyGhostwalk);
        list2.add(SkillReferencePosition.ascendancySkywardSunder);
        list2.add(SkillReferencePosition.ascendancyRighteousShield);
        list2.add(SkillReferencePosition.ascendancyChainbreaker);
        String ascendancyTree = "simplyskills:ascendancy";
        if (FabricLoader.getInstance().isModLoaded("prominent")) {
            ascendancyTree = "puffish_skills:prom";
        }
        for (String string : list2) {
            if (!HelperMethods.isUnlocked(ascendancyTree, string, (LivingEntity)player)) continue;
            identifier2 = new ResourceLocation("simplyskills", string);
            stringSend2 = string;
            break;
        }
        if (identifier != null && stringSend != null || stringSend2 != null) {
            buf.m_130085_(identifier);
            buf.m_130085_(identifier2);
            buf.m_130070_(stringSend);
            buf.m_130070_(stringSend2);
            ServerPlayNetworking.send((ServerPlayer)player, (ResourceLocation)SYNC_SIGNATURE_ABILITY, (FriendlyByteBuf)buf);
        }
    }

    public static void sendStopSoundPacket(ServerPlayer player, ResourceLocation soundId) {
        StopSoundPacket packet = new StopSoundPacket(soundId);
        FriendlyByteBuf buf = PacketByteBufs.create();
        StopSoundPacket.encode(packet, buf);
        ServerPlayNetworking.send((ServerPlayer)player, (ResourceLocation)STOP_SOUND_ID, (FriendlyByteBuf)buf);
    }

    public static void syncItemStackNbt(ServerPlayer player, int slot, ItemStack stack) {
        FriendlyByteBuf buf = PacketByteBufs.create();
        buf.writeInt(slot);
        buf.m_130055_(stack);
        ServerPlayNetworking.send((ServerPlayer)player, (ResourceLocation)SYNC_ITEM_STACK_ID, (FriendlyByteBuf)buf);
    }
}

