/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.util;

import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.puffish.skillsmod.api.SkillsAPI;
import net.sweenus.simplyskills.SimplySkills;

public class DynamicDamage {
    public static float dynamicDamageReduction(LivingEntity attacker, LivingEntity target, float amount, float lastDamageTaken, float damage, float lastDamageTime) {
        if (attacker != null && lastDamageTaken > 0.0f && SimplySkills.generalConfig.enableDDR && (!(target instanceof Player) || SimplySkills.generalConfig.DDRAffectsPlayers)) {
            Level world = attacker.m_9236_();
            float maxHp = target.m_21233_();
            float thresholdCheck = amount / maxHp;
            float ddrAttackSpeedWeight = (float)SimplySkills.generalConfig.DDRAttackSpeedWeight / 100.0f;
            float ddrAmount = (float)SimplySkills.generalConfig.DDRAmount / 100.0f;
            float ddrHealthThreshold = (float)SimplySkills.generalConfig.DDRHealthThreshold / 100.0f;
            float damageFrequency = 0.01f + ((float)world.m_46467_() - lastDamageTime) / (damage * ddrAttackSpeedWeight);
            float healthPercent = Math.min(damage / maxHp * damage, 0.9f * damage);
            float minimumHp = SimplySkills.generalConfig.DDRHealthRequirement;
            if (thresholdCheck > ddrHealthThreshold && maxHp >= minimumHp) {
                float damageReduction = Math.min(healthPercent * ddrAmount, damage / 2.0f);
                float newAmount = Math.max(damage - damageReduction, 1.0f) * Math.max(Math.min(damageFrequency, 1.0f), 0.3f);
                if (SimplySkills.generalConfig.enableDDRDebugLog && attacker instanceof Player) {
                    attacker.m_213846_((Component)Component.m_237113_((String)("\u00a7fDamage reduced from \u00a76" + damage + " \u00a7fto\u00a7a " + newAmount + " \u00a7fusing DR: \u00a76" + damageReduction + "\u00a7f & SDR: \u00a7b" + damageFrequency)));
                }
                return newAmount;
            }
        }
        return amount;
    }

    public static void dynamicAttributeScaling(LivingEntity entity, Attribute attribute, String name, double amount, UUID uuid) {
        LivingEntity livingEntity;
        if (entity.m_21188_() != null && (livingEntity = entity.m_21188_()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            AttributeInstance attributeInstance = entity.m_21051_(attribute);
            int pointsSpent = DynamicDamage.getSpentPoints(player);
            double totalAmount = amount * (double)pointsSpent;
            if (attributeInstance != null && attributeInstance.m_22111_(uuid) == null) {
                AttributeModifier modifier = new AttributeModifier(uuid, name, totalAmount, AttributeModifier.Operation.ADDITION);
                attributeInstance.m_22118_(modifier);
                if (attribute.equals(Attributes.f_22276_)) {
                    entity.m_5634_((float)totalAmount);
                }
            }
        }
    }

    public static void dynamicPlayerCountScaling(LivingEntity livingEntity) {
        double checkDistance = SimplySkills.generalConfig.DASRadius;
        List nearbyPlayers = livingEntity.m_9236_().m_6443_(ServerPlayer.class, livingEntity.m_20191_().m_82400_(checkDistance), playerEntity -> true);
        int totalPointsSpent = 0;
        int totalPlayerCount = 0;
        float entityTypeModifier = 1.0f;
        if (livingEntity instanceof AgeableMob || livingEntity instanceof AbstractSchoolingFish || livingEntity instanceof Villager || livingEntity instanceof ArmorStand) {
            entityTypeModifier = SimplySkills.generalConfig.DASPassiveEntityModifier;
        }
        for (ServerPlayer player : nearbyPlayers) {
            int pointsSpent = DynamicDamage.getSpentPoints(player);
            double playerCountDampener = (double)totalPointsSpent * ((double)(++totalPlayerCount) / (double)SimplySkills.generalConfig.DASPlayerScalingWeight);
            totalPointsSpent += (int)Math.max(((double)pointsSpent - playerCountDampener) * (double)entityTypeModifier, 0.0);
            if (!SimplySkills.generalConfig.enableDASDebugLog) continue;
            String message = "\u00a7fScaling \u00a76" + livingEntity.m_7755_().getString() + " \u00a7fusing\u00a7a " + player.m_7755_().getString() + " \u00a7fspent skill points of\u00a76 " + DynamicDamage.getSpentPoints(player) + "\u00a7f. Total scale factor: \u00a7b" + totalPointsSpent;
            player.m_213846_((Component)Component.m_237113_((String)message));
        }
        if (SimplySkills.generalConfig.enableDAS && !(livingEntity instanceof Player)) {
            double maxHealth;
            if (SimplySkills.generalConfig.enableDASDebugLog) {
                String message = "Attempting to apply DAS attributes to " + livingEntity.m_7755_().getString() + ". Player Count: " + totalPlayerCount + ". total points spent: " + totalPointsSpent;
                System.out.println(message);
            }
            float addRequirement = SimplySkills.generalConfig.addMultiHealthRequirement;
            double addHealth = 1.0;
            double addAttack = 1.0;
            double addArmor = 1.0;
            double addToughness = 1.0;
            double addSpeed = 1.0;
            double addResistance = 1.0;
            AttributeInstance attributeInstance = livingEntity.m_21051_(Attributes.f_22276_);
            if (attributeInstance != null && (maxHealth = attributeInstance.m_22115_()) >= (double)addRequirement) {
                addHealth = SimplySkills.generalConfig.DASHealthAddMulti;
                addAttack = SimplySkills.generalConfig.DASAttackAddMulti;
                addArmor = SimplySkills.generalConfig.DASArmorAddMulti;
                addToughness = SimplySkills.generalConfig.DASToughnessAddMulti;
                addSpeed = SimplySkills.generalConfig.DASSpeedAddMulti;
                addResistance = SimplySkills.generalConfig.DASResistAddMulti;
            }
            if (SimplySkills.generalConfig.DASHealth > 0.0) {
                DynamicDamage.dynamicTotalAttributeScaling(livingEntity, Attributes.f_22276_, "SimplySkills health DAS", SimplySkills.generalConfig.DASHealth, UUID.fromString("631937f6-bc47-486b-b07a-542823d668a6"), (double)totalPointsSpent * addHealth);
            }
            if (SimplySkills.generalConfig.DASAttack > 0.0) {
                DynamicDamage.dynamicTotalAttributeScaling(livingEntity, Attributes.f_22281_, "SimplySkills attack damage DAS", SimplySkills.generalConfig.DASAttack, UUID.fromString("8097403f-ed25-4534-b7f9-854e16ef2fbb"), (double)totalPointsSpent * addAttack);
            }
            if (SimplySkills.generalConfig.DASArmor > 0.0) {
                DynamicDamage.dynamicTotalAttributeScaling(livingEntity, Attributes.f_22284_, "SimplySkills armor DAS", SimplySkills.generalConfig.DASArmor, UUID.fromString("eae99963-45c4-4651-b501-4b2e16879705"), (double)totalPointsSpent * addArmor);
            }
            if (SimplySkills.generalConfig.DASArmorToughness > 0.0) {
                DynamicDamage.dynamicTotalAttributeScaling(livingEntity, Attributes.f_22285_, "SimplySkills armor toughness DAS", SimplySkills.generalConfig.DASArmorToughness, UUID.fromString("0794ab19-7dbd-421f-90c7-6b65e3aee495"), (double)totalPointsSpent * addToughness);
            }
            if (SimplySkills.generalConfig.DASSpeed / 100.0 > 0.0) {
                DynamicDamage.dynamicTotalAttributeScaling(livingEntity, Attributes.f_22279_, "SimplySkills movement speed DAS", SimplySkills.generalConfig.DASSpeed / 100.0, UUID.fromString("426d5ed8-020b-484f-93d9-4327a3c05c97"), (double)totalPointsSpent * addSpeed);
            }
            if (SimplySkills.generalConfig.DASKnockbackResist / 100.0 > 0.0) {
                DynamicDamage.dynamicTotalAttributeScaling(livingEntity, Attributes.f_22278_, "SimplySkills knockback resistance DAS", SimplySkills.generalConfig.DASKnockbackResist / 100.0, UUID.fromString("9ffef649-025d-4c30-98ed-d4378cd07d36"), (double)totalPointsSpent * addResistance);
            }
        }
    }

    public static void dynamicTotalAttributeScaling(LivingEntity entity, Attribute attribute, String name, double amount, UUID uuid, double pointsSpent) {
        AttributeInstance attributeInstance = entity.m_21051_(attribute);
        if (pointsSpent == 0.0) {
            if (attributeInstance != null && attributeInstance.m_22111_(uuid) != null) {
                if (attribute.equals(Attributes.f_22276_)) {
                    float healthRatio = entity.m_21223_() / entity.m_21233_();
                    attributeInstance.m_22120_(uuid);
                    entity.m_21153_(entity.m_21233_() * healthRatio);
                } else {
                    attributeInstance.m_22120_(uuid);
                }
            }
            return;
        }
        double totalAmount = amount * pointsSpent;
        if (attributeInstance != null) {
            AttributeModifier existingModifier = attributeInstance.m_22111_(uuid);
            if (existingModifier == null) {
                AttributeModifier newModifier = new AttributeModifier(uuid, name, totalAmount, AttributeModifier.Operation.ADDITION);
                attributeInstance.m_22118_(newModifier);
                if (attribute.equals(Attributes.f_22276_)) {
                    entity.m_5634_((float)totalAmount);
                }
            } else if (existingModifier.m_22218_() != totalAmount) {
                attributeInstance.m_22130_(existingModifier);
                AttributeModifier updatedModifier = new AttributeModifier(uuid, name, totalAmount, AttributeModifier.Operation.ADDITION);
                attributeInstance.m_22118_(updatedModifier);
                if (attribute.equals(Attributes.f_22276_)) {
                    double difference = totalAmount - existingModifier.m_22218_();
                    entity.m_5634_((float)difference);
                }
            }
        }
    }

    public static int getSpentPoints(ServerPlayer player) {
        return SkillsAPI.streamUnlockedCategories((ServerPlayer)player).mapToInt(category -> (int)category.streamUnlockedSkills(player).count()).sum();
    }
}

