/*
 * Decompiled with CFR 0.152.
 */
package net.fabric_extras.ranged_weapon.client;

import com.ibm.icu.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.fabric_extras.ranged_weapon.api.CustomRangedWeapon;
import net.fabric_extras.ranged_weapon.api.EntityAttributes_RangedWeapon;
import net.fabric_extras.ranged_weapon.client.TooltipUtil;
import net.minecraft.class_124;
import net.minecraft.class_1322;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_5250;
import net.minecraft.class_7417;

public class TooltipHelper {
    public static void updateTooltipText(class_1799 itemStack, List<class_2561> lines) {
        if (itemStack.method_7909() instanceof CustomRangedWeapon) {
            TooltipHelper.mergeAttributeLines_MainHandOffHand(lines);
            TooltipHelper.replaceAttributeLines_BlueWithGreen(lines);
        }
        TooltipUtil.addPullTime(itemStack, lines);
    }

    private static void mergeAttributeLines_MainHandOffHand(List<class_2561> tooltip) {
        ArrayList<class_2561> heldInHandLines = new ArrayList<class_2561>();
        ArrayList<class_2561> mainHandAttributes = new ArrayList<class_2561>();
        ArrayList<class_2561> offHandAttributes = new ArrayList<class_2561>();
        for (int i = 0; i < tooltip.size(); ++i) {
            class_2561 line = tooltip.get(i);
            class_7417 content = line.method_10851();
            if (!(content instanceof class_2588)) continue;
            class_2588 translatableText = (class_2588)content;
            if (translatableText.method_11022().startsWith("item.modifiers")) {
                heldInHandLines.add(line);
            }
            if (!translatableText.method_11022().startsWith("attribute.modifier")) continue;
            if (heldInHandLines.size() == 1) {
                mainHandAttributes.add(line);
            }
            if (heldInHandLines.size() != 2) continue;
            offHandAttributes.add(line);
        }
        if (heldInHandLines.size() == 2) {
            int mainHandLine = tooltip.indexOf(heldInHandLines.get(0));
            int offHandLine = tooltip.indexOf(heldInHandLines.get(1));
            tooltip.remove(mainHandLine);
            tooltip.add(mainHandLine, (class_2561)class_2561.method_43471((String)"item.modifiers.both_hands").method_27692(class_124.field_1080));
            tooltip.remove(offHandLine);
            for (class_2561 offhandAttribute : offHandAttributes) {
                if (!mainHandAttributes.contains(offhandAttribute)) continue;
                tooltip.remove(tooltip.lastIndexOf(offhandAttribute));
            }
            int lastIndex = tooltip.size() - 1;
            class_2561 lastLine = tooltip.get(lastIndex);
            if (lastLine.getString().isEmpty()) {
                tooltip.remove(lastIndex);
            }
        }
    }

    private static void replaceAttributeLines_BlueWithGreen(List<class_2561> tooltip) {
        String attributeTranslationKey = EntityAttributes_RangedWeapon.DAMAGE.translationKey;
        for (int i = 0; i < tooltip.size(); ++i) {
            class_2561 line = tooltip.get(i);
            class_7417 content = line.method_10851();
            if (!(content instanceof class_2588)) continue;
            class_2588 translatable = (class_2588)content;
            boolean isProjectileAttributeLine = false;
            double attributeValue = 0.0;
            if (translatable.method_11022().startsWith("attribute.modifier.plus.0")) {
                for (Object arg : translatable.method_11023()) {
                    class_2588 attributeTranslatable;
                    class_2561 attributeText;
                    class_7417 class_74172;
                    if (arg instanceof String) {
                        String string = (String)arg;
                        try {
                            Double number = Double.valueOf(string);
                            attributeValue = number;
                        }
                        catch (Exception number) {
                            // empty catch block
                        }
                    }
                    if (!(arg instanceof class_2561) || !((class_74172 = (attributeText = (class_2561)arg).method_10851()) instanceof class_2588) || !(attributeTranslatable = (class_2588)class_74172).method_11022().startsWith(attributeTranslationKey)) continue;
                    isProjectileAttributeLine = true;
                }
            }
            if (!isProjectileAttributeLine || !(attributeValue > 0.0)) continue;
            class_5250 greenAttributeLine = class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43469((String)("attribute.modifier.equals." + class_1322.class_1323.field_6328.method_6191()), (Object[])new Object[]{class_1799.field_8029.format(attributeValue), class_2561.method_43471((String)attributeTranslationKey)})).method_27692(class_124.field_1077);
            tooltip.set(i, (class_2561)greenAttributeLine);
        }
    }

    public static void addPullTime(class_1799 itemStack, List<class_2561> lines) {
        int lastAttributeLine;
        int pullTime = TooltipHelper.readablePullTime(itemStack);
        if (pullTime > 0 && (lastAttributeLine = TooltipHelper.getLastAttributeLine(lines)) > 0) {
            lines.add(lastAttributeLine + 1, (class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43469((String)"item.ranged_weapon.pull_time", (Object[])new Object[]{TooltipHelper.formattedNumber((float)pullTime / 20.0f)}).method_27692(class_124.field_1077)));
        }
    }

    private static int getLastAttributeLine(List<class_2561> lines) {
        int lastAttributeLine = -1;
        String attributePrefix = "attribute.modifier";
        String handPrefix = "item.modifiers";
        for (int i = 0; i < lines.size(); ++i) {
            class_2588 translatableText;
            String key;
            class_2561 line = lines.get(i);
            class_7417 content = line.method_10851();
            if (!(content instanceof class_2588) || !(key = (translatableText = (class_2588)content).method_11022()).startsWith(attributePrefix) && !key.startsWith(handPrefix)) continue;
            lastAttributeLine = i;
        }
        return lastAttributeLine;
    }

    private static int readablePullTime(class_1799 itemStack) {
        class_1792 item = itemStack.method_7909();
        if (item instanceof class_1764) {
            return class_1764.method_7775((class_1799)itemStack);
        }
        if (itemStack.method_31574(class_1802.field_8102)) {
            return 20;
        }
        if (item instanceof CustomRangedWeapon) {
            CustomRangedWeapon customBow = (CustomRangedWeapon)item;
            return customBow.getRangedWeaponConfig().pull_time();
        }
        return 0;
    }

    private static String formattedNumber(float number) {
        DecimalFormat formatter = new DecimalFormat();
        formatter.setMaximumFractionDigits(1);
        return formatter.format((double)number);
    }
}

