/*
 * Decompiled with CFR 0.152.
 */
package io.github.frqnny.mostructures.processor;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.frqnny.mostructures.init.ProcessorTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.Nullable;

public class SimpleStoneStructureProcessor
extends StructureProcessor {
    public static final Codec<SimpleStoneStructureProcessor> CODEC = RecordCodecBuilder.create(proc -> proc.group((App)Codec.FLOAT.fieldOf("mossiness").forGetter(processor -> Float.valueOf(processor.mossiness))).apply((Applicative)proc, SimpleStoneStructureProcessor::new));
    private final float mossiness;

    public SimpleStoneStructureProcessor(float mossiness) {
        this.mossiness = mossiness;
    }

    private static BlockState randomStairProperties(RandomSource random, Block stairs) {
        return (BlockState)((BlockState)stairs.m_49966_().m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.Plane.HORIZONTAL.m_235690_(random))).m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.values()[random.m_188503_(Half.values().length)]);
    }

    private static BlockState randomState(RandomSource random, BlockState[] states) {
        return states[random.m_188503_(states.length)];
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader worldView, BlockPos pos, BlockPos blockPos, StructureTemplate.StructureBlockInfo structureBlockInfo, StructureTemplate.StructureBlockInfo structureBlockInfo2, StructurePlaceSettings structurePlacementData) {
        RandomSource random = structurePlacementData.m_230326_(structureBlockInfo2.f_74675_());
        BlockState blockState = structureBlockInfo2.f_74676_();
        BlockPos blockPos2 = structureBlockInfo2.f_74675_();
        BlockState blockState2 = null;
        if (blockState.m_60713_(Blocks.f_50222_) || blockState.m_60713_(Blocks.f_50069_) || blockState.m_60713_(Blocks.f_50225_)) {
            blockState2 = this.processBlocks(random);
        }
        return blockState2 != null ? new StructureTemplate.StructureBlockInfo(blockPos2, blockState2, structureBlockInfo2.f_74677_()) : structureBlockInfo2;
    }

    @Nullable
    private BlockState processBlocks(RandomSource random) {
        if (random.m_188501_() >= 0.5f) {
            return null;
        }
        BlockState[] blockStates = new BlockState[]{Blocks.f_50224_.m_49966_(), SimpleStoneStructureProcessor.randomStairProperties(random, Blocks.f_50194_)};
        BlockState[] blockStates2 = new BlockState[]{Blocks.f_50223_.m_49966_(), SimpleStoneStructureProcessor.randomStairProperties(random, Blocks.f_50631_)};
        return this.process(random, blockStates, blockStates2);
    }

    private BlockState process(RandomSource random, BlockState[] regularStates, BlockState[] mossyStates) {
        return random.m_188501_() < this.mossiness ? SimpleStoneStructureProcessor.randomState(random, mossyStates) : SimpleStoneStructureProcessor.randomState(random, regularStates);
    }

    protected StructureProcessorType<?> m_6953_() {
        return ProcessorTypes.SIMPLE_STONE;
    }
}

