/*
 * Decompiled with CFR 0.152.
 */
package io.github.frqnny.mostructures.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.frqnny.mostructures.init.Structures;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class ModStructure
extends Structure {
    public static final Codec<ModStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Structure.StructureSettings.f_226688_.forGetter(feature -> feature.getModifiedStructureSettings()), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)7).fieldOf("size").forGetter(structure -> structure.size), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Codec.BOOL.fieldOf("use_expansion_hack").forGetter(structure -> structure.useExpansionHack), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.intRange((int)-1, (int)100).fieldOf("heightRange").orElse((Object)-1).forGetter(structure -> structure.heightRange)).apply((Applicative)instance, ModStructure::new));
    public final Holder<StructureTemplatePool> startPool;
    public final int heightRange;
    private final Optional<ResourceLocation> startJigsawName;
    private final int size;
    private final HeightProvider startHeight;
    private final boolean useExpansionHack;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;

    public ModStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, boolean useExpansionHack, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter, int heightRange) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.useExpansionHack = useExpansionHack;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
        this.heightRange = heightRange;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        if (this.canGenerate(context.f_226622_(), context.f_226628_(), context.f_226629_(), context.f_226624_())) {
            ChunkPos chunkPos = context.f_226628_();
            int y = this.startHeight.m_213859_((RandomSource)context.f_226626_(), new WorldGenerationContext(context.f_226622_(), context.f_226629_()));
            BlockPos blockPos = new BlockPos(chunkPos.m_45604_(), y, chunkPos.m_45605_());
            return JigsawPlacement.m_227238_((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)this.size, (BlockPos)blockPos, (boolean)this.useExpansionHack, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter);
        }
        return Optional.empty();
    }

    public boolean canGenerate(ChunkGenerator chunkGenerator, ChunkPos pos, LevelHeightAccessor world, RandomState noiseConfig) {
        int heightRange = this.heightRange;
        if (heightRange != -1) {
            int maxTerrainHeight = Integer.MIN_VALUE;
            int minTerrainHeight = Integer.MAX_VALUE;
            for (int curChunkX = pos.f_45578_ - 2; curChunkX <= pos.f_45578_ + 2; ++curChunkX) {
                for (int curChunkZ = pos.f_45579_ - 2; curChunkZ <= pos.f_45579_ + 2; ++curChunkZ) {
                    int height = chunkGenerator.m_214096_((curChunkX << 4) + 7, (curChunkZ << 4) + 7, Heightmap.Types.WORLD_SURFACE_WG, world, noiseConfig);
                    maxTerrainHeight = Math.max(maxTerrainHeight, height);
                    minTerrainHeight = Math.min(minTerrainHeight, height);
                }
            }
            return maxTerrainHeight - minTerrainHeight <= heightRange;
        }
        return true;
    }

    public StructureType<?> m_213658_() {
        return Structures.GENERIC;
    }
}

