/*
 * Decompiled with CFR 0.152.
 */
package io.github.frqnny.mostructures.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.frqnny.mostructures.init.Structures;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;

public class ModStructurePlacement
extends RandomSpreadStructurePlacement {
    public static final Codec<ModStructurePlacement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Vec3i.m_194650_((int)16).optionalFieldOf("locate_offset", (Object)Vec3i.f_123288_).forGetter(rec$ -> ((ModStructurePlacement)((Object)((Object)((Object)rec$)))).m_227072_()), (App)StructurePlacement.FrequencyReductionMethod.f_227108_.optionalFieldOf("frequency_reduction_method", (Object)StructurePlacement.FrequencyReductionMethod.DEFAULT).forGetter(rec$ -> ((ModStructurePlacement)((Object)((Object)((Object)rec$)))).m_227073_()), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("frequency", (Object)Float.valueOf(1.0f)).forGetter(rec$ -> Float.valueOf(((ModStructurePlacement)((Object)((Object)((Object)rec$)))).m_227074_())), (App)ExtraCodecs.f_144628_.fieldOf("salt").forGetter(rec$ -> ((ModStructurePlacement)((Object)((Object)((Object)rec$)))).m_227075_()), (App)RegistryFileCodec.m_135592_((ResourceKey)Registries.f_256998_, (Codec)StructureSet.f_210001_, (boolean)false).listOf().fieldOf("structure_set_to_avoid").orElse(new ArrayList(20)).forGetter(config -> config.structureSetToAvoid), (App)Codec.intRange((int)0, (int)4096).fieldOf("spacing").forGetter(ModStructurePlacement::m_205003_), (App)Codec.intRange((int)0, (int)4096).fieldOf("separation").forGetter(ModStructurePlacement::m_205004_), (App)RandomSpreadType.f_205014_.optionalFieldOf("spread_type", (Object)RandomSpreadType.LINEAR).forGetter(ModStructurePlacement::m_205005_)).apply((Applicative)instance, ModStructurePlacement::new));
    public final List<Holder<StructureSet>> structureSetToAvoid;
    private final RandomSpreadType spreadType;
    private int spacing;
    private int separation;
    private boolean activated;

    public ModStructurePlacement(Vec3i locateOffset, StructurePlacement.FrequencyReductionMethod frequencyReductionMethod, float frequency, int salt, List<Holder<StructureSet>> structureSetToAvoid, int spacing, int separation, RandomSpreadType spreadType) {
        super(locateOffset, frequencyReductionMethod, frequency, salt, Optional.empty(), spacing, separation, spreadType);
        this.spacing = spacing;
        this.separation = separation;
        this.spreadType = spreadType;
        this.structureSetToAvoid = structureSetToAvoid;
    }

    public static boolean shouldExclude(ChunkGeneratorStructureState calculator, Holder<StructureSet> structureSetEntry, int centerChunkX, int centerChunkZ, int chunkCount) {
        StructurePlacement structurePlacement = ((StructureSet)structureSetEntry.m_203334_()).f_210004_();
        if (structurePlacement instanceof ModStructurePlacement) {
            ModStructurePlacement structurePlacement2 = (ModStructurePlacement)structurePlacement;
            for (int i = centerChunkX - chunkCount; i <= centerChunkX + chunkCount; ++i) {
                for (int j = centerChunkZ - chunkCount; j <= centerChunkZ + chunkCount; ++j) {
                    if (!structurePlacement2.shouldGenerateNoExclusionCheck(calculator, i, j)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void setActivated(boolean activated) {
        this.activated = activated;
    }

    public int m_205003_() {
        return this.spacing;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    public int m_205004_() {
        return this.separation;
    }

    public void setSeparation(int separation) {
        this.separation = separation;
    }

    public RandomSpreadType m_205005_() {
        return this.spreadType;
    }

    public ChunkPos m_227008_(long seed, int chunkX, int chunkZ) {
        int regionX = Math.floorDiv(chunkX, this.spacing);
        int regionZ = Math.floorDiv(chunkZ, this.spacing);
        WorldgenRandom chunkRandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        chunkRandom.m_190058_(seed, regionX, regionZ, this.m_227075_());
        int distance = this.spacing - this.separation;
        int nextXDistance = this.spreadType.m_227018_((RandomSource)chunkRandom, distance);
        int nextZDistance = this.spreadType.m_227018_((RandomSource)chunkRandom, distance);
        return new ChunkPos(regionX * this.spacing + nextXDistance, regionZ * this.spacing + nextZDistance);
    }

    protected boolean m_214090_(ChunkGeneratorStructureState calculator, int chunkX, int chunkZ) {
        ChunkPos chunkPos = this.m_227008_(calculator.m_254887_(), chunkX, chunkZ);
        return chunkPos.f_45578_ == chunkX && chunkPos.f_45579_ == chunkZ;
    }

    public boolean m_255071_(ChunkGeneratorStructureState calculator, int chunkX, int chunkZ) {
        if (!this.activated) {
            return false;
        }
        if (!this.m_214090_(calculator, chunkX, chunkZ)) {
            return false;
        }
        if (this.m_227074_() < 1.0f && !this.m_227073_().m_227119_(calculator.m_254887_(), this.m_227075_(), chunkX, chunkZ, this.m_227074_())) {
            return false;
        }
        if (!this.structureSetToAvoid.isEmpty()) {
            for (Holder<StructureSet> entry : this.structureSetToAvoid) {
                if (!ModStructurePlacement.shouldExclude(calculator, entry, chunkX, chunkZ, 3)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean shouldGenerateNoExclusionCheck(ChunkGeneratorStructureState calculator, int chunkX, int chunkZ) {
        if (!this.activated) {
            return false;
        }
        if (!this.m_214090_(calculator, chunkX, chunkZ)) {
            return false;
        }
        return !(this.m_227074_() < 1.0f) || this.m_227073_().m_227119_(calculator.m_254887_(), this.m_227075_(), chunkX, chunkZ, this.m_227074_());
    }

    public StructurePlacementType<?> m_203443_() {
        return Structures.TYPE;
    }
}

