/*
 * Decompiled with CFR 0.152.
 */
package net.archers;

import net.archers.block.ArcherBlocks;
import net.archers.config.ArchersItemConfig;
import net.archers.config.Default;
import net.archers.config.TweaksConfig;
import net.archers.effect.Effects;
import net.archers.item.Armors;
import net.archers.item.Group;
import net.archers.item.Weapons;
import net.archers.item.misc.Misc;
import net.archers.util.SoundHelper;
import net.archers.village.ArcherVillagers;
import net.fabric_extras.ranged_weapon.api.CrossbowMechanics;
import net.fabric_extras.structure_pool.api.StructurePoolConfig;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.spell_engine.api.item.trinket.SpellBooks;
import net.spell_engine.api.spell.SpellContainer;
import net.spell_power.api.enchantment.EnchantmentRestriction;
import net.tinyconfig.ConfigManager;

public class ArchersMod
implements ModInitializer {
    public static final String ID = "archers";
    public static ConfigManager<ArchersItemConfig> itemConfig = new ConfigManager("items_v2", (Object)Default.itemConfig).builder().setDirectory("archers").sanitize(true).build();
    public static ConfigManager<StructurePoolConfig> villagesConfig = new ConfigManager("villages", (Object)Default.villages).builder().setDirectory("archers").sanitize(true).build();
    public static ConfigManager<TweaksConfig> tweaksConfig = new ConfigManager("tweaks", (Object)new TweaksConfig()).builder().setDirectory("archers").sanitize(true).build();

    public void onInitialize() {
        tweaksConfig.refresh();
        this.registerItemGroup();
        this.registerItems();
        SoundHelper.registerSounds();
        Effects.register();
        this.registerVillages();
        this.subscribeEvents();
        if (((TweaksConfig)ArchersMod.tweaksConfig.value).enable_infinity_for_crossbows) {
            EnchantmentRestriction.permit((Enchantment)Enchantments.f_44952_, itemStack -> itemStack.m_41720_() instanceof CrossbowItem);
        }
        CrossbowMechanics.PullTime.modifier = (originalPullTime, crossbow) -> {
            int quickCharge = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)crossbow);
            float multiplier = ((TweaksConfig)ArchersMod.tweaksConfig.value).quick_charge_enchantment_multiplier_per_level;
            return originalPullTime - (int)((double)originalPullTime * (double)multiplier) * quickCharge;
        };
    }

    private void registerItemGroup() {
        Group.ARCHERS = FabricItemGroup.builder().m_257737_(() -> new ItemStack((ItemLike)Armors.archerArmorSet_T2.head.m_5456_())).m_257941_((Component)Component.m_237115_((String)"itemGroup.archers.general")).m_257652_();
        Registry.m_194579_((Registry)BuiltInRegistries.f_279662_, Group.KEY, (Object)Group.ARCHERS);
    }

    private void registerItems() {
        itemConfig.refresh();
        SpellBooks.createAndRegister((ResourceLocation)new ResourceLocation(ID, "archer"), (SpellContainer.ContentType)SpellContainer.ContentType.ARCHERY, Group.KEY);
        ArcherBlocks.register();
        Misc.register();
        Weapons.register(((ArchersItemConfig)ArchersMod.itemConfig.value).ranged_weapons, ((ArchersItemConfig)ArchersMod.itemConfig.value).melee_weapons);
        Armors.register(((ArchersItemConfig)ArchersMod.itemConfig.value).armor_sets);
        itemConfig.save();
    }

    private void registerVillages() {
        villagesConfig.refresh();
        ArcherVillagers.register();
    }

    private void subscribeEvents() {
    }
}

