/*
 * Decompiled with CFR 0.152.
 */
package net.archers.village;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import net.archers.ArchersMod;
import net.archers.block.ArcherBlocks;
import net.archers.item.Armors;
import net.archers.item.Weapons;
import net.archers.util.SoundHelper;
import net.fabric_extras.structure_pool.api.StructurePoolAPI;
import net.fabric_extras.structure_pool.api.StructurePoolConfig;
import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.fabricmc.fabric.api.object.builder.v1.world.poi.PointOfInterestHelper;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class ArcherVillagers {
    public static final String ARCHERY_ARTISAN = "archery_artisan";

    public static PoiType registerPOI(String name, Block block) {
        return PointOfInterestHelper.register((ResourceLocation)new ResourceLocation("archers", name), (int)1, (int)10, (Iterable)ImmutableSet.copyOf((Collection)block.m_49965_().m_61056_()));
    }

    public static VillagerProfession registerProfession(String name, ResourceKey<PoiType> workStation) {
        ResourceLocation id = new ResourceLocation("archers", name);
        return (VillagerProfession)Registry.m_122965_((Registry)BuiltInRegistries.f_256735_, (ResourceLocation)new ResourceLocation("archers", name), (Object)new VillagerProfession(id.toString(), entry -> entry.m_203565_(workStation), entry -> entry.m_203565_(workStation), ImmutableSet.of(), ImmutableSet.of(), SoundHelper.WORKBENCH));
    }

    public static void register() {
        StructurePoolAPI.injectAll((StructurePoolConfig)((StructurePoolConfig)ArchersMod.villagesConfig.value));
        PoiType poi = ArcherVillagers.registerPOI(ARCHERY_ARTISAN, ArcherBlocks.WORKBENCH.block());
        VillagerProfession profession = ArcherVillagers.registerProfession(ARCHERY_ARTISAN, (ResourceKey<PoiType>)ResourceKey.m_135785_((ResourceKey)BuiltInRegistries.f_256941_.m_123023_(), (ResourceLocation)new ResourceLocation("archers", ARCHERY_ARTISAN)));
        List<Offer> offers = List.of(Offer.sell(1, new ItemStack((ItemLike)Items.f_42412_, 8), 2, 128, 1, 0.01f), Offer.buy(1, new ItemStack((ItemLike)Items.f_42454_, 8), 5, 12, 4, 0.01f), Offer.sell(2, Weapons.composite_longbow.item().m_7968_(), 12, 12, 10, 0.1f), Offer.sell(2, Armors.archerArmorSet_T1.head.m_7968_(), 15, 12, 13, 0.05f), Offer.buy(2, new ItemStack((ItemLike)Items.f_42401_, 5), 3, 12, 4, 0.01f), Offer.sell(3, Armors.archerArmorSet_T1.feet.m_7968_(), 15, 12, 13, 0.05f), Offer.buy(3, new ItemStack((ItemLike)Items.f_42451_, 12), 3, 12, 5, 0.01f), Offer.sell(3, Armors.archerArmorSet_T1.legs.m_7968_(), 15, 12, 13, 0.05f), Offer.sell(4, Armors.archerArmorSet_T1.chest.m_7968_(), 15, 12, 13, 0.05f), Offer.sell(4, new ItemStack((ItemLike)Items.f_42355_, 3), 20, 12, 5, 0.01f));
        for (Offer offer : offers) {
            TradeOfferHelper.registerVillagerOffers((VillagerProfession)profession, (int)offer.level, factories -> factories.add((entity, random) -> new MerchantOffer(offer.input, offer.output, offer.maxUses, offer.experience, offer.priceMultiplier)));
        }
        TradeOfferHelper.registerVillagerOffers((VillagerProfession)profession, (int)5, factories -> {
            factories.add((entity, random) -> new VillagerTrades.EnchantedItemForEmeralds(Weapons.royal_longbow.item(), 40, 3, 30, 0.0f).m_213663_(entity, random));
            factories.add((entity, random) -> new VillagerTrades.EnchantedItemForEmeralds(Weapons.mechanic_shortbow.item(), 40, 3, 30, 0.0f).m_213663_(entity, random));
            factories.add((entity, random) -> new VillagerTrades.EnchantedItemForEmeralds(Weapons.rapid_crossbow.item(), 40, 3, 30, 0.0f).m_213663_(entity, random));
            factories.add((entity, random) -> new VillagerTrades.EnchantedItemForEmeralds(Weapons.heavy_crossbow.item(), 40, 3, 30, 0.0f).m_213663_(entity, random));
        });
    }

    private static class Offer {
        int level;
        ItemStack input;
        ItemStack output;
        int maxUses;
        int experience;
        float priceMultiplier;

        public Offer(int level, ItemStack input, ItemStack output, int maxUses, int experience, float priceMultiplier) {
            this.level = level;
            this.input = input;
            this.output = output;
            this.maxUses = maxUses;
            this.experience = experience;
            this.priceMultiplier = priceMultiplier;
        }

        public static Offer buy(int level, ItemStack item, int price, int maxUses, int experience, float priceMultiplier) {
            return new Offer(level, item, new ItemStack((ItemLike)Items.f_42616_, price), maxUses, experience, priceMultiplier);
        }

        public static Offer sell(int level, ItemStack item, int price, int maxUses, int experience, float priceMultiplier) {
            return new Offer(level, new ItemStack((ItemLike)Items.f_42616_, price), item, maxUses, experience, priceMultiplier);
        }
    }
}

