/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class ItemConfig {
    public Map<String, Weapon> weapons = new HashMap<String, Weapon>();
    public Map<String, ArmorSet> armor_sets = new HashMap<String, ArmorSet>();

    public static class ArmorSet {
        public float armor_toughness = 0.0f;
        public float knockback_resistance = 0.0f;
        public Piece head = new Piece();
        public Piece chest = new Piece();
        public Piece legs = new Piece();
        public Piece feet = new Piece();

        public static ArmorSet with(Piece head, Piece chest, Piece legs, Piece feet) {
            ArmorSet set = new ArmorSet();
            set.head = head;
            set.chest = chest;
            set.legs = legs;
            set.feet = feet;
            return set;
        }

        public static class Piece {
            public int armor = 0;
            public ArrayList<Attribute> attributes = new ArrayList();

            public Piece() {
            }

            public Piece(int armor) {
                this.armor = armor;
            }

            public Piece add(Attribute attribute) {
                this.attributes.add(attribute);
                return this;
            }

            public Piece addAll(List<Attribute> attributes) {
                this.attributes.addAll(attributes);
                return this;
            }
        }
    }

    public static class Weapon {
        public float attack_damage = 0.0f;
        public float attack_speed = 0.0f;
        public ArrayList<Attribute> attributes = new ArrayList();

        public Weapon() {
        }

        public Weapon(float attack_damage, float attack_speed) {
            this.attack_damage = attack_damage;
            this.attack_speed = attack_speed;
        }

        public Weapon add(Attribute attribute) {
            this.attributes.add(attribute);
            return this;
        }
    }

    public static class Attribute {
        public String id;
        public float value;
        public AttributeModifier.Operation operation;

        public Attribute() {
        }

        public Attribute(String id, float value, AttributeModifier.Operation operation) {
            this.id = id;
            this.value = value;
            this.operation = operation;
        }

        public static Attribute bonus(ResourceLocation attributeId, float value) {
            return new Attribute(attributeId.toString(), value, AttributeModifier.Operation.ADDITION);
        }

        public static Attribute multiply(ResourceLocation attributeId, float value) {
            return new Attribute(attributeId.toString(), value, AttributeModifier.Operation.MULTIPLY_BASE);
        }

        public static ArrayList<Attribute> bonuses(List<ResourceLocation> attributeIds, float value) {
            ArrayList<Attribute> spellAttributes = new ArrayList<Attribute>();
            for (ResourceLocation attributeId : attributeIds) {
                spellAttributes.add(new Attribute(attributeId.toString(), value, AttributeModifier.Operation.ADDITION));
            }
            return spellAttributes;
        }
    }
}

