/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.item.weapon;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.spell_engine.api.item.AttributeResolver;
import net.spell_engine.api.item.ConfigurableAttributes;
import net.spell_engine.api.item.ItemConfig;
import org.jetbrains.annotations.Nullable;

public class Weapon {
    private static final UUID miscWeaponAttributeUUID = UUID.fromString("c102cb57-a7b8-4a98-8c6e-2cd7b70b74c1");
    private static final ResourceLocation attackDamageId = new ResourceLocation("generic.attack_damage");
    private static final ResourceLocation projectileDamageId = new ResourceLocation("projectile_damage", "generic");

    public static void register(Map<String, ItemConfig.Weapon> configs, List<Entry> entries, ResourceKey<CreativeModeTab> itemGroupKey) {
        for (Entry entry : entries) {
            ItemConfig.Weapon config = configs.get(entry.name);
            if (config == null) {
                config = entry.defaults;
                configs.put(entry.name(), config);
            }
            if (!entry.isRequiredModInstalled()) continue;
            Item item = entry.item();
            ((ConfigurableAttributes)item).setAttributes(Weapon.attributesFrom(config));
            Registry.m_122965_((Registry)BuiltInRegistries.f_257033_, (ResourceLocation)entry.id(), (Object)item);
        }
        ItemGroupEvents.modifyEntriesEvent(itemGroupKey).register(content -> {
            for (Entry entry : entries) {
                content.m_246326_((ItemLike)entry.item());
            }
        });
    }

    public static Multimap<Attribute, AttributeModifier> attributesFrom(ItemConfig.Weapon config) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(ItemAccessor.ATTACK_DAMAGE_MODIFIER_ID(), "Weapon modifier", (double)config.attack_damage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(ItemAccessor.ATTACK_SPEED_MODIFIER_ID(), "Weapon modifier", (double)config.attack_speed, AttributeModifier.Operation.ADDITION));
        Map<Attribute, AttributeModifier> attributes = Weapon.attributesFrom(config.attributes);
        for (Map.Entry<Attribute, AttributeModifier> entry : attributes.entrySet()) {
            builder.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        return builder.build();
    }

    public static Map<Attribute, AttributeModifier> attributesFrom(List<ItemConfig.Attribute> attributes) {
        LinkedHashMap<Attribute, AttributeModifier> resolvedAttributes = new LinkedHashMap<Attribute, AttributeModifier>();
        for (ItemConfig.Attribute attribute : attributes) {
            if (attribute.value == 0.0f) continue;
            try {
                ResourceLocation attributeId = new ResourceLocation(attribute.id);
                Attribute entityAttribute = AttributeResolver.get(attributeId);
                UUID uuid = attributeId.equals((Object)attackDamageId) || attributeId.equals((Object)projectileDamageId) ? ItemAccessor.ATTACK_DAMAGE_MODIFIER_ID() : miscWeaponAttributeUUID;
                resolvedAttributes.put(entityAttribute, new AttributeModifier(uuid, "Weapon modifier", (double)attribute.value, attribute.operation));
            }
            catch (Exception e) {
                System.err.println("Failed to add item attribute modifier: " + e.getMessage());
            }
        }
        return resolvedAttributes;
    }

    public static final class Entry {
        private final String namespace;
        private final String name;
        private final CustomMaterial material;
        private final Item item;
        private final ItemConfig.Weapon defaults;
        @Nullable
        private String requiredMod;

        public Entry(String namespace, String name, CustomMaterial material, Item item, ItemConfig.Weapon defaults, @Nullable String requiredMod) {
            this.namespace = namespace;
            this.name = name;
            this.material = material;
            this.item = item;
            this.defaults = defaults;
            this.requiredMod = requiredMod;
        }

        public ResourceLocation id() {
            return new ResourceLocation(this.namespace, this.name);
        }

        public Entry attribute(ItemConfig.Attribute attribute) {
            this.defaults.add(attribute);
            return this;
        }

        public Entry requires(String modName) {
            this.requiredMod = modName;
            return this;
        }

        public boolean isRequiredModInstalled() {
            if (this.requiredMod == null || this.requiredMod.isEmpty()) {
                return true;
            }
            return FabricLoader.getInstance().isModLoaded(this.requiredMod);
        }

        public String name() {
            return this.name;
        }

        public CustomMaterial material() {
            return this.material;
        }

        public Item item() {
            return this.item;
        }

        public ItemConfig.Weapon defaults() {
            return this.defaults;
        }

        @Nullable
        public String requiredMod() {
            return this.requiredMod;
        }
    }

    private static abstract class ItemAccessor
    extends Item {
        public ItemAccessor(Item.Properties settings) {
            super(settings);
        }

        public static UUID ATTACK_DAMAGE_MODIFIER_ID() {
            return f_41374_;
        }

        public static UUID ATTACK_SPEED_MODIFIER_ID() {
            return f_41375_;
        }
    }

    public static class CustomMaterial
    implements Tier {
        private int miningLevel = 0;
        private int durability = 0;
        private float miningSpeed = 0.0f;
        private int enchantability = 0;
        private LazyLoadedValue<Ingredient> ingredient = null;

        public static CustomMaterial matching(Tiers vanillaMaterial, Supplier<Ingredient> repairIngredient) {
            CustomMaterial material = new CustomMaterial();
            material.miningLevel = vanillaMaterial.m_6604_();
            material.durability = vanillaMaterial.m_6609_();
            material.miningSpeed = vanillaMaterial.m_6624_();
            material.enchantability = vanillaMaterial.m_6601_();
            material.ingredient = new LazyLoadedValue(repairIngredient);
            return material;
        }

        public int m_6609_() {
            return this.durability;
        }

        public float m_6624_() {
            return this.miningSpeed;
        }

        public float m_6631_() {
            return 0.0f;
        }

        public int m_6604_() {
            return this.miningLevel;
        }

        public int m_6601_() {
            return this.enchantability;
        }

        public Ingredient m_6282_() {
            return (Ingredient)this.ingredient.m_13971_();
        }
    }
}

