/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client;

import java.util.List;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.client.animation.AnimatablePlayer;
import net.spell_engine.config.ServerConfig;
import net.spell_engine.internals.SpellRegistry;
import net.spell_engine.internals.casting.SpellCasterEntity;
import net.spell_engine.network.Packets;
import net.spell_engine.particle.ParticleHelper;

public class ClientNetwork {
    public static void initializeHandlers() {
        ClientPlayNetworking.registerGlobalReceiver((ResourceLocation)Packets.ConfigSync.ID, (client, handler, buf, responseSender) -> {
            ServerConfig config;
            SpellEngineMod.config = config = Packets.ConfigSync.read(buf);
        });
        ClientPlayNetworking.registerGlobalReceiver((ResourceLocation)Packets.SpellRegistrySync.ID, (client, handler, buf, responseSender) -> SpellRegistry.decodeContent(buf));
        ClientPlayNetworking.registerGlobalReceiver((ResourceLocation)Packets.ParticleBatches.ID, (client, handler, buf, responseSender) -> {
            Packets.ParticleBatches packet = Packets.ParticleBatches.read(buf);
            List<ParticleHelper.SpawnInstruction> instructions = ParticleHelper.convertToInstructions((Level)client.f_91073_, packet);
            client.execute(() -> {
                for (ParticleHelper.SpawnInstruction instruction : instructions) {
                    instruction.perform((Level)client.f_91073_);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((ResourceLocation)Packets.SpellAnimation.ID, (client, handler, buf, responseSender) -> {
            Packets.SpellAnimation packet = Packets.SpellAnimation.read(buf);
            client.execute(() -> {
                Entity entity = client.f_91073_.m_6815_(packet.playerId());
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    ((AnimatablePlayer)player).playSpellAnimation(packet.type(), packet.name(), packet.speed());
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((ResourceLocation)Packets.SpellCooldown.ID, (client, handler, buf, responseSender) -> {
            Packets.SpellCooldown packet = Packets.SpellCooldown.read(buf);
            client.execute(() -> ((SpellCasterEntity)client.f_91074_).getCooldownManager().set(packet.spellId(), packet.duration()));
        });
    }
}

