/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client;

import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.spell_engine.client.ClientNetwork;
import net.spell_engine.client.animation.AnimationRegistry;
import net.spell_engine.client.compatibility.ShaderCompatibility;
import net.spell_engine.client.render.BeamRenderer;
import net.spell_engine.client.render.ModelPredicateHelper;
import net.spell_engine.client.render.SpellBindingBlockEntityRenderer;
import net.spell_engine.config.ClientConfig;
import net.spell_engine.config.ClientConfigWrapper;
import net.spell_engine.config.HudConfig;
import net.spell_engine.spellbinding.SpellBindingBlockEntity;
import net.spell_engine.spellbinding.SpellBindingScreen;
import net.spell_engine.spellbinding.SpellBindingScreenHandler;
import net.tinyconfig.ConfigManager;

public class SpellEngineClient {
    public static ClientConfig config;
    public static ConfigManager<HudConfig> hudConfig;

    public static void initialize() {
        AutoConfig.register(ClientConfigWrapper.class, (ConfigSerializer.Factory)PartitioningSerializer.wrap(JanksonConfigSerializer::new));
        config = ((ClientConfigWrapper)AutoConfig.getConfigHolder(ClientConfigWrapper.class).getConfig()).client;
        hudConfig.refresh();
        ClientNetwork.initializeHandlers();
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> {
            ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
            AnimationRegistry.load(resourceManager);
            SpellEngineClient.injectRangedWeaponModelPredicates();
        });
        MenuScreens.m_96206_(SpellBindingScreenHandler.HANDLER_TYPE, SpellBindingScreen::new);
        BlockEntityRenderers.m_173590_(SpellBindingBlockEntity.ENTITY_TYPE, SpellBindingBlockEntityRenderer::new);
        ShaderCompatibility.setup();
        BeamRenderer.setup();
    }

    private static void injectRangedWeaponModelPredicates() {
        for (ResourceLocation itemId : BuiltInRegistries.f_257033_.m_6566_()) {
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(itemId);
            if (item instanceof BowItem) {
                ModelPredicateHelper.injectBowSkillUsePredicate(item);
                continue;
            }
            if (!(item instanceof CrossbowItem)) continue;
            ModelPredicateHelper.injectCrossBowSkillUsePredicate(item);
        }
    }

    static {
        hudConfig = new ConfigManager("hud_config", (Object)HudConfig.createDefault()).builder().setDirectory("spell_engine").sanitize(true).validate(HudConfig::isValid).build();
    }
}

