/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.gui;

import com.ibm.icu.text.DecimalFormat;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.mixin.client.keybinding.KeyBindingAccessor;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.SpellContainer;
import net.spell_engine.client.SpellEngineClient;
import net.spell_engine.client.input.Keybindings;
import net.spell_engine.config.ClientConfig;
import net.spell_engine.config.ServerConfig;
import net.spell_engine.internals.SpellCasterItemStack;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.SpellRegistry;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;

public class SpellTooltip {
    private static final String damageToken = "damage";
    private static final String healToken = "heal";
    private static final String rangeToken = "range";
    private static final String durationToken = "duration";
    private static final String itemToken = "item";
    private static final String effectDurationToken = "effect_duration";
    private static final String effectAmplifierToken = "effect_amplifier";
    private static final String impactRangeToken = "impact_range";
    private static final String teleportDistanceToken = "teleport_distance";
    private static final Map<ResourceLocation, DescriptionMutator> descriptionMutators = new HashMap<ResourceLocation, DescriptionMutator>();

    public static String placeholder(String token) {
        return "{" + token + "}";
    }

    public static void addSpellInfo(ItemStack itemStack, List<Component> lines) {
        SpellCasterItemStack stack;
        SpellContainer container;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ClientConfig config = SpellEngineClient.config;
        ItemStack itemStack2 = itemStack;
        if (itemStack2 instanceof SpellCasterItemStack && (container = (stack = (SpellCasterItemStack)itemStack2).getSpellContainer()) != null && container.isValid()) {
            if (container.is_proxy && config.showSpellBookSuppportTooltip) {
                switch (container.content) {
                    case MAGIC: {
                        lines.add((Component)Component.m_237115_((String)"spell.tooltip.host.proxy.spell").m_130940_(ChatFormatting.GRAY));
                        break;
                    }
                    case ARCHERY: {
                        lines.add((Component)Component.m_237115_((String)"spell.tooltip.host.proxy.arrow").m_130940_(ChatFormatting.GRAY));
                    }
                }
            }
            if (container.spell_ids.size() > 0 || container.pool != null) {
                if (container.pool == null) {
                    lines.add((Component)Component.m_237115_((String)(container.is_proxy ? "spell.tooltip.host.additional" : "spell.tooltip.host.pre_loaded")).m_130940_(ChatFormatting.GRAY));
                } else {
                    String limit = "";
                    if (container.max_spell_count > 0) {
                        limit = I18n.m_118938_((String)"spell.tooltip.host.limit", (Object[])new Object[0]).replace(SpellTooltip.placeholder("current"), "" + container.spell_ids.size()).replace(SpellTooltip.placeholder("max"), "" + container.max_spell_count);
                    }
                    String key = "spell.tooltip.host.list.spell";
                    switch (container.content) {
                        case MAGIC: {
                            key = "spell.tooltip.host.list.spell";
                            break;
                        }
                        case ARCHERY: {
                            key = "spell.tooltip.host.list.arrow";
                        }
                    }
                    lines.add((Component)Component.m_237115_((String)key).m_7220_((Component)Component.m_237113_((String)(" " + limit))).m_130940_(ChatFormatting.GRAY));
                }
            }
            KeyMapping keybinding = Keybindings.bypass_spell_hotbar;
            boolean showDetails = config.alwaysShowFullTooltip || !keybinding.m_90862_() && InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)((KeyBindingAccessor)keybinding).fabric_getBoundKey().m_84873_());
            for (int i = 0; i < container.spell_ids.size(); ++i) {
                ResourceLocation spellId = new ResourceLocation(container.spell_ids.get(i));
                List<Component> info = SpellTooltip.spellInfo(spellId, (Player)player, itemStack, showDetails);
                if (info.isEmpty()) continue;
                if (i > 0 && showDetails) {
                    lines.add((Component)Component.m_237113_((String)" "));
                }
                lines.addAll(info);
            }
            if (!showDetails) {
                if (!keybinding.m_90862_() && container.spell_ids.size() > 0) {
                    lines.add((Component)Component.m_237110_((String)"spell.tooltip.hold_for_details", (Object[])new Object[]{keybinding.m_90863_()}).m_130940_(ChatFormatting.GRAY));
                }
                if (config.showSpellBindingTooltip && container.pool != null) {
                    lines.add((Component)Component.m_237115_((String)"spell.tooltip.spell_binding_tip").m_130940_(ChatFormatting.GRAY));
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static List<Component> spellInfo(ResourceLocation spellId, Player player, ItemStack itemStack, boolean details) {
        Item item;
        float f;
        DescriptionMutator mutator;
        String group;
        ArrayList<Component> lines = new ArrayList<Component>();
        Spell spell = SpellRegistry.getSpell(spellId);
        if (spell == null) {
            return lines;
        }
        SpellPower.Result primaryPower = SpellPower.getSpellPower((SpellSchool)spell.school, (LivingEntity)player);
        MutableComponent name = Component.m_237115_((String)SpellTooltip.spellTranslationKey(spellId)).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.GRAY);
        if (spell.group != null && !(group = SpellTooltip.spellGroup(spell.group)).isEmpty()) {
            name.m_7220_((Component)Component.m_237113_((String)(" " + group))).m_130940_(ChatFormatting.GRAY);
        }
        lines.add((Component)name);
        if (!details) {
            return lines;
        }
        String description = I18n.m_118938_((String)(SpellTooltip.spellKeyPrefix(spellId) + ".description"), (Object[])new Object[0]);
        if (spell.release != null) {
            int extra_launch_count;
            void var10_14;
            Spell.ProjectileData projectile = null;
            if (spell.release.target.projectile != null) {
                projectile = spell.release.target.projectile.projectile;
            }
            if (spell.release.target.meteor != null) {
                projectile = spell.release.target.meteor.projectile;
            }
            if (projectile != null) {
                if (projectile.perks.ricochet > 0) {
                    description = description.replace(SpellTooltip.placeholder("ricochet"), SpellTooltip.formattedNumber(projectile.perks.ricochet));
                }
                if (projectile.perks.bounce > 0) {
                    description = description.replace(SpellTooltip.placeholder("bounce"), SpellTooltip.formattedNumber(projectile.perks.bounce));
                }
                if (projectile.perks.pierce > 0) {
                    description = description.replace(SpellTooltip.placeholder("pierce"), SpellTooltip.formattedNumber(projectile.perks.pierce));
                }
                if (projectile.perks.chain_reaction_size > 0) {
                    description = description.replace(SpellTooltip.placeholder("chain_reaction_size"), SpellTooltip.formattedNumber(projectile.perks.chain_reaction_size));
                }
            }
            Object var10_10 = null;
            if (spell.release.target.projectile != null) {
                Spell.LaunchProperties launchProperties = spell.release.target.projectile.launch_properties;
            }
            if (spell.release.target.meteor != null) {
                Spell.LaunchProperties launchProperties = spell.release.target.meteor.launch_properties;
            }
            if (var10_14 != null && (extra_launch_count = var10_14.extra_launch_count) > 0) {
                description = description.replace(SpellTooltip.placeholder("extra_launch"), SpellTooltip.formattedNumber(extra_launch_count));
            }
            Spell.Release.Target.Cloud cloud = spell.release.target.cloud;
            if (spell.release.target.clouds.length > 0) {
                cloud = spell.release.target.clouds[0];
            }
            if (cloud != null) {
                float cloud_duration = cloud.time_to_live_seconds;
                if (cloud_duration > 0.0f) {
                    description = description.replace(SpellTooltip.placeholder("cloud_duration"), SpellTooltip.formattedNumber(cloud_duration));
                }
                float radius = cloud.volume.combinedRadius(primaryPower);
                description = description.replace(SpellTooltip.placeholder("cloud_radius"), SpellTooltip.formattedNumber(radius));
            }
        }
        if (spell.impact != null) {
            SpellHelper.EstimatedOutput estimatedOutput = SpellHelper.estimate(spell, player, itemStack);
            block9: for (Spell.Impact impact : spell.impact) {
                switch (impact.action.type) {
                    case DAMAGE: {
                        description = SpellTooltip.replaceTokens(description, damageToken, estimatedOutput.damage());
                        continue block9;
                    }
                    case HEAL: {
                        description = SpellTooltip.replaceTokens(description, healToken, estimatedOutput.heal());
                        continue block9;
                    }
                    case STATUS_EFFECT: {
                        Spell.Impact.Action.StatusEffect statusEffect = impact.action.status_effect;
                        description = description.replace(SpellTooltip.placeholder(effectAmplifierToken), "" + (statusEffect.amplifier + 1));
                        description = description.replace(SpellTooltip.placeholder(effectDurationToken), SpellTooltip.formattedNumber(statusEffect.duration));
                        continue block9;
                    }
                    case TELEPORT: {
                        Spell.Impact.Action.Teleport teleport = impact.action.teleport;
                        switch (teleport.mode) {
                            case FORWARD: {
                                Spell.Impact.Action.Teleport.Forward forward = teleport.forward;
                                description = description.replace(SpellTooltip.placeholder(teleportDistanceToken), SpellTooltip.formattedNumber(forward.distance));
                            }
                        }
                    }
                }
            }
            Spell.AreaImpact areaImpact = spell.area_impact;
            if (areaImpact != null) {
                float radius = areaImpact.combinedRadius(primaryPower);
                description = description.replace(SpellTooltip.placeholder(impactRangeToken), SpellTooltip.formattedNumber(radius));
            }
        }
        if ((mutator = descriptionMutators.get(spellId)) != null) {
            DescriptionMutator.Args args = new DescriptionMutator.Args(description, player);
            description = mutator.mutate(args);
        }
        lines.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)description)).m_130940_(ChatFormatting.GRAY));
        if (SpellHelper.isInstant(spell)) {
            lines.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)"spell.tooltip.cast_instant")).m_130940_(ChatFormatting.GOLD));
        } else {
            float f2 = SpellHelper.getCastDuration((LivingEntity)player, spell, itemStack);
            String castTimeKey = SpellTooltip.keyWithPlural("spell.tooltip.cast_time", f2);
            String castTime = I18n.m_118938_((String)castTimeKey, (Object[])new Object[0]).replace(SpellTooltip.placeholder(durationToken), SpellTooltip.formattedNumber(f2));
            lines.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237113_((String)castTime)).m_130940_(ChatFormatting.GOLD));
        }
        if (spell.range > 0.0f) {
            String string = SpellTooltip.keyWithPlural("spell.tooltip.range", spell.range);
            String range = I18n.m_118938_((String)string, (Object[])new Object[0]).replace(SpellTooltip.placeholder(rangeToken), SpellTooltip.formattedNumber(spell.range));
            lines.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237113_((String)range)).m_130940_(ChatFormatting.GOLD));
        }
        if ((f = SpellHelper.getCooldownDuration((LivingEntity)player, spell, itemStack)) > 0.0f) {
            String cooldown;
            if (spell.cost.cooldown_proportional) {
                cooldown = I18n.m_118938_((String)"spell.tooltip.cooldown.proportional", (Object[])new Object[0]);
            } else {
                String cooldownKey = SpellTooltip.keyWithPlural("spell.tooltip.cooldown", f);
                cooldown = I18n.m_118938_((String)cooldownKey, (Object[])new Object[0]).replace(SpellTooltip.placeholder(durationToken), SpellTooltip.formattedNumber(f));
            }
            lines.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237113_((String)cooldown)).m_130940_(ChatFormatting.GOLD));
        }
        boolean showItemCost = true;
        ServerConfig config = SpellEngineMod.config;
        if (config != null) {
            showItemCost = config.spell_cost_item_allowed;
        }
        if (showItemCost && spell.cost != null && spell.cost.item_id != null && !spell.cost.item_id.isEmpty() && (item = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(spell.cost.item_id))) != Items.f_41852_) {
            String ammoKey = SpellTooltip.keyWithPlural("spell.tooltip.ammo", 1.0f);
            String itemName = I18n.m_118938_((String)item.m_5524_(), (Object[])new Object[0]);
            String ammo = I18n.m_118938_((String)ammoKey, (Object[])new Object[0]).replace(SpellTooltip.placeholder(itemToken), itemName);
            boolean hasItem = SpellHelper.ammoForSpell(player, spell, itemStack).satisfied();
            lines.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237113_((String)ammo).m_130940_(hasItem ? ChatFormatting.GREEN : ChatFormatting.RED)));
        }
        return lines;
    }

    private static String replaceTokens(String text, String token, List<SpellHelper.EstimatedValue> values) {
        boolean indexTokens = values.size() > 1;
        for (int i = 0; i < values.size(); ++i) {
            SpellHelper.EstimatedValue range = values.get(i);
            String actualToken = indexTokens ? SpellTooltip.placeholder(token + "_" + (i + 1)) : SpellTooltip.placeholder(token);
            text = text.replace(actualToken, SpellTooltip.formattedRange(range.min(), range.max()));
        }
        return text;
    }

    private static String formattedRange(double min, double max) {
        if (min == max) {
            return SpellTooltip.formattedNumber((float)min);
        }
        return SpellTooltip.formattedNumber((float)min) + " - " + SpellTooltip.formattedNumber((float)max);
    }

    private static String formattedNumber(float number) {
        DecimalFormat formatter = new DecimalFormat();
        formatter.setMaximumFractionDigits(1);
        return formatter.format((double)number);
    }

    private static String keyWithPlural(String key, float value) {
        if (value != 1.0f) {
            return key + ".plural";
        }
        return key;
    }

    public static String spellTranslationKey(ResourceLocation spellId) {
        return SpellTooltip.spellKeyPrefix(spellId) + ".name";
    }

    public static String spellKeyPrefix(ResourceLocation spellId) {
        return "spell." + spellId.m_135827_() + "." + spellId.m_135815_();
    }

    public static String spellGroup(String group) {
        String key = "spell.group." + group;
        if (I18n.m_118936_((String)key)) {
            return I18n.m_118938_((String)key, (Object[])new Object[0]);
        }
        return "";
    }

    private static <T> T coalesce(T ... items) {
        for (T i : items) {
            if (i == null) continue;
            return i;
        }
        return null;
    }

    public static void addDescriptionMutator(ResourceLocation spellId, DescriptionMutator handler) {
        descriptionMutators.put(spellId, handler);
    }

    public static interface DescriptionMutator {
        public String mutate(Args var1);

        public record Args(String description, Player player) {
        }
    }
}

