/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.input;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Options;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.api.item.trinket.SpellBookItem;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.SpellContainer;
import net.spell_engine.api.spell.SpellInfo;
import net.spell_engine.client.SpellEngineClient;
import net.spell_engine.client.gui.HudMessages;
import net.spell_engine.client.input.Keybindings;
import net.spell_engine.client.input.WrappedKeybinding;
import net.spell_engine.internals.SpellContainerHelper;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.SpellRegistry;
import net.spell_engine.internals.casting.SpellCast;
import net.spell_engine.internals.casting.SpellCasterClient;
import net.spell_engine.mixin.client.control.KeybindingAccessor;
import net.spell_engine.network.Packets;
import org.jetbrains.annotations.Nullable;

public class SpellHotbar {
    public static SpellHotbar INSTANCE = new SpellHotbar();
    private static final ResourceLocation offhandUseSpellId = new ResourceLocation("spell_engine", "use_offhand_item");
    private static KeyMapping deadKey = new KeyMapping("keybindings.spell_engine.dead", InputConstants.Type.KEYSYM, InputConstants.f_84822_.m_84873_(), SpellEngineMod.modName());
    public List<Slot> slots = List.of();
    public StructuredSlots structuredSlots = new StructuredSlots(null, List.of());
    public boolean showsOffHandUse = false;
    @Nullable
    private Handle handledThisTick = null;
    @Nullable
    private Handle handledPreviousTick = null;
    private boolean skipHandling = false;
    private SpellCast.Attempt lastDisplayedAttempt = null;
    private ResourceLocation lastSyncedSpellId = null;
    private final HashMap<KeyMapping, UseCase> debounced = new HashMap();

    public boolean update(LocalPlayer player, Options options) {
        this.showsOffHandUse = false;
        boolean changed = false;
        int initialSlotCount = this.slots.size();
        ItemStack held = player.m_21205_();
        SpellContainer container = SpellContainerHelper.getEquipped(held, (Player)player);
        ArrayList<Slot> slots = new ArrayList<Slot>();
        InputConstants.Key useKey = ((KeybindingAccessor)options.f_92095_).getBoundKey();
        Slot onUseKey = null;
        ArrayList<Slot> otherSlots = new ArrayList<Slot>();
        List<WrappedKeybinding> allBindings = Keybindings.Wrapped.all();
        if (!(held.m_41720_() instanceof SpellBookItem) && container != null) {
            List<String> spellIds = container.spell_ids;
            List<SpellInfo> spellInfoList = spellIds.stream().map(idString -> {
                ResourceLocation id = new ResourceLocation(idString);
                Spell spell = SpellRegistry.getSpell(id);
                if (spell == null) {
                    return null;
                }
                return new SpellInfo(spell, id);
            }).filter(Objects::nonNull).toList();
            SpellInfo skillForUseKey = null;
            for (SpellInfo spellInfo : spellInfoList) {
                if (spellInfo.spell().mode != Spell.Mode.ITEM_USE || spellInfo.spell().item_use.requires_offhand_item && player.m_21206_().m_41619_()) continue;
                skillForUseKey = spellInfo;
            }
            if (skillForUseKey != null || container.content == SpellContainer.ContentType.ARCHERY) {
                allBindings = allBindings.stream().filter(wrappedKeybinding -> {
                    KeyMapping vanillaKeybinding = wrappedKeybinding.alternative.keyBindingFrom(options);
                    return vanillaKeybinding == null || !vanillaKeybinding.m_90850_(options.f_92095_);
                }).toList();
            }
            int keyBindingIndex = 0;
            block5: for (SpellInfo spellInfo : spellInfoList) {
                WrappedKeybinding.Unwrapped unwrapped;
                ResourceLocation spellId = spellInfo.id();
                Spell spell = spellInfo.spell();
                if (spell == null) continue;
                WrappedKeybinding keyBinding = null;
                switch (spell.mode) {
                    case CAST: {
                        if (keyBindingIndex >= allBindings.size()) break;
                        keyBinding = allBindings.get(keyBindingIndex);
                        ++keyBindingIndex;
                        break;
                    }
                    case ITEM_USE: {
                        if (spell.item_use.requires_offhand_item && player.m_21206_().m_41619_()) continue block5;
                        keyBinding = new WrappedKeybinding(deadKey, WrappedKeybinding.VanillaAlternative.USE_KEY);
                    }
                }
                Slot slot = new Slot(new SpellInfo(spell, spellId), SpellCast.Mode.from(spell), keyBinding, null);
                if (keyBinding != null && (unwrapped = keyBinding.get(options)) != null) {
                    InputConstants.Key hotbarKey = ((KeybindingAccessor)unwrapped.keyBinding()).getBoundKey();
                    if (hotbarKey.equals((Object)useKey)) {
                        onUseKey = slot;
                    } else {
                        otherSlots.add(slot);
                    }
                }
                slots.add(slot);
            }
        }
        if (SpellEngineClient.config.spellHotbarShowsOffhand) {
            ItemStack offHandStack = player.m_21206_();
            if (!slots.isEmpty() && !offHandStack.m_41619_() && offHandStack.m_41780_() != UseAnim.NONE) {
                WrappedKeybinding keyBinding = new WrappedKeybinding(options.f_92095_, WrappedKeybinding.VanillaAlternative.USE_KEY);
                ResourceLocation spellId = offhandUseSpellId;
                Spell spell = SpellRegistry.getSpell(spellId);
                if (spell != null) {
                    Slot slot = new Slot(new SpellInfo(spell, spellId), SpellCast.Mode.from(spell), keyBinding, Keybindings.bypass_spell_hotbar);
                    slots.add(slot);
                    this.showsOffHandUse = true;
                }
            }
        }
        changed = initialSlotCount != slots.size();
        this.structuredSlots = new StructuredSlots(onUseKey, otherSlots);
        this.slots = slots;
        return changed;
    }

    public void prepare(int itemUseCooldown) {
        this.handledPreviousTick = this.handledThisTick;
        this.handledThisTick = null;
        this.updateDebounced();
        this.skipHandling = !this.lastHandledWasItemBypass() && itemUseCooldown > 0;
    }

    public boolean lastHandledWasItemBypass() {
        return this.handledPreviousTick != null && this.handledPreviousTick.spell().spell().mode == Spell.Mode.ITEM_USE;
    }

    @Nullable
    public Handle handle(LocalPlayer player, Options options) {
        return this.handle(player, this.slots, options);
    }

    @Nullable
    public Handle handle(LocalPlayer player, @Nullable Slot slot, Options options) {
        if (slot == null) {
            return null;
        }
        return this.handle(player, List.of(slot), options);
    }

    @Nullable
    public Handle handle(LocalPlayer player, List<Slot> slots, Options options) {
        if (this.handledThisTick != null || this.skipHandling || player.m_5833_()) {
            return null;
        }
        if (Keybindings.bypass_spell_hotbar.m_90857_() || SpellEngineClient.config.sneakingByPassSpellHotbar && options.f_92090_.m_90857_()) {
            return null;
        }
        SpellCasterClient caster = (SpellCasterClient)player;
        SpellCast.Progress casted = caster.getSpellCastProgress();
        ItemStack casterStack = player.m_21205_();
        for (Slot slot : slots) {
            WrappedKeybinding.Unwrapped unwrapped;
            if (slot.keybinding == null || (unwrapped = slot.keybinding.get(options)) == null) continue;
            KeyMapping keyBinding = unwrapped.keyBinding();
            boolean pressed = keyBinding.m_90857_();
            Handle handle = Handle.from(slot, keyBinding, unwrapped.vanillaHandle());
            switch (slot.castMode()) {
                case INSTANT: 
                case ITEM_USE: {
                    if (!pressed) break;
                    SpellCast.Attempt attempt = caster.startSpellCast(casterStack, slot.spell.id());
                    this.handledThisTick = handle;
                    this.displayAttempt(attempt);
                    return handle;
                }
                case CHARGE: 
                case CHANNEL: {
                    if (casted != null && casted.process().id().equals((Object)slot.spell.id())) {
                        boolean needsToBeHeld;
                        boolean bl = needsToBeHeld = SpellHelper.isChanneled(casted.process().spell()) ? SpellEngineClient.config.holdToCastChannelled : SpellEngineClient.config.holdToCastCharged;
                        if (needsToBeHeld) {
                            if (pressed) break;
                            caster.cancelSpellCast();
                            this.handledThisTick = handle;
                            return handle;
                        }
                        if (!pressed || !this.isReleased(keyBinding, UseCase.START)) break;
                        caster.cancelSpellCast();
                        this.debounce(keyBinding, UseCase.STOP);
                        this.handledThisTick = handle;
                        return handle;
                    }
                    if (!pressed || !this.isReleased(keyBinding, UseCase.STOP)) break;
                    SpellCast.Attempt attempt = caster.startSpellCast(casterStack, slot.spell.id());
                    this.debounce(keyBinding, UseCase.START);
                    this.handledThisTick = handle;
                    this.displayAttempt(attempt);
                    return handle;
                }
            }
            if (!pressed) continue;
            this.handledThisTick = handle;
            return handle;
        }
        this.lastDisplayedAttempt = null;
        return null;
    }

    private void displayAttempt(SpellCast.Attempt attempt) {
        if (this.lastDisplayedAttempt != null) {
            return;
        }
        if (attempt.isFail()) {
            HudMessages.INSTANCE.castAttemptError(attempt);
        }
        this.lastDisplayedAttempt = attempt;
    }

    public void syncItemUseSkill(LocalPlayer player) {
        ResourceLocation idToSync = null;
        if (player.m_6117_() && this.handledThisTick != null && this.handledThisTick.spell().spell().mode == Spell.Mode.ITEM_USE) {
            idToSync = this.handledThisTick.spell().id();
        }
        if (!Objects.equals(idToSync, this.lastSyncedSpellId)) {
            ClientPlayNetworking.send((ResourceLocation)Packets.SpellCastSync.ID, (FriendlyByteBuf)new Packets.SpellCastSync(idToSync, 1.0f, 1000).write());
            this.lastSyncedSpellId = idToSync;
        }
    }

    private boolean isReleased(KeyMapping keybinding, UseCase use) {
        return this.debounced.get(keybinding) != use;
    }

    private void debounce(KeyMapping keybinding, UseCase use) {
        this.debounced.put(keybinding, use);
    }

    private void updateDebounced() {
        this.debounced.entrySet().removeIf(entry -> !((KeyMapping)entry.getKey()).m_90857_());
    }

    public static ItemStack expectedUseStack(Player player) {
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack itemStack = player.m_21120_(hand);
            if (itemStack.m_41780_() == UseAnim.NONE) continue;
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    public record StructuredSlots(@Nullable Slot onUseKey, List<Slot> other) {
    }

    public record Slot(SpellInfo spell, SpellCast.Mode castMode, @Nullable WrappedKeybinding keybinding, @Nullable KeyMapping modifier) {
        @Nullable
        public KeyMapping getKeyBinding(Options options) {
            WrappedKeybinding.Unwrapped unwrapped;
            if (this.keybinding != null && (unwrapped = this.keybinding.get(options)) != null) {
                return unwrapped.keyBinding();
            }
            return null;
        }
    }

    public record Handle(SpellInfo spell, KeyMapping keyBinding, @Nullable WrappedKeybinding.Category category) {
        public static Handle from(Slot slot, KeyMapping keyBinding, @Nullable WrappedKeybinding.Category category) {
            return new Handle(slot.spell, keyBinding, category);
        }
    }

    private static enum UseCase {
        START,
        STOP;

    }
}

