/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class ShiftedParticle
extends TextureSheetParticle {
    private final SpriteSet spriteProvider;

    protected ShiftedParticle(ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, SpriteSet spriteProvider) {
        super(world, x, y, z);
        this.f_107226_ = 0.225f;
        this.f_172258_ = 1.0f;
        this.spriteProvider = spriteProvider;
        this.f_107216_ = velocityY + (Math.random() * 2.0 - 1.0) * (double)0.05f;
        this.f_107663_ = 0.1f * (this.f_107223_.m_188501_() * this.f_107223_.m_188501_() * 1.0f + 1.0f);
        this.f_107225_ = (int)(16.0 / ((double)this.f_107223_.m_188501_() * 0.8 + 0.2)) + 2;
        this.m_108339_(spriteProvider);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public void m_5989_() {
        super.m_5989_();
        this.m_108339_(this.spriteProvider);
        this.f_107215_ *= (double)0.95f;
        this.f_107216_ *= (double)0.9f;
        this.f_107217_ *= (double)0.95f;
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float tickDelta) {
        Quaternionf quaternionf;
        Vec3 vec3d = camera.m_90583_();
        float f = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107209_, (double)this.f_107212_) - vec3d.m_7096_());
        float g = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107210_, (double)this.f_107213_) + (double)(this.f_107663_ * 0.5f) - vec3d.m_7098_());
        float h = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107211_, (double)this.f_107214_) - vec3d.m_7094_());
        if (this.f_107231_ == 0.0f) {
            quaternionf = camera.m_253121_();
        } else {
            quaternionf = new Quaternionf((Quaternionfc)camera.m_253121_());
            quaternionf.rotateZ(Mth.m_14179_((float)tickDelta, (float)this.f_107204_, (float)this.f_107231_));
        }
        Vector3f[] vector3fs = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float i = this.m_5902_(tickDelta);
        for (int j = 0; j < 4; ++j) {
            Vector3f vector3f = vector3fs[j];
            vector3f.rotate((Quaternionfc)quaternionf);
            vector3f.mul(i);
            vector3f.add(f, g, h);
        }
        float k = this.m_5970_();
        float l = this.m_5952_();
        float m = this.m_5951_();
        float n = this.m_5950_();
        int o = this.m_6355_(tickDelta);
        vertexConsumer.m_5483_((double)vector3fs[0].x(), (double)vector3fs[0].y(), (double)vector3fs[0].z()).m_7421_(l, n).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(o).m_5752_();
        vertexConsumer.m_5483_((double)vector3fs[1].x(), (double)vector3fs[1].y(), (double)vector3fs[1].z()).m_7421_(l, m).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(o).m_5752_();
        vertexConsumer.m_5483_((double)vector3fs[2].x(), (double)vector3fs[2].y(), (double)vector3fs[2].z()).m_7421_(k, m).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(o).m_5752_();
        vertexConsumer.m_5483_((double)vector3fs[3].x(), (double)vector3fs[3].y(), (double)vector3fs[3].z()).m_7421_(k, n).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(o).m_5752_();
    }

    @Environment(value=EnvType.CLIENT)
    public static class RootsFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public RootsFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            ShiftedParticle particle = new ShiftedParticle(clientWorld, d, e, f, g, h, i, this.spriteProvider);
            particle.m_107253_(1.0f, 1.0f, 1.0f);
            particle.f_107230_ = 1.0f;
            particle.m_107250_(3.0f, 3.0f);
            particle.f_107215_ = 0.0;
            particle.f_107217_ = 0.0;
            particle.f_107663_ = 0.25f;
            return particle;
        }
    }
}

