/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.particle;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SnowflakeParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.spell_engine.client.util.Color;
import net.spell_power.api.SpellSchools;

@Environment(value=EnvType.CLIENT)
public class SpellSnowflakeParticle
extends SnowflakeParticle {
    boolean glow = true;

    protected SpellSnowflakeParticle(ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, SpriteSet spriteProvider) {
        super(world, x, y, z, velocityX, velocityY, velocityZ, spriteProvider);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public int m_6355_(float tint) {
        if (this.glow) {
            return 255;
        }
        return super.m_6355_(tint);
    }

    @Environment(value=EnvType.CLIENT)
    public static class RootsFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;
        public static Color color = Color.from(SpellSchools.FROST.color);

        public RootsFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellSnowflakeParticle particle = new SpellSnowflakeParticle(clientWorld, d, e, f, g, h, i, this.spriteProvider);
            particle.m_107253_(1.0f, 1.0f, 1.0f);
            particle.f_107230_ = 1.0f;
            particle.glow = false;
            particle.m_107250_(3.0f, 3.0f);
            particle.f_107215_ = 0.0;
            particle.f_107217_ = 0.0;
            particle.f_107663_ = 0.25f;
            return particle;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class DrippingBloodFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;
        public static Color color = Color.from(0xB30000);

        public DrippingBloodFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellSnowflakeParticle particle = new SpellSnowflakeParticle(clientWorld, d, e, f, g, h, i, this.spriteProvider);
            particle.m_107253_(0.35f, 0.0f, 0.0f);
            particle.f_107230_ = 1.0f;
            particle.glow = false;
            particle.f_107215_ *= 0.4;
            particle.f_107217_ *= 0.4;
            particle.f_107226_ = 0.8f;
            return particle;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class HolyFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;
        public static Color color = Color.from(0xFFFFCC);

        public HolyFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellSnowflakeParticle particle = new SpellSnowflakeParticle(clientWorld, d, e, f, g, h, i, this.spriteProvider);
            particle.m_107253_(color.red(), color.green(), color.red());
            particle.f_107230_ = 0.75f;
            return particle;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class FrostFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;
        public static Color color = Color.from(SpellSchools.FROST.color);

        public FrostFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            SpellSnowflakeParticle particle = new SpellSnowflakeParticle(clientWorld, d, e, f, g, h, i, this.spriteProvider);
            particle.m_107253_(color.red(), color.green(), color.red());
            particle.f_107230_ = 0.75f;
            return particle;
        }
    }
}

