/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.List;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.spell_engine.api.render.CustomLayers;
import net.spell_engine.api.render.LightEmission;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.client.beam.BeamEmitterEntity;
import net.spell_engine.internals.Beam;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.casting.SpellCasterEntity;
import net.spell_engine.utils.TargetHelper;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class BeamRenderer
extends RenderType {
    public static void setup() {
        WorldRenderEvents.AFTER_TRANSLUCENT.register(context -> {
            MultiBufferSource.BufferSource vcProvider = Minecraft.m_91087_().m_91269_().m_110104_();
            BeamRenderer.renderAllInWorld(context, context.matrixStack(), vcProvider, context.camera(), 0xF000F0, context.tickDelta());
        });
    }

    public static void renderAllInWorld(WorldRenderContext context, PoseStack matrices, MultiBufferSource.BufferSource vertexConsumers, Camera camera, int light, float delta) {
        Entity focusedEntity = context.camera().m_90592_();
        if (focusedEntity == null) {
            return;
        }
        int renderDistance = (Integer)Minecraft.m_91087_().f_91066_.m_231984_().m_231551_() * 24;
        int squaredRenderDistance = renderDistance * renderDistance;
        List<AbstractClientPlayer> players = context.world().m_6907_().stream().filter(player -> player.m_20280_(focusedEntity) < (double)squaredRenderDistance && ((SpellCasterEntity)player).getBeam() != null).toList();
        if (players.isEmpty()) {
            return;
        }
        matrices.m_85836_();
        Vec3 camPos = camera.m_90583_();
        matrices.m_85837_(-camPos.f_82479_, -camPos.f_82480_, -camPos.f_82481_);
        for (AbstractClientPlayer livingEntity : players) {
            float launchHeight = SpellHelper.launchHeight((LivingEntity)livingEntity);
            Vec3 offset = new Vec3(0.0, (double)launchHeight, (double)SpellHelper.launchPointOffsetDefault);
            SpellCasterEntity caster = (SpellCasterEntity)livingEntity;
            matrices.m_85836_();
            Vec3 pos = new Vec3(livingEntity.f_19854_, livingEntity.f_19855_, livingEntity.f_19856_).m_165921_(livingEntity.m_20182_(), (double)delta);
            matrices.m_85837_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
            Vec3 from = livingEntity.m_20182_().m_82520_(0.0, (double)launchHeight, 0.0);
            Vec3 lookVector = Vec3.f_82478_;
            if (livingEntity == Minecraft.m_91087_().f_91074_) {
                lookVector = Vec3.m_82498_((float)livingEntity.m_146909_(), (float)livingEntity.m_146908_());
            } else {
                lookVector = Vec3.m_82498_((float)livingEntity.f_19860_, (float)livingEntity.f_19859_);
                lookVector = lookVector.m_165921_(Vec3.m_82498_((float)livingEntity.m_146909_(), (float)livingEntity.m_146908_()), (double)delta);
            }
            lookVector = lookVector.m_82541_();
            Beam.Position beamPosition = TargetHelper.castBeam((LivingEntity)livingEntity, lookVector, 32.0f);
            lookVector = lookVector.m_82490_((double)beamPosition.length());
            Vec3 to = from.m_82549_(lookVector);
            Spell.Release.Target.Beam beamAppearance = caster.getBeam();
            BeamRenderer.renderBeamFromPlayer(matrices, (MultiBufferSource)vertexConsumers, beamAppearance, from, to, offset, livingEntity.m_9236_().m_46467_(), delta);
            ((BeamEmitterEntity)livingEntity).setLastRenderedBeam(new Beam.Rendered(beamPosition, beamAppearance));
            matrices.m_85849_();
        }
        vertexConsumers.m_109911_();
        matrices.m_85849_();
    }

    private static void renderBeamFromPlayer(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, Spell.Release.Target.Beam beam, Vec3 from, Vec3 to, Vec3 offset, long time, float tickDelta) {
        float absoluteTime = (float)Math.floorMod(time, 40) + tickDelta;
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, offset.f_82480_, 0.0);
        Vec3 beamVector = to.m_82546_(from);
        float length = (float)beamVector.m_82553_();
        beamVector = beamVector.m_82541_();
        float n = (float)Math.acos(beamVector.f_82480_);
        float o = (float)Math.atan2(beamVector.f_82481_, beamVector.f_82479_);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_((1.5707964f - o) * 57.295776f));
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(n * 57.295776f));
        matrixStack.m_85837_(0.0, offset.f_82481_, 0.0);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(absoluteTime * 2.25f - 45.0f));
        ResourceLocation texture = new ResourceLocation(beam.texture_id);
        long color = beam.color_rgba;
        long red = color >> 24 & 0xFFL;
        long green = color >> 16 & 0xFFL;
        long blue = color >> 8 & 0xFFL;
        long alpha = color & 0xFFL;
        BeamRenderer.renderBeam(matrixStack, vertexConsumerProvider, texture, time, tickDelta, beam.flow, true, (int)red, (int)green, (int)blue, (int)alpha, 0.0f, length, beam.width);
        matrixStack.m_85849_();
    }

    public BeamRenderer(String name, VertexFormat vertexFormat, VertexFormat.Mode drawMode, int expectedBufferSize, boolean hasCrumbling, boolean translucent, Runnable startAction, Runnable endAction) {
        super(name, vertexFormat, drawMode, expectedBufferSize, hasCrumbling, translucent, startAction, endAction);
    }

    public static void renderBeam(PoseStack matrices, MultiBufferSource vertexConsumers, ResourceLocation texture, long time, float tickDelta, float direction, boolean center, int red, int green, int blue, int alpha, float yOffset, float height, float width) {
        matrices.m_85836_();
        float shift = (float)Math.floorMod(time, 40) + tickDelta;
        float offset = Mth.m_14187_((float)(shift * 0.2f - (float)Mth.m_14143_((float)(shift * 0.1f)))) * -direction;
        RenderType outerRenderLayer = CustomLayers.beam(texture, false, true);
        RenderType innerRenderLayer = CustomLayers.spellObject(texture, LightEmission.RADIATE, false);
        float originalWidth = width;
        if (center) {
            BeamRenderer.renderBeamLayer(matrices, vertexConsumers.m_6299_(innerRenderLayer), red, green, blue, alpha, yOffset, height, 0.0f, width, width, 0.0f, -width, 0.0f, 0.0f, -width, 0.0f, 1.0f, height, offset);
        }
        width = originalWidth * 1.5f;
        BeamRenderer.renderBeamLayer(matrices, vertexConsumers.m_6299_(outerRenderLayer), red, green, blue, (int)((double)alpha * 0.75), yOffset, height, 0.0f, width, width, 0.0f, -width, 0.0f, 0.0f, -width, 0.0f, 1.0f, height, offset * 0.9f);
        width = originalWidth * 2.0f;
        BeamRenderer.renderBeamLayer(matrices, vertexConsumers.m_6299_(outerRenderLayer), red, green, blue, alpha / 3, yOffset, height, 0.0f, width, width, 0.0f, -width, 0.0f, 0.0f, -width, 0.0f, 1.0f, height, offset * 0.8f);
        matrices.m_85849_();
    }

    private static void renderBeamLayer(PoseStack matrices, VertexConsumer vertices, int red, int green, int blue, int alpha, float yOffset, float height, float x1, float z1, float x2, float z2, float x3, float z3, float x4, float z4, float u1, float u2, float v1, float v2) {
        PoseStack.Pose entry = matrices.m_85850_();
        Matrix4f matrix4f = entry.m_252922_();
        Matrix3f matrix3f = entry.m_252943_();
        BeamRenderer.renderBeamFace(matrix4f, matrix3f, vertices, red, green, blue, alpha, yOffset, height, x1, z1, x2, z2, u1, u2, v1, v2);
        BeamRenderer.renderBeamFace(matrix4f, matrix3f, vertices, red, green, blue, alpha, yOffset, height, x4, z4, x3, z3, u1, u2, v1, v2);
        BeamRenderer.renderBeamFace(matrix4f, matrix3f, vertices, red, green, blue, alpha, yOffset, height, x2, z2, x4, z4, u1, u2, v1, v2);
        BeamRenderer.renderBeamFace(matrix4f, matrix3f, vertices, red, green, blue, alpha, yOffset, height, x3, z3, x1, z1, u1, u2, v1, v2);
    }

    private static void renderBeamFace(Matrix4f positionMatrix, Matrix3f normalMatrix, VertexConsumer vertices, int red, int green, int blue, int alpha, float yOffset, float height, float x1, float z1, float x2, float z2, float u1, float u2, float v1, float v2) {
        BeamRenderer.renderBeamVertex(positionMatrix, normalMatrix, vertices, red, green, blue, alpha, height, x1, z1, u2, v1);
        BeamRenderer.renderBeamVertex(positionMatrix, normalMatrix, vertices, red, green, blue, alpha, yOffset, x1, z1, u2, v2);
        BeamRenderer.renderBeamVertex(positionMatrix, normalMatrix, vertices, red, green, blue, alpha, yOffset, x2, z2, u1, v2);
        BeamRenderer.renderBeamVertex(positionMatrix, normalMatrix, vertices, red, green, blue, alpha, height, x2, z2, u1, v1);
    }

    private static void renderBeamVertex(Matrix4f positionMatrix, Matrix3f normalMatrix, VertexConsumer vertices, int red, int green, int blue, int alpha, float y, float x, float z, float u, float v) {
        vertices.m_252986_(positionMatrix, x, y, z).m_6122_(red, green, blue, alpha).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

