/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.spell_engine.api.render.CustomModels;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.client.render.SpellModelHelper;
import net.spell_engine.entity.SpellProjectile;
import org.jetbrains.annotations.Nullable;

public class SpellProjectileRenderer<T extends Entity>
extends EntityRenderer<T> {
    private final ItemRenderer itemRenderer;
    private final float scale;
    private final boolean lit;

    public SpellProjectileRenderer(EntityRendererProvider.Context ctx, float scale, boolean lit) {
        super(ctx);
        this.itemRenderer = ctx.m_174025_();
        this.scale = scale;
        this.lit = lit;
    }

    public SpellProjectileRenderer(EntityRendererProvider.Context arg) {
        this(arg, 1.0f, false);
    }

    protected int m_6086_(T entity, BlockPos pos) {
        return this.lit ? 15 : super.m_6086_(entity, pos);
    }

    public void m_7392_(T entity, float yaw, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        Spell.ProjectileModel renderData;
        boolean rendered;
        SpellProjectile projectile;
        if (entity instanceof SpellProjectile && (projectile = (SpellProjectile)entity).renderData() != null && (rendered = SpellProjectileRenderer.render(this.scale, this.f_114476_, this.itemRenderer, renderData = projectile.renderData(), projectile.previousVelocity, entity, yaw, tickDelta, true, matrices, vertexConsumers, light))) {
            super.m_7392_(entity, yaw, tickDelta, matrices, vertexConsumers, light);
        }
    }

    public static boolean render(float scale, EntityRenderDispatcher dispatcher, ItemRenderer itemRenderer, Spell.ProjectileModel renderData, @Nullable Vec3 previousVelocity, Entity entity, float yaw, float tickDelta, boolean allowSpin, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        if (entity.f_19797_ >= 2 || !(dispatcher.f_114358_.m_90592_().m_20280_(entity) < 12.25)) {
            SpellProjectile spellProjectile;
            matrices.m_85836_();
            matrices.m_85841_(scale, scale, scale);
            switch (renderData.orientation) {
                case TOWARDS_CAMERA: {
                    matrices.m_252781_(dispatcher.m_253208_());
                    matrices.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                    break;
                }
                case TOWARDS_MOTION: 
                case ALONG_MOTION: {
                    Vec3 velocity = entity.m_20184_();
                    if (previousVelocity != null) {
                        velocity = previousVelocity.m_165921_(velocity, (double)tickDelta);
                    }
                    velocity = velocity.m_82541_();
                    double directionBasedYaw = Math.toDegrees(Math.atan2(velocity.f_82479_, velocity.f_82481_)) + 180.0;
                    if (renderData.orientation == Spell.ProjectileModel.Orientation.ALONG_MOTION) {
                        directionBasedYaw += 90.0;
                    }
                    double directionBasedPitch = Math.toDegrees(Math.asin(velocity.f_82480_));
                    matrices.m_252781_(Axis.f_252436_.m_252977_((float)directionBasedYaw));
                    matrices.m_252781_(Axis.f_252529_.m_252977_((float)directionBasedPitch));
                }
            }
            if (allowSpin) {
                matrices.m_252781_(Axis.f_252403_.m_252977_(renderData.rotate_degrees_offset + ((float)entity.f_19797_ + tickDelta) * renderData.rotate_degrees_per_tick));
            }
            matrices.m_85841_(renderData.scale, renderData.scale, renderData.scale);
            ResourceLocation modelId = null;
            ItemStack modelItemStack = null;
            if (entity instanceof SpellProjectile && (spellProjectile = (SpellProjectile)entity).getItemStackModel() != null) {
                modelId = spellProjectile.getItemModelId();
                modelItemStack = spellProjectile.getItemStackModel();
            } else if (renderData.model_id != null && !renderData.model_id.isEmpty()) {
                modelId = new ResourceLocation(renderData.model_id);
            }
            RenderType layer = SpellModelHelper.LAYERS.get((Object)renderData.light_emission);
            if (modelId != null) {
                if (modelItemStack != null) {
                    BakedModel model = itemRenderer.m_174264_(modelItemStack, entity.m_9236_(), null, entity.m_19879_());
                    model.m_7442_().m_269404_(ItemDisplayContext.FIXED).m_111763_(false, matrices);
                    CustomModels.render(layer, itemRenderer, modelId, matrices, vertexConsumers, light, entity.m_19879_());
                } else {
                    CustomModels.render(layer, itemRenderer, modelId, matrices, vertexConsumers, light, entity.m_19879_());
                }
            }
            matrices.m_85849_();
            return true;
        }
        return false;
    }

    public ResourceLocation m_5478_(Entity entity) {
        return TextureAtlas.f_118259_;
    }
}

