/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.compat;

import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.util.TriState;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.spell_engine.api.item.trinket.SpellBookTrinketItem;
import net.spell_engine.api.spell.SpellContainer;
import net.spell_engine.internals.SpellContainerHelper;

public class TrinketsCompat {
    private static boolean intialized = false;
    private static boolean enabled = false;

    public static void init() {
        if (intialized) {
            return;
        }
        enabled = FabricLoader.getInstance().isModLoaded("trinkets");
        if (enabled) {
            TrinketsApi.registerTrinketPredicate((ResourceLocation)new ResourceLocation("spell_engine", "spell_book"), (itemStack, slotReference, livingEntity) -> {
                if (itemStack.m_41720_() instanceof SpellBookTrinketItem) {
                    return TriState.TRUE;
                }
                return TriState.DEFAULT;
            });
            Registry.m_122965_((Registry)BuiltInRegistries.f_256894_, (ResourceLocation)SpellBookTrinketItem.EQUIP_SOUND_ID, (Object)SpellBookTrinketItem.EQUIP_SOUND);
        }
        intialized = true;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static List<String> getEquippedSpells(SpellContainer proxyContainer, Player player) {
        if (!enabled) {
            return Collections.emptyList();
        }
        Optional component = TrinketsApi.getTrinketComponent((LivingEntity)player);
        if (component.isEmpty() || proxyContainer == null || !proxyContainer.is_proxy) {
            return Collections.emptyList();
        }
        TrinketComponent trinketComponent = (TrinketComponent)component.get();
        SpellContainer.ContentType allowedContent = proxyContainer.content;
        LinkedHashSet<ItemStack> items = new LinkedHashSet<ItemStack>();
        TrinketInventory spellBookSlot = (TrinketInventory)((Map)trinketComponent.getInventory().get("charm")).get("spell_book");
        items.add(spellBookSlot.m_8020_(0));
        trinketComponent.getAllEquipped().forEach(pair -> items.add((ItemStack)pair.m_14419_()));
        LinkedHashSet<String> collectedSpellIds = new LinkedHashSet<String>(proxyContainer.spell_ids);
        for (ItemStack stack : items) {
            SpellContainer container;
            if (stack.m_41619_() || (container = SpellContainerHelper.containerFromItemStack(stack)) == null || !container.isValid() || container.content != allowedContent) continue;
            collectedSpellIds.addAll(container.spell_ids);
        }
        return new ArrayList<String>(collectedSpellIds);
    }

    public static ItemStack getSpellBookStack(Player player) {
        if (!enabled) {
            return ItemStack.f_41583_;
        }
        Optional component = TrinketsApi.getTrinketComponent((LivingEntity)player);
        if (component.isEmpty()) {
            return ItemStack.f_41583_;
        }
        return ((TrinketInventory)((Map)((TrinketComponent)component.get()).getInventory().get("charm")).get("spell_book")).m_8020_(0);
    }
}

