/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.fabric;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.api.effect.RemoveOnHit;
import net.spell_engine.compat.TrinketsCompat;
import net.spell_engine.entity.SpellCloud;
import net.spell_engine.entity.SpellProjectile;
import net.spell_engine.utils.SoundHelper;

public class FabricMod
implements ModInitializer {
    public void onInitialize() {
        SpellEngineMod.init();
        SpellEngineMod.registerEnchantments();
        SpellEngineMod.registerSpellBinding();
        SoundHelper.registerSounds();
        TrinketsCompat.init();
        ServerLivingEntityEvents.ALLOW_DAMAGE.register((entity, source, amount) -> {
            Entity attacker = source.m_7639_();
            if (amount > 0.0f && attacker != null) {
                for (MobEffectInstance instance : entity.m_21220_()) {
                    MobEffect effect = instance.m_19544_();
                    if (!RemoveOnHit.shouldRemoveOnDirectHit(effect)) continue;
                    entity.m_21195_(effect);
                    break;
                }
            }
            return true;
        });
    }

    static {
        SpellProjectile.ENTITY_TYPE = (EntityType)Registry.m_122965_((Registry)BuiltInRegistries.f_256780_, (ResourceLocation)new ResourceLocation("spell_engine", "spell_projectile"), (Object)FabricEntityTypeBuilder.create((MobCategory)MobCategory.MISC, SpellProjectile::new).dimensions(EntityDimensions.m_20398_((float)0.25f, (float)0.25f)).fireImmune().trackRangeBlocks(128).trackedUpdateRate(2).build());
        SpellCloud.ENTITY_TYPE = (EntityType)Registry.m_122965_((Registry)BuiltInRegistries.f_256780_, (ResourceLocation)new ResourceLocation("spell_engine", "spell_area_effect"), (Object)FabricEntityTypeBuilder.create((MobCategory)MobCategory.MISC, SpellCloud::new).dimensions(EntityDimensions.m_20395_((float)6.0f, (float)0.5f)).fireImmune().trackRangeBlocks(128).trackedUpdateRate(20).build());
    }
}

