/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.SpellContainer;
import net.spell_engine.api.spell.SpellInfo;
import net.spell_engine.api.spell.SpellPool;
import net.spell_engine.compat.TrinketsCompat;
import net.spell_engine.internals.SpellCasterItemStack;
import net.spell_engine.internals.SpellRegistry;
import org.jetbrains.annotations.Nullable;

public class SpellContainerHelper {
    public static final Comparator<Map.Entry<ResourceLocation, Spell>> spellSorter = (spell1, spell2) -> {
        if (((Spell)spell1.getValue()).learn.tier > ((Spell)spell2.getValue()).learn.tier) {
            return 1;
        }
        if (((Spell)spell1.getValue()).learn.tier < ((Spell)spell2.getValue()).learn.tier) {
            return -1;
        }
        return ((ResourceLocation)spell1.getKey()).toString().compareTo(((ResourceLocation)spell2.getKey()).toString());
    };
    public static final String NBT_KEY_CONTAINER = "spell_container";
    public static final String NBT_KEY_CONTENT_TYPE = "spell_container";
    private static final String NBT_KEY_PROXY = "is_proxy";
    private static final String NBT_KEY_POOL = "pool";
    private static final String NBT_KEY_MAX_SPELL_COUNT = "max_spell_count";
    private static final String NBT_KEY_SPELL_IDS = "spell_ids";

    public static ResourceLocation getPoolId(SpellContainer container) {
        if (container != null && container.pool != null) {
            return new ResourceLocation(container.pool);
        }
        return null;
    }

    public static SpellPool getPool(SpellContainer container) {
        if (container != null && container.pool != null) {
            ResourceLocation id = new ResourceLocation(container.pool);
            return SpellRegistry.spellPool(id);
        }
        return SpellPool.empty;
    }

    public static SpellContainer getEquipped(ItemStack heldItemStack, Player player) {
        SpellContainer weaponContainer = SpellContainerHelper.containerFromItemStack(heldItemStack);
        return SpellContainerHelper.getEquipped(weaponContainer, player);
    }

    public static SpellContainer getEquipped(SpellContainer proxyContainer, Player player) {
        if (proxyContainer == null || !proxyContainer.is_proxy) {
            return proxyContainer;
        }
        LinkedHashSet<String> spellIds = new LinkedHashSet<String>(proxyContainer.spell_ids);
        if (TrinketsCompat.isEnabled()) {
            spellIds.addAll(TrinketsCompat.getEquippedSpells(proxyContainer, player));
        }
        if (SpellEngineMod.config.spell_book_offhand && SpellContainerHelper.isOffhandContainerValid(player, proxyContainer.content)) {
            spellIds.addAll(SpellContainerHelper.getOffhandSpellIds(player));
        }
        ArrayList<SpellInfo> spells = new ArrayList<SpellInfo>();
        for (String idString : spellIds) {
            ResourceLocation id = new ResourceLocation(idString);
            Spell spell = SpellRegistry.getSpell(id);
            if (spell == null) continue;
            spells.add(new SpellInfo(spell, id));
        }
        HashSet<String> toRemove = new HashSet<String>();
        for (SpellInfo spell : spells) {
            String tag = spell.spell().group;
            if (tag == null) continue;
            for (SpellInfo other : spells) {
                if (spell.id().equals((Object)other.id()) || !tag.equals(other.spell().group) || spell.spell().learn.tier <= other.spell().learn.tier) continue;
                toRemove.add(other.id().toString());
            }
        }
        spellIds.removeAll(toRemove);
        return new SpellContainer(proxyContainer.content, false, null, 0, new ArrayList<String>(spellIds));
    }

    private static boolean isOffhandContainerValid(Player player, SpellContainer.ContentType allowedContent) {
        ItemStack offhandItemStack = SpellContainerHelper.getOffhandItemStack(player);
        SpellContainer container = SpellContainerHelper.containerFromItemStack(offhandItemStack);
        return container != null && container.isValid() && container.content == allowedContent;
    }

    private static List<String> getOffhandSpellIds(Player player) {
        ItemStack offhandItemStack = SpellContainerHelper.getOffhandItemStack(player);
        SpellContainer container = SpellContainerHelper.containerFromItemStack(offhandItemStack);
        if (container == null) {
            return Collections.emptyList();
        }
        return container.spell_ids;
    }

    private static ItemStack getOffhandItemStack(Player player) {
        return (ItemStack)player.m_150109_().f_35976_.get(0);
    }

    public static SpellContainer containerFromItemStack(ItemStack itemStack) {
        SpellCasterItemStack stack;
        SpellContainer container;
        if (itemStack.m_41619_()) {
            return null;
        }
        ItemStack object = itemStack;
        if (object instanceof SpellCasterItemStack && (container = (stack = (SpellCasterItemStack)object).getSpellContainer()) != null && container.isValid()) {
            return container;
        }
        return null;
    }

    public static boolean contains(SpellContainer container, ResourceLocation spellId) {
        return container != null && container.spell_ids.contains(spellId.toString());
    }

    public static void addContainerToItemStack(SpellContainer container, ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return;
        }
        CompoundTag nbt = itemStack.m_41784_();
        CompoundTag nbtContainer = SpellContainerHelper.toNBT(container);
        nbt.m_128365_("spell_container", (Tag)nbtContainer);
    }

    @Nullable
    public static ResourceLocation spellId(SpellContainer container, int selectedIndex) {
        if (container == null || !container.isUsable()) {
            return null;
        }
        return new ResourceLocation(container.spellId(selectedIndex));
    }

    public static SpellContainer addSpell(ResourceLocation spellId, SpellContainer container) {
        ArrayList<String> spellIds = new ArrayList<String>(container.spell_ids);
        spellIds.add(spellId.toString());
        HashMap<ResourceLocation, Spell> spells = new HashMap<ResourceLocation, Spell>();
        for (String idString : spellIds) {
            ResourceLocation id = new ResourceLocation(idString);
            Spell spell = SpellRegistry.getSpell(id);
            if (spell == null) continue;
            spells.put(id, spell);
        }
        List sortedSpellIds = spells.entrySet().stream().sorted(spellSorter).map(entry -> ((ResourceLocation)entry.getKey()).toString()).collect(Collectors.toList());
        SpellContainer newContainer = container.copy();
        newContainer.spell_ids = sortedSpellIds;
        return newContainer;
    }

    public static void addSpell(ResourceLocation spellId, ItemStack itemStack) {
        SpellContainer container = SpellContainerHelper.containerFromItemStack(itemStack);
        if (container == null || !container.isValid()) {
            System.err.println("Trying to add spell: " + spellId + " to an ItemStack without valid spell container");
            return;
        }
        SpellContainer modifiedContainer = SpellContainerHelper.addSpell(spellId, container);
        CompoundTag nbtContainer = SpellContainerHelper.toNBT(modifiedContainer);
        CompoundTag nbt = itemStack.m_41784_();
        nbt.m_128365_("spell_container", (Tag)nbtContainer);
    }

    public static boolean hasValidContainer(ItemStack itemStack) {
        return SpellContainerHelper.containerFromItemStack(itemStack) != null;
    }

    public static boolean hasBindableContainer(ItemStack itemStack) {
        SpellContainer container = SpellContainerHelper.containerFromItemStack(itemStack);
        return container != null && container.pool != null && !container.pool.isEmpty();
    }

    public static boolean hasUsableContainer(ItemStack itemStack) {
        SpellContainer container = SpellContainerHelper.containerFromItemStack(itemStack);
        return container != null && (container.isUsable() || container.is_proxy);
    }

    public static CompoundTag toNBT(SpellContainer container) {
        CompoundTag object = new CompoundTag();
        if (container.is_proxy) {
            object.m_128379_(NBT_KEY_PROXY, container.is_proxy);
        }
        if (container.pool != null) {
            object.m_128359_(NBT_KEY_POOL, container.pool);
        }
        if (container.max_spell_count != 0) {
            object.m_128405_(NBT_KEY_MAX_SPELL_COUNT, container.max_spell_count);
        }
        if (container.spell_ids.size() > 0) {
            ListTag spellList = new ListTag();
            for (String spellId : container.spell_ids) {
                StringTag element = StringTag.m_129297_((String)spellId);
                spellList.add((Object)element);
            }
            object.m_128365_(NBT_KEY_SPELL_IDS, (Tag)spellList);
        }
        if (container.content != SpellContainer.ContentType.MAGIC) {
            object.m_128359_("spell_container", container.content.toString());
        }
        return object;
    }

    public static SpellContainer fromNBT(CompoundTag nbt) {
        CompoundTag nbtContainer = nbt.m_128469_("spell_container");
        if (nbtContainer == null || nbtContainer.m_128456_()) {
            return null;
        }
        try {
            boolean is_proxy = false;
            if (nbtContainer.m_128441_(NBT_KEY_PROXY)) {
                is_proxy = nbtContainer.m_128471_(NBT_KEY_PROXY);
            }
            String pool = null;
            if (nbtContainer.m_128441_(NBT_KEY_POOL)) {
                pool = nbtContainer.m_128461_(NBT_KEY_POOL);
            }
            int max_spell_count = 0;
            if (nbtContainer.m_128441_(NBT_KEY_MAX_SPELL_COUNT)) {
                max_spell_count = nbtContainer.m_128451_(NBT_KEY_MAX_SPELL_COUNT);
            }
            ArrayList<String> spellIds = new ArrayList<String>();
            if (nbtContainer.m_128441_(NBT_KEY_SPELL_IDS)) {
                ListTag spellList = nbtContainer.m_128437_(NBT_KEY_SPELL_IDS, 8);
                for (int i = 0; i < spellList.size(); ++i) {
                    spellIds.add(spellList.m_128778_(i));
                }
            }
            SpellContainer.ContentType contentType = null;
            if (nbtContainer.m_128441_("spell_container")) {
                String contentTypeString = nbtContainer.m_128461_("spell_container");
                contentType = SpellContainer.ContentType.valueOf(contentTypeString);
            }
            return new SpellContainer(contentType, is_proxy, pool, max_spell_count, spellIds);
        }
        catch (Exception e) {
            System.err.println("Failed to decode spell container from NBT: " + e.getMessage());
            return null;
        }
    }
}

