/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.spell_engine.network.Packets;

public class SpellCooldownManager {
    private final Map<ResourceLocation, Entry> entries = Maps.newHashMap();
    private int tick;
    private final Player owner;

    public SpellCooldownManager(Player owner) {
        this.owner = owner;
    }

    public boolean isCoolingDown(ResourceLocation spell) {
        return this.getCooldownProgress(spell, 0.0f) > 0.0f;
    }

    public float getCooldownProgress(ResourceLocation spell, float tickDelta) {
        Entry entry = this.entries.get(spell);
        if (entry != null) {
            float f = entry.endTick - entry.startTick;
            float g = (float)entry.endTick - ((float)this.tick + tickDelta);
            return Mth.m_14036_((float)(g / f), (float)0.0f, (float)1.0f);
        }
        return 0.0f;
    }

    public void update() {
        ++this.tick;
        if (!this.entries.isEmpty()) {
            Iterator<Map.Entry<ResourceLocation, Entry>> iterator = this.entries.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ResourceLocation, Entry> entry = iterator.next();
                if (entry.getValue().endTick > this.tick) continue;
                iterator.remove();
                this.cooldownCleared(entry.getKey());
            }
        }
    }

    public void set(ResourceLocation spell, int duration, boolean force) {
        if (force || !this.entries.containsKey(spell) || this.entries.get(spell).timeLeft(this.tick) < duration) {
            this.entries.put(spell, new Entry(this.tick, this.tick + duration));
            this.cooldownSet(spell, duration);
        }
    }

    public void set(ResourceLocation spell, int duration) {
        this.set(spell, duration, true);
    }

    public void remove(ResourceLocation spell) {
        this.entries.remove(spell);
        this.cooldownCleared(spell);
    }

    protected void cooldownSet(ResourceLocation spell, int duration) {
        Player player = this.owner;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ServerPlayNetworking.send((ServerPlayer)serverPlayer, (ResourceLocation)Packets.SpellCooldown.ID, (FriendlyByteBuf)new Packets.SpellCooldown(spell, duration).write());
        }
    }

    protected void cooldownCleared(ResourceLocation spell) {
        Player player = this.owner;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ServerPlayNetworking.send((ServerPlayer)serverPlayer, (ResourceLocation)Packets.SpellCooldown.ID, (FriendlyByteBuf)new Packets.SpellCooldown(spell, 0).write());
        }
    }

    record Entry(int startTick, int endTick) {
        int timeLeft(int currentTick) {
            return Math.max(0, this.endTick - currentTick);
        }
    }
}

