/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.Function;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.api.effect.EntityImmunity;
import net.spell_engine.api.enchantment.Enchantments_SpellEngine;
import net.spell_engine.api.entity.SpellSpawnedEntity;
import net.spell_engine.api.event.CombatEvents;
import net.spell_engine.api.item.trinket.SpellBookItem;
import net.spell_engine.api.spell.CustomSpellHandler;
import net.spell_engine.api.spell.ParticleBatch;
import net.spell_engine.api.spell.Sound;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.SpellContainer;
import net.spell_engine.api.spell.SpellEvents;
import net.spell_engine.api.spell.SpellInfo;
import net.spell_engine.compat.QuiverCompat;
import net.spell_engine.compat.TrinketsCompat;
import net.spell_engine.entity.ConfigurableKnockback;
import net.spell_engine.entity.SpellCloud;
import net.spell_engine.entity.SpellProjectile;
import net.spell_engine.internals.SpellCastSyncHelper;
import net.spell_engine.internals.SpellContainerHelper;
import net.spell_engine.internals.SpellRegistry;
import net.spell_engine.internals.WorldScheduler;
import net.spell_engine.internals.arrow.ArrowHelper;
import net.spell_engine.internals.casting.SpellCast;
import net.spell_engine.internals.casting.SpellCasterEntity;
import net.spell_engine.particle.ParticleHelper;
import net.spell_engine.utils.AnimationHelper;
import net.spell_engine.utils.ItemCooldownManagerExtension;
import net.spell_engine.utils.SoundHelper;
import net.spell_engine.utils.TargetHelper;
import net.spell_power.api.SpellDamageSource;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;
import org.jetbrains.annotations.Nullable;

public class SpellHelper {
    public static float launchPointOffsetDefault = 0.5f;
    private static final float knockbackDefaultStrength = 0.4f;

    public static SpellCast.Attempt attemptCasting(Player player, ItemStack itemStack, ResourceLocation spellId) {
        return SpellHelper.attemptCasting(player, itemStack, spellId, true);
    }

    public static SpellCast.Attempt attemptCasting(Player player, ItemStack itemStack, ResourceLocation spellId, boolean checkAmmo) {
        AmmoResult ammoResult;
        SpellCasterEntity caster = (SpellCasterEntity)player;
        Spell spell = SpellRegistry.getSpell(spellId);
        if (spell == null) {
            return SpellCast.Attempt.none();
        }
        if (caster.getCooldownManager().isCoolingDown(spellId)) {
            return SpellCast.Attempt.failOnCooldown(new SpellCast.Attempt.OnCooldownInfo());
        }
        if (checkAmmo && !(ammoResult = SpellHelper.ammoForSpell(player, spell, itemStack)).satisfied()) {
            return SpellCast.Attempt.failMissingItem(new SpellCast.Attempt.MissingItemInfo(ammoResult.ammo.m_41720_()));
        }
        return SpellCast.Attempt.success();
    }

    public static AmmoResult ammoForSpell(Player player, Spell spell, ItemStack itemStack) {
        boolean ignoreAmmo;
        boolean satisfied = true;
        ItemStack ammo = null;
        boolean bl = ignoreAmmo = player.m_150110_().f_35937_ || !SpellEngineMod.config.spell_cost_item_allowed;
        if (!ignoreAmmo && spell.cost.item_id != null && !spell.cost.item_id.isEmpty()) {
            boolean hasInfinity;
            ResourceLocation id = new ResourceLocation(spell.cost.item_id);
            boolean needsArrow = id.m_135815_().contains("arrow");
            boolean bl2 = needsArrow ? EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)itemStack) > 0 : (hasInfinity = EnchantmentHelper.m_44843_((Enchantment)Enchantments_SpellEngine.INFINITY, (ItemStack)itemStack) > 0);
            if (hasInfinity) {
                return new AmmoResult(satisfied, ammo);
            }
            Item ammoItem = (Item)BuiltInRegistries.f_257033_.m_7745_(id);
            if (ammoItem != null) {
                ammo = ammoItem.m_7968_();
                satisfied = player.m_150109_().m_36063_(ammo);
                if (needsArrow) {
                    satisfied = satisfied || QuiverCompat.hasArrow(ammoItem, player);
                }
            }
        }
        return new AmmoResult(satisfied, ammo);
    }

    public static float hasteAffectedValue(float value, float haste) {
        return value / haste;
    }

    public static float hasteAffectedValue(LivingEntity caster, SpellSchool school, float value) {
        return SpellHelper.hasteAffectedValue(caster, school, value, null);
    }

    public static float hasteAffectedValue(LivingEntity caster, SpellSchool school, float value, ItemStack provisionedWeapon) {
        float haste = SpellPower.getHaste((LivingEntity)caster, (SpellSchool)school);
        return SpellHelper.hasteAffectedValue(value, haste);
    }

    public static float getCastDuration(LivingEntity caster, Spell spell) {
        return SpellHelper.getCastDuration(caster, spell, null);
    }

    public static float getCastDuration(LivingEntity caster, Spell spell, ItemStack provisionedWeapon) {
        if (spell.cast == null) {
            return 0.0f;
        }
        return SpellHelper.hasteAffectedValue(caster, spell.school, spell.cast.duration, provisionedWeapon);
    }

    public static SpellCast.Duration getCastTimeDetails(LivingEntity caster, Spell spell) {
        float haste = spell.cast.haste_affected ? SpellPower.getHaste((LivingEntity)caster, (SpellSchool)spell.school) : 1.0f;
        float duration = SpellHelper.hasteAffectedValue(spell.cast.duration, haste);
        return new SpellCast.Duration(haste, Math.round(duration * 20.0f));
    }

    public static float getCooldownDuration(LivingEntity caster, Spell spell) {
        return SpellHelper.getCooldownDuration(caster, spell, null);
    }

    public static float getCooldownDuration(LivingEntity caster, Spell spell, ItemStack provisionedWeapon) {
        float duration = spell.cost.cooldown_duration;
        if (duration > 0.0f && SpellEngineMod.config.haste_affects_cooldown && spell.cost.cooldown_haste_affected) {
            duration = SpellHelper.hasteAffectedValue(caster, spell.school, spell.cost.cooldown_duration, provisionedWeapon);
        }
        return duration;
    }

    public static boolean isChanneled(Spell spell) {
        return SpellHelper.channelValueMultiplier(spell) != 0.0f;
    }

    public static boolean isInstant(Spell spell) {
        return spell.cast.duration == 0.0f;
    }

    public static float channelValueMultiplier(Spell spell) {
        int ticks = spell.cast.channel_ticks;
        if (ticks <= 0) {
            return 0.0f;
        }
        return (float)ticks / 20.0f;
    }

    public static void startCasting(Player player, ResourceLocation spellId, float speed, int length) {
        Spell spell = SpellRegistry.getSpell(spellId);
        if (spell == null) {
            return;
        }
        ItemStack itemStack = player.m_21205_();
        SpellCast.Attempt attempt = SpellHelper.attemptCasting(player, itemStack, spellId);
        if (!attempt.isSuccess()) {
            return;
        }
        SpellCast.Process process = new SpellCast.Process(spellId, spell, itemStack.m_41720_(), speed, length, player.m_9236_().m_46467_());
        SpellCastSyncHelper.setCasting(player, process);
        SoundHelper.playSound(player.m_9236_(), (Entity)player, spell.cast.start_sound);
    }

    public static void performSpell(Level world, Player player, ResourceLocation spellId, List<Entity> targets, SpellCast.Action action, float progress) {
        if (player.m_5833_()) {
            return;
        }
        Spell spell = SpellRegistry.getSpell(spellId);
        if (spell == null) {
            return;
        }
        SpellInfo spellInfo = new SpellInfo(spell, spellId);
        ItemStack itemStack = player.m_21205_();
        SpellCast.Attempt attempt = SpellHelper.attemptCasting(player, itemStack, spellId);
        if (!attempt.isSuccess()) {
            return;
        }
        float castingSpeed = ((SpellCasterEntity)player).getCurrentCastingSpeed();
        progress = Math.max(Math.min(progress, 1.0f), 0.0f);
        float channelMultiplier = 1.0f;
        boolean shouldPerformImpact = true;
        Supplier trackingPlayers = Suppliers.memoize(() -> PlayerLookup.tracking((Entity)player));
        switch (action) {
            case CHANNEL: {
                channelMultiplier = SpellHelper.channelValueMultiplier(spell);
                break;
            }
            case RELEASE: {
                if (SpellHelper.isChanneled(spell)) {
                    shouldPerformImpact = false;
                    channelMultiplier = 1.0f;
                } else {
                    channelMultiplier = progress >= 1.0f ? 1.0f : 0.0f;
                }
                SpellCastSyncHelper.clearCasting(player);
            }
        }
        AmmoResult ammoResult = SpellHelper.ammoForSpell(player, spell, itemStack);
        if (channelMultiplier > 0.0f && ammoResult.satisfied()) {
            boolean released;
            Spell.Release.Target targeting = spell.release.target;
            boolean bl = released = action == SpellCast.Action.RELEASE;
            if (shouldPerformImpact) {
                ImpactContext context = new ImpactContext(channelMultiplier, 1.0f, null, SpellPower.getSpellPower((SpellSchool)spell.school, (LivingEntity)player), SpellHelper.impactTargetingMode(spell));
                if (spell.release.custom_impact) {
                    Function<CustomSpellHandler.Data, Boolean> handler = CustomSpellHandler.handlers.get(spellId);
                    released = false;
                    if (handler != null) {
                        released = (Boolean)handler.apply((Object)new CustomSpellHandler.Data(player, targets, itemStack, action, progress, context));
                    }
                } else {
                    switch (targeting.type) {
                        case AREA: {
                            Vec3 center = player.m_20182_().m_82520_(0.0, (double)(player.m_20206_() / 2.0f), 0.0);
                            Spell.Release.Target.Area area = spell.release.target.area;
                            SpellHelper.applyAreaImpact(world, (LivingEntity)player, targets, spell.range, area, spellInfo, context.position(center), true);
                            break;
                        }
                        case BEAM: {
                            SpellHelper.beamImpact(world, (LivingEntity)player, targets, spellInfo, context);
                            break;
                        }
                        case CLOUD: {
                            SpellHelper.placeCloud(world, (LivingEntity)player, spellInfo, context);
                            released = true;
                            break;
                        }
                        case CURSOR: {
                            Entity target = targets.stream().findFirst();
                            if (target.isPresent()) {
                                SpellHelper.directImpact(world, (LivingEntity)player, (Entity)target.get(), spellInfo, context);
                                break;
                            }
                            released = false;
                            break;
                        }
                        case PROJECTILE: {
                            Entity target = null;
                            Optional entityFound = targets.stream().findFirst();
                            if (entityFound.isPresent()) {
                                target = (Entity)entityFound.get();
                            }
                            SpellHelper.shootProjectile(world, (LivingEntity)player, target, spellInfo, context);
                            break;
                        }
                        case METEOR: {
                            Entity target = targets.stream().findFirst();
                            if (target.isPresent()) {
                                SpellHelper.fallProjectile(world, (LivingEntity)player, (Entity)target.get(), spellInfo, context);
                                break;
                            }
                            released = false;
                            break;
                        }
                        case SELF: {
                            SpellHelper.directImpact(world, (LivingEntity)player, (Entity)player, spellInfo, context);
                            released = true;
                            break;
                        }
                        case SHOOT_ARROW: {
                            ArrowHelper.shootArrow(world, (LivingEntity)player, spellInfo, context);
                            released = true;
                        }
                    }
                }
            }
            if (released) {
                ParticleHelper.sendBatches((Entity)player, spell.release.particles);
                SoundHelper.playSound(world, (Entity)player, spell.release.sound);
                AnimationHelper.sendAnimation(player, (Collection)trackingPlayers.get(), SpellCast.Animation.RELEASE, spell.release.animation, castingSpeed);
                SpellHelper.imposeCooldown(player, spellId, spell, progress);
                player.m_36399_(spell.cost.exhaust * SpellEngineMod.config.spell_cost_exhaust_multiplier);
                if (SpellEngineMod.config.spell_cost_durability_allowed && spell.cost.durability > 0) {
                    itemStack.m_41622_(spell.cost.durability, (LivingEntity)player, playerObj -> {
                        playerObj.m_21166_(EquipmentSlot.MAINHAND);
                        playerObj.m_21166_(EquipmentSlot.OFFHAND);
                    });
                }
                if (ammoResult.ammo != null && spell.cost.consume_item) {
                    for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                        ItemStack stack = player.m_150109_().m_8020_(i);
                        if (!stack.m_150930_(ammoResult.ammo.m_41720_())) continue;
                        stack.m_41774_(1);
                        if (!stack.m_41619_()) break;
                        player.m_150109_().m_36057_(stack);
                        break;
                    }
                }
                if (spell.cost.effect_id != null) {
                    MobEffect effect = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(new ResourceLocation(spell.cost.effect_id));
                    player.m_21195_(effect);
                }
                if (CombatEvents.SPELL_CAST.isListened()) {
                    CombatEvents.SpellCast.Args args = new CombatEvents.SpellCast.Args(player, spellInfo, targets, action, progress);
                    CombatEvents.SPELL_CAST.invoke(listener -> listener.onSpellCast(args));
                }
            }
        }
    }

    public static void imposeCooldown(Player player, ResourceLocation spellId, Spell spell, float progress) {
        ItemStack spellBook;
        float duration = SpellHelper.cooldownToSet((LivingEntity)player, spell, progress);
        int durationTicks = Math.round(duration * 20.0f);
        if (duration > 0.0f) {
            ((SpellCasterEntity)player).getCooldownManager().set(spellId, durationTicks);
        }
        if (SpellEngineMod.config.spell_book_cooldown_lock && !(spellBook = TrinketsCompat.getSpellBookStack(player)).m_41619_()) {
            ItemCooldowns itemCooldowns;
            float durationLeft;
            Item spellBookItem = spellBook.m_41720_();
            SpellContainer container = SpellContainerHelper.containerFromItemStack(spellBook);
            if (SpellContainerHelper.contains(container, spellId) && (float)durationTicks > (durationLeft = (float)((ItemCooldownManagerExtension)(itemCooldowns = player.m_36335_())).SE_getLastCooldownDuration(spellBookItem) * itemCooldowns.m_41521_(spellBookItem, 0.0f))) {
                itemCooldowns.m_41524_(spellBookItem, durationTicks);
            }
        }
    }

    private static float cooldownToSet(LivingEntity caster, Spell spell, float progress) {
        if (spell.cost.cooldown_proportional) {
            return SpellHelper.getCooldownDuration(caster, spell) * progress;
        }
        return SpellHelper.getCooldownDuration(caster, spell);
    }

    public static float launchHeight(LivingEntity livingEntity) {
        float eyeHeight = livingEntity.m_20192_();
        double shoulderDistance = (double)livingEntity.m_20206_() * 0.15;
        return (float)(((double)eyeHeight - shoulderDistance) * (double)livingEntity.m_6134_());
    }

    public static Vec3 launchPoint(LivingEntity caster) {
        return SpellHelper.launchPoint(caster, launchPointOffsetDefault);
    }

    public static Vec3 launchPoint(LivingEntity caster, float forward) {
        Vec3 look = caster.m_20154_().m_82490_((double)(forward * caster.m_6134_()));
        return caster.m_20182_().m_82520_(0.0, (double)SpellHelper.launchHeight(caster), 0.0).m_82549_(look);
    }

    public static void shootProjectile(Level world, LivingEntity caster, Entity target, SpellInfo spellInfo, ImpactContext context) {
        SpellHelper.shootProjectile(world, caster, target, spellInfo, context, 0);
    }

    public static void shootProjectile(Level world, LivingEntity caster, Entity target, SpellInfo spellInfo, ImpactContext context, int sequenceIndex) {
        if (world.f_46443_) {
            return;
        }
        Spell spell = spellInfo.spell();
        Vec3 launchPoint = SpellHelper.launchPoint(caster);
        Spell.Release.Target.ShootProjectile data = spell.release.target.projectile;
        Spell.ProjectileData projectileData = data.projectile;
        Spell.ProjectileData.Perks mutablePerks = projectileData.perks.copy();
        SpellProjectile projectile = new SpellProjectile(world, caster, launchPoint.m_7096_(), launchPoint.m_7098_(), launchPoint.m_7094_(), SpellProjectile.Behaviour.FLY, spellInfo.id(), target, context, mutablePerks);
        Spell.LaunchProperties mutableLaunchProperties = data.launch_properties.copy();
        if (SpellEvents.PROJECTILE_SHOOT.isListened()) {
            SpellEvents.PROJECTILE_SHOOT.invoke(listener -> listener.onProjectileLaunch(new SpellEvents.ProjectileLaunchEvent(projectile, mutableLaunchProperties, caster, target, spellInfo, context, sequenceIndex)));
        }
        float velocity = mutableLaunchProperties.velocity;
        float divergence = projectileData.divergence;
        if (data.inherit_shooter_velocity) {
            projectile.m_37251_((Entity)caster, caster.m_146909_(), caster.m_146908_(), caster.m_21256_(), velocity, divergence);
        } else {
            Vec3 look = caster.m_20154_().m_82541_();
            projectile.m_6686_(look.f_82479_, look.f_82480_, look.f_82481_, velocity, divergence);
        }
        projectile.range = spell.range;
        projectile.m_146926_(caster.m_146909_());
        projectile.m_146922_(caster.m_146908_());
        world.m_7967_((Entity)projectile);
        if (sequenceIndex == 0 && mutableLaunchProperties.extra_launch_count > 0) {
            for (int i = 0; i < mutableLaunchProperties.extra_launch_count; ++i) {
                int ticks = (i + 1) * mutableLaunchProperties.extra_launch_delay;
                int nextSequenceIndex = i + 1;
                ((WorldScheduler)world).schedule(ticks, () -> {
                    if (caster == null || !caster.m_6084_()) {
                        return;
                    }
                    SpellHelper.shootProjectile(world, caster, target, spellInfo, context, nextSequenceIndex);
                });
            }
        }
    }

    public static void fallProjectile(Level world, LivingEntity caster, Entity target, SpellInfo spellInfo, ImpactContext context) {
        SpellHelper.fallProjectile(world, caster, target, spellInfo, context, 0);
    }

    public static void fallProjectile(Level world, LivingEntity caster, Entity target, SpellInfo spellInfo, ImpactContext context, int sequenceIndex) {
        if (world.f_46443_) {
            return;
        }
        Spell spell = spellInfo.spell();
        Spell.Release.Target.Meteor meteor = spell.release.target.meteor;
        float height = meteor.launch_height;
        Vec3 launchPoint = target.m_20182_().m_82520_(0.0, (double)height, 0.0);
        Spell.Release.Target.Meteor data = spell.release.target.meteor;
        Spell.ProjectileData projectileData = data.projectile;
        Spell.LaunchProperties mutableLaunchProperties = data.launch_properties.copy();
        Spell.ProjectileData.Perks mutablePerks = projectileData.perks.copy();
        SpellProjectile projectile = new SpellProjectile(world, caster, launchPoint.m_7096_(), launchPoint.m_7098_(), launchPoint.m_7094_(), SpellProjectile.Behaviour.FALL, spellInfo.id(), target, context, mutablePerks);
        if (SpellEvents.PROJECTILE_FALL.isListened()) {
            SpellEvents.PROJECTILE_FALL.invoke(listener -> listener.onProjectileLaunch(new SpellEvents.ProjectileLaunchEvent(projectile, mutableLaunchProperties, caster, target, spellInfo, context, sequenceIndex)));
        }
        projectile.m_146922_(0.0f);
        projectile.m_146926_(90.0f);
        if (SpellHelper.launchSequenceEligible(sequenceIndex, meteor.divergence_requires_sequence)) {
            projectile.setVelocity(0.0, -1.0, 0.0, mutableLaunchProperties.velocity, 0.5f, projectileData.divergence);
        } else {
            projectile.m_20256_(new Vec3(0.0, (double)(-mutableLaunchProperties.velocity), 0.0));
        }
        if (SpellHelper.launchSequenceEligible(sequenceIndex, meteor.follow_target_requires_sequence)) {
            projectile.setFollowedTarget(target);
        } else {
            projectile.setFollowedTarget(null);
        }
        if (meteor.launch_radius > 0.0f && SpellHelper.launchSequenceEligible(sequenceIndex, meteor.offset_requires_sequence)) {
            double randomAngle = Math.toRadians(world.f_46441_.m_188501_() * 360.0f);
            Vec3 offset = new Vec3((double)meteor.launch_radius, 0.0, 0.0).m_82524_((float)randomAngle);
            projectile.m_146884_(projectile.m_20182_().m_82549_(offset));
        }
        projectile.f_19859_ = projectile.m_146908_();
        projectile.f_19860_ = projectile.m_146909_();
        projectile.range = height;
        world.m_7967_((Entity)projectile);
        if (sequenceIndex == 0 && mutableLaunchProperties.extra_launch_count > 0) {
            for (int i = 0; i < mutableLaunchProperties.extra_launch_count; ++i) {
                int ticks = (i + 1) * mutableLaunchProperties.extra_launch_delay;
                int nextSequenceIndex = i + 1;
                ((WorldScheduler)world).schedule(ticks, () -> {
                    if (caster == null || !caster.m_6084_()) {
                        return;
                    }
                    SpellHelper.fallProjectile(world, caster, target, spellInfo, context, nextSequenceIndex);
                });
            }
        }
    }

    private static boolean launchSequenceEligible(int index, int rule) {
        if (rule == 0) {
            return false;
        }
        if (rule > 0) {
            return index >= rule;
        }
        return index < -1 * rule;
    }

    private static void directImpact(Level world, LivingEntity caster, Entity target, SpellInfo spellInfo, ImpactContext context) {
        SpellHelper.performImpacts(world, caster, target, target, spellInfo, context);
    }

    private static void beamImpact(Level world, LivingEntity caster, List<Entity> targets, SpellInfo spellInfo, ImpactContext context) {
        for (Entity target : targets) {
            SpellHelper.performImpacts(world, caster, target, target, spellInfo, context.position(target.m_20182_()));
        }
    }

    public static void fallImpact(LivingEntity caster, Entity projectile, SpellInfo spellInfo, ImpactContext context) {
        Vec3 adjustedCenter = context.position().m_82520_(0.0, 1.0, 0.0);
        SpellHelper.performImpacts(projectile.m_9236_(), caster, null, projectile, spellInfo, context.position(adjustedCenter));
    }

    public static boolean projectileImpact(LivingEntity caster, Entity projectile, Entity target, SpellInfo spellInfo, ImpactContext context) {
        return SpellHelper.performImpacts(projectile.m_9236_(), caster, target, projectile, spellInfo, context);
    }

    public static void lookupAndPerformAreaImpact(Spell.AreaImpact area_impact, SpellInfo spellInfo, LivingEntity caster, Entity exclude, Entity aoeSource, ImpactContext context, boolean additionalTargetLookup) {
        Vec3 center = context.position();
        float radius = area_impact.combinedRadius(context.power());
        List<Entity> targets = TargetHelper.targetsFromArea(aoeSource, center, radius, area_impact.area, null);
        if (exclude != null) {
            targets.remove(exclude);
        }
        SpellHelper.applyAreaImpact(aoeSource.m_9236_(), caster, targets, radius, area_impact.area, spellInfo, context.target(TargetHelper.TargetingMode.AREA), additionalTargetLookup);
        ParticleHelper.sendBatches(aoeSource, area_impact.particles);
        SoundHelper.playSound(aoeSource.m_9236_(), aoeSource, area_impact.sound);
    }

    private static void applyAreaImpact(Level world, LivingEntity caster, List<Entity> targets, float range, Spell.Release.Target.Area area, SpellInfo spellInfo, ImpactContext context, boolean additionalTargetLookup) {
        double squaredRange = range * range;
        Vec3 center = context.position();
        for (Entity target : targets) {
            float distanceBasedMultiplier = 1.0f;
            switch (area.distance_dropoff) {
                case NONE: {
                    break;
                }
                case SQUARED: {
                    distanceBasedMultiplier = (float)((squaredRange - target.m_20238_(center)) / squaredRange);
                    distanceBasedMultiplier = Math.max(distanceBasedMultiplier, 0.0f);
                }
            }
            SpellHelper.performImpacts(world, caster, target, target, spellInfo, context.distance(distanceBasedMultiplier), additionalTargetLookup);
        }
    }

    public static boolean performImpacts(Level world, LivingEntity caster, @Nullable Entity target, Entity aoeSource, SpellInfo spellInfo, ImpactContext context) {
        return SpellHelper.performImpacts(world, caster, target, aoeSource, spellInfo, context, true);
    }

    public static boolean performImpacts(Level world, LivingEntity caster, @Nullable Entity target, Entity aoeSource, SpellInfo spellInfo, ImpactContext context, boolean additionalTargetLookup) {
        Collection trackers = target != null ? PlayerLookup.tracking((Entity)target) : null;
        Spell spell = spellInfo.spell();
        boolean performed = false;
        TargetHelper.Intent selectedIntent = null;
        for (Spell.Impact impact : spell.impact) {
            TargetHelper.Intent intent = SpellHelper.intent(impact.action);
            if (!impact.action.apply_to_caster && selectedIntent != null && selectedIntent != intent || target == null) continue;
            boolean result = SpellHelper.performImpact(world, caster, target, spellInfo, impact, context, trackers);
            boolean bl = performed = performed || result;
            if (!result) continue;
            selectedIntent = intent;
        }
        Spell.AreaImpact area_impact = spell.area_impact;
        if (area_impact != null && additionalTargetLookup && (performed || target == null)) {
            SpellHelper.lookupAndPerformAreaImpact(area_impact, spellInfo, caster, target, aoeSource, context, false);
        }
        return performed;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean performImpact(Level world, LivingEntity caster, Entity target, SpellInfo spellInfo, Spell.Impact impact, ImpactContext context, Collection<ServerPlayer> trackers) {
        block42: {
            if (!target.m_6097_()) {
                return false;
            }
            success = false;
            isKnockbackPushed = false;
            spell = spellInfo.spell();
            try {
                particleMultiplier = 1.0f * context.total();
                power = context.power();
                v0 = school = impact.school != null ? impact.school : spell.school;
                if (power == null || power.school() != school) {
                    power = SpellPower.getSpellPower((SpellSchool)school, (LivingEntity)caster);
                }
                if (power.baseValue() < (double)impact.action.min_power) {
                    power = new SpellPower.Result(power.school(), (double)impact.action.min_power, power.criticalChance(), power.criticalDamage());
                }
                if (impact.action.apply_to_caster) {
                    target = caster;
                }
                intent = SpellHelper.intent(impact.action);
                if (!TargetHelper.actionAllowed(context.targetingMode(), intent, caster, target)) {
                    return false;
                }
                if (intent == TargetHelper.Intent.HARMFUL && context.targetingMode() == TargetHelper.TargetingMode.AREA && ((EntityImmunity)target).isImmuneTo(EntityImmunity.Type.AREA_EFFECT)) {
                    return false;
                }
                switch (1.$SwitchMap$net$spell_engine$api$spell$Spell$Impact$Action$Type[impact.action.type.ordinal()]) {
                    case 1: {
                        damageData = impact.action.damage;
                        knockbackMultiplier = Math.max(0.0f, damageData.knockback * context.total());
                        vulnerability = SpellPower.Vulnerability.none;
                        timeUntilRegen = target.f_19802_;
                        if (target instanceof LivingEntity) {
                            livingEntity = (LivingEntity)target;
                            ((ConfigurableKnockback)livingEntity).pushKnockbackMultiplier_SpellEngine(context.hasOffset() != false ? 0.0f : knockbackMultiplier);
                            isKnockbackPushed = true;
                            if (damageData.bypass_iframes && SpellEngineMod.config.bypass_iframes) {
                                target.f_19802_ = 0;
                            }
                            vulnerability = SpellPower.getVulnerability((LivingEntity)livingEntity, (SpellSchool)school);
                        }
                        amount = power.randomValue(vulnerability);
                        amount *= (double)damageData.spell_power_coefficient;
                        amount *= (double)context.total();
                        if (context.isChanneled()) {
                            amount *= (double)SpellPower.getHaste((LivingEntity)caster, (SpellSchool)school);
                        }
                        particleMultiplier = power.criticalDamage() + (double)vulnerability.criticalDamageBonus();
                        caster.m_21335_(target);
                        target.m_6469_(SpellDamageSource.create((SpellSchool)school, (LivingEntity)caster), (float)amount);
                        if (target instanceof LivingEntity) {
                            livingEntity = (LivingEntity)target;
                            ((ConfigurableKnockback)livingEntity).popKnockbackMultiplier_SpellEngine();
                            isKnockbackPushed = false;
                            target.f_19802_ = timeUntilRegen;
                            if (context.hasOffset()) {
                                direction = context.knockbackDirection(livingEntity.m_20182_()).m_82548_();
                                livingEntity.m_147240_((double)(0.4f * knockbackMultiplier), direction.f_82479_, direction.f_82481_);
                            }
                        }
                        success = true;
                        break;
                    }
                    case 2: {
                        if (!(target instanceof LivingEntity)) break;
                        livingTarget = (LivingEntity)target;
                        healData = impact.action.heal;
                        particleMultiplier = power.criticalDamage();
                        amount = power.randomValue();
                        amount *= (double)healData.spell_power_coefficient;
                        amount *= (double)context.total();
                        if (context.isChanneled()) {
                            amount *= (double)SpellPower.getHaste((LivingEntity)caster, (SpellSchool)school);
                        }
                        livingTarget.m_5634_((float)amount);
                        success = true;
                        break;
                    }
                    case 3: {
                        data = impact.action.status_effect;
                        if (!(target instanceof LivingEntity)) break;
                        livingTarget = (LivingEntity)target;
                        id = new ResourceLocation(data.effect_id);
                        effect = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(id);
                        if (!SpellHelper.underApplyLimit(power, livingTarget, school, data.apply_limit)) {
                            return false;
                        }
                        duration = Math.round(data.duration * 20.0f);
                        amplifier = data.amplifier + (int)((double)data.amplifier_power_multiplier * power.nonCriticalValue());
                        showParticles = data.show_particles;
                        switch (1.$SwitchMap$net$spell_engine$api$spell$Spell$Impact$Action$StatusEffect$ApplyMode[data.apply_mode.ordinal()]) {
                            case 1: {
                                break;
                            }
                            case 2: {
                                currentEffect = livingTarget.m_21124_(effect);
                                newAmplifier = 0;
                                if (currentEffect != null) {
                                    incrementedAmplifier = currentEffect.m_19564_() + 1;
                                    newAmplifier = Math.min(incrementedAmplifier, amplifier);
                                }
                                amplifier = newAmplifier;
                            }
                        }
                        livingTarget.m_147207_(new MobEffectInstance(effect, duration, amplifier, false, showParticles, true), (Entity)caster);
                        success = true;
                        break;
                    }
                    case 4: {
                        data = impact.action.fire;
                        target.m_20254_(data.duration);
                        if (target.m_20094_() <= 0) break;
                        target.m_7311_(target.m_20094_() + data.tick_offset);
                        break;
                    }
                    case 5: {
                        spawns = impact.action.spawns.length > 0 ? List.of(impact.action.spawns) : List.of(impact.action.spawn);
                        for (Spell.Impact.Action.Spawn data : spawns) {
                            id = new ResourceLocation(data.entity_type_id);
                            type = (EntityType)BuiltInRegistries.f_256780_.m_7745_(id);
                            entity = type.m_20615_(world);
                            SpellHelper.applyEntityPlacement(entity, caster, target.m_20182_(), data.placement);
                            if (entity instanceof SpellSpawnedEntity) {
                                spellSpawnedEntity = (SpellSpawnedEntity)entity;
                                spellSpawnedEntity.onCreatedFromSpell(caster, spellInfo.id(), data);
                            }
                            ((WorldScheduler)world).schedule(data.delay_ticks, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$performImpact$7(net.minecraft.world.level.Level net.minecraft.world.entity.Entity ), ()V)((Level)world, (Entity)entity));
                            success = true;
                        }
                        break;
                    }
                    case 6: {
                        data = impact.action.teleport;
                        if (!(target instanceof LivingEntity)) break;
                        livingTarget = (LivingEntity)target;
                        teleportedEntity = null;
                        destination = null;
                        startingPosition = null;
                        applyRotation = null;
                        switch (1.$SwitchMap$net$spell_engine$api$spell$Spell$Impact$Action$Teleport$Mode[data.mode.ordinal()]) {
                            case 1: {
                                teleportedEntity = livingTarget;
                                forward = data.forward;
                                look = target.m_20154_();
                                startingPosition = target.m_20182_();
                                destination = TargetHelper.findTeleportDestination(teleportedEntity, look, forward.distance, data.required_clearance_block_y);
                                groundJustBelow = TargetHelper.findSolidBlockBelow(teleportedEntity, destination, target.m_9236_(), -1.5f);
                                if (groundJustBelow == null) break;
                                destination = groundJustBelow;
                                break;
                            }
                            case 2: {
                                if (livingTarget == caster) {
                                    return false;
                                }
                                look = target.m_20154_();
                                distance = 1.0f;
                                if (data.behind_target != null) {
                                    distance = data.behind_target.distance;
                                }
                                teleportedEntity = caster;
                                startingPosition = caster.m_20182_();
                                destination = target.m_20182_().m_82549_(look.m_82490_((double)(-distance)));
                                groundJustBelow = TargetHelper.findSolidBlockBelow(teleportedEntity, destination, target.m_9236_(), -1.5f);
                                if (groundJustBelow != null) {
                                    destination = groundJustBelow;
                                }
                                yaw = (yaw = (float)Math.toDegrees(Math.atan2(-(x = look.f_82479_), z = look.f_82481_))) < 0.0f ? yaw + 360.0f : yaw;
                                applyRotation = Float.valueOf(yaw);
                            }
                        }
                        if (destination == null || startingPosition == null || teleportedEntity == null) break;
                        ParticleHelper.sendBatches((Entity)teleportedEntity, data.depart_particles, false);
                        world.m_214171_(GameEvent.f_238175_, startingPosition, GameEvent.Context.m_223717_((Entity)teleportedEntity));
                        if (applyRotation == null || !(teleportedEntity instanceof ServerPlayer)) ** GOTO lbl-1000
                        serverPlayer = (ServerPlayer)teleportedEntity;
                        if (world instanceof ServerLevel) {
                            serverWorld = (ServerLevel)world;
                            serverPlayer.m_8999_(serverWorld, destination.f_82479_, destination.f_82480_, destination.f_82481_, applyRotation.floatValue(), serverPlayer.m_146909_());
                        } else lbl-1000:
                        // 2 sources

                        {
                            teleportedEntity.m_20324_(destination.f_82479_, destination.f_82480_, destination.f_82481_);
                        }
                        success = true;
                        ParticleHelper.sendBatches((Entity)teleportedEntity, data.arrive_particles, false);
                    }
                }
                if (success) {
                    if (impact.particles != null) {
                        ParticleHelper.sendBatches(target, impact.particles, (float)particleMultiplier, trackers);
                    }
                    if (impact.sound != null) {
                        SoundHelper.playSound(world, target, impact.sound);
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Failed to perform impact effect");
                System.err.println(e.getMessage());
                if (!isKnockbackPushed) break block42;
                ((ConfigurableKnockback)target).popKnockbackMultiplier_SpellEngine();
            }
        }
        return success;
    }

    public static void placeCloud(Level world, LivingEntity caster, SpellInfo spellInfo, ImpactContext context) {
        Spell spell = spellInfo.spell();
        List<Spell.Release.Target.Cloud> clouds = spell.release.target.clouds.length > 0 ? List.of(spell.release.target.clouds) : List.of(spell.release.target.cloud);
        for (Spell.Release.Target.Cloud cloud : clouds) {
            SpellCloud entity;
            if (cloud.entity_type_id != null) {
                ResourceLocation id = new ResourceLocation(cloud.entity_type_id);
                EntityType type = (EntityType)BuiltInRegistries.f_256780_.m_7745_(id);
                entity = (SpellCloud)type.m_20615_(world);
            } else {
                entity = new SpellCloud(world);
            }
            entity.setOwner(caster);
            entity.onCreatedFromSpell(spellInfo.id(), cloud, context);
            SpellHelper.applyEntityPlacement(entity, caster, caster.m_20182_(), cloud.placement);
            ((WorldScheduler)world).schedule(cloud.delay_ticks, () -> {
                ParticleBatch[] particles;
                world.m_7967_((Entity)entity);
                Sound sound = cloud.spawn.sound;
                if (sound != null) {
                    SoundHelper.playSound(world, entity, sound);
                }
                if ((particles = cloud.spawn.particles) != null) {
                    ParticleHelper.sendBatches(entity, particles);
                }
            });
        }
    }

    public static void applyEntityPlacement(Entity entity, LivingEntity target, Vec3 initialPosition, Spell.EntityPlacement placement) {
        Vec3 position = initialPosition;
        if (placement != null) {
            if (placement.location_offset_by_look > 0.0f) {
                float yaw = target.m_146908_() + placement.location_yaw_offset;
                position = position.m_82549_(Vec3.m_82498_((float)0.0f, (float)yaw).m_82490_((double)placement.location_offset_by_look));
            }
            position = position.m_82549_(new Vec3((double)placement.location_offset_x, (double)placement.location_offset_y, (double)placement.location_offset_z));
            if (placement.force_onto_ground) {
                Vec3 groundPosBelow;
                Vec3 searchPosition = position;
                BlockPos blockPos = BlockPos.m_274561_((double)searchPosition.m_7096_(), (double)searchPosition.m_7098_(), (double)searchPosition.m_7094_());
                if (target.m_9236_().m_8055_(blockPos).m_280296_()) {
                    searchPosition = searchPosition.m_82520_(0.0, 2.0, 0.0);
                }
                Vec3 vec3 = position = (groundPosBelow = TargetHelper.findSolidBlockBelow(target, searchPosition, target.m_9236_(), -20.0f)) != null ? groundPosBelow : position;
            }
            if (placement.apply_yaw) {
                entity.m_146922_(target.m_146908_());
            }
            if (placement.apply_pitch) {
                entity.m_146926_(target.m_146909_());
            }
            position = position.m_82549_(new Vec3((double)placement.location_offset_x, (double)placement.location_offset_y, (double)placement.location_offset_z));
        }
        entity.m_6034_(position.m_7096_(), position.m_7098_(), position.m_7094_());
    }

    public static TargetHelper.TargetingMode selectionTargetingMode(Spell spell) {
        switch (spell.release.target.type) {
            case AREA: 
            case BEAM: {
                return TargetHelper.TargetingMode.AREA;
            }
            case CLOUD: 
            case CURSOR: 
            case PROJECTILE: 
            case METEOR: 
            case SELF: 
            case SHOOT_ARROW: {
                return TargetHelper.TargetingMode.DIRECT;
            }
        }
        return null;
    }

    public static TargetHelper.TargetingMode impactTargetingMode(Spell spell) {
        switch (spell.release.target.type) {
            case AREA: 
            case BEAM: 
            case METEOR: {
                return TargetHelper.TargetingMode.AREA;
            }
            case CLOUD: 
            case CURSOR: 
            case PROJECTILE: 
            case SELF: 
            case SHOOT_ARROW: {
                return TargetHelper.TargetingMode.DIRECT;
            }
        }
        return null;
    }

    public static EnumSet<TargetHelper.Intent> intents(Spell spell) {
        HashSet<TargetHelper.Intent> intents = new HashSet<TargetHelper.Intent>();
        for (Spell.Impact impact : spell.impact) {
            intents.add(SpellHelper.intent(impact.action));
        }
        return EnumSet.copyOf(intents);
    }

    public static TargetHelper.Intent intent(Spell.Impact.Action action) {
        switch (action.type) {
            case DAMAGE: 
            case FIRE: {
                return TargetHelper.Intent.HARMFUL;
            }
            case HEAL: 
            case SPAWN: {
                return TargetHelper.Intent.HELPFUL;
            }
            case STATUS_EFFECT: {
                Spell.Impact.Action.StatusEffect data = action.status_effect;
                ResourceLocation id = new ResourceLocation(data.effect_id);
                MobEffect effect = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(id);
                return effect.m_19486_() ? TargetHelper.Intent.HELPFUL : TargetHelper.Intent.HARMFUL;
            }
            case TELEPORT: {
                return action.teleport.intent;
            }
        }
        return null;
    }

    public static boolean underApplyLimit(SpellPower.Result spellPower, LivingEntity target, SpellSchool school, Spell.Impact.Action.StatusEffect.ApplyLimit limit) {
        if (limit == null) {
            return true;
        }
        float power = (float)spellPower.nonCriticalValue();
        float cap = limit.health_base + power * limit.spell_power_multiplier;
        return cap >= target.m_21233_();
    }

    public static EstimatedOutput estimate(Spell spell, Player caster, ItemStack itemStack) {
        SpellSchool spellSchool = spell.school;
        ArrayList<EstimatedValue> damageEffects = new ArrayList<EstimatedValue>();
        ArrayList<EstimatedValue> healEffects = new ArrayList<EstimatedValue>();
        boolean forSpellBook = itemStack.m_41720_() instanceof SpellBookItem;
        boolean replaceAttributes = caster.m_21205_() != itemStack && !forSpellBook;
        Multimap heldAttributes = caster.m_21205_().m_41638_(EquipmentSlot.MAINHAND);
        Multimap itemAttributes = itemStack.m_41638_(EquipmentSlot.MAINHAND);
        if (replaceAttributes) {
            caster.m_21204_().m_22161_(heldAttributes);
            caster.m_21204_().m_22178_(itemAttributes);
        }
        block4: for (Spell.Impact impact : spell.impact) {
            SpellSchool school = impact.school != null ? impact.school : spellSchool;
            SpellPower.Result power = SpellPower.getSpellPower((SpellSchool)school, (LivingEntity)caster);
            if (power.baseValue() < (double)impact.action.min_power) {
                power = new SpellPower.Result(power.school(), (double)impact.action.min_power, power.criticalChance(), power.criticalDamage());
            }
            switch (impact.action.type) {
                case DAMAGE: {
                    Spell.Impact.Action.Damage damageData = impact.action.damage;
                    EstimatedValue damage = new EstimatedValue(power.nonCriticalValue(), power.forcedCriticalValue()).multiply(damageData.spell_power_coefficient);
                    damageEffects.add(damage);
                    continue block4;
                }
                case HEAL: {
                    Spell.Impact.Action.Heal healData = impact.action.heal;
                    EstimatedValue healing = new EstimatedValue(power.nonCriticalValue(), power.forcedCriticalValue()).multiply(healData.spell_power_coefficient);
                    healEffects.add(healing);
                    continue block4;
                }
            }
        }
        if (replaceAttributes) {
            caster.m_21204_().m_22161_(itemAttributes);
            caster.m_21204_().m_22178_(heldAttributes);
        }
        return new EstimatedOutput(damageEffects, healEffects);
    }

    private static /* synthetic */ void lambda$performImpact$7(Level world, Entity entity) {
        world.m_7967_(entity);
    }

    public record AmmoResult(boolean satisfied, ItemStack ammo) {
    }

    public record ImpactContext(float channel, float distance, @Nullable Vec3 position, SpellPower.Result power, TargetHelper.TargetingMode targetingMode) {
        public ImpactContext() {
            this(1.0f, 1.0f, null, null, TargetHelper.TargetingMode.DIRECT);
        }

        public ImpactContext channeled(float multiplier) {
            return new ImpactContext(multiplier, this.distance, this.position, this.power, this.targetingMode);
        }

        public ImpactContext distance(float multiplier) {
            return new ImpactContext(this.channel, multiplier, this.position, this.power, this.targetingMode);
        }

        public ImpactContext position(Vec3 position) {
            return new ImpactContext(this.channel, this.distance, position, this.power, this.targetingMode);
        }

        public ImpactContext power(SpellPower.Result spellPower) {
            return new ImpactContext(this.channel, this.distance, this.position, spellPower, this.targetingMode);
        }

        public ImpactContext target(TargetHelper.TargetingMode targetingMode) {
            return new ImpactContext(this.channel, this.distance, this.position, this.power, targetingMode);
        }

        public boolean hasOffset() {
            return this.position != null;
        }

        public Vec3 knockbackDirection(Vec3 targetPosition) {
            return targetPosition.m_82546_(this.position).m_82541_();
        }

        public boolean isChanneled() {
            return this.channel != 1.0f;
        }

        public float total() {
            return this.channel * this.distance;
        }
    }

    public record EstimatedValue(double min, double max) {
        public EstimatedValue multiply(double value) {
            return new EstimatedValue(this.min * value, this.max * value);
        }
    }

    public record EstimatedOutput(List<EstimatedValue> damage, List<EstimatedValue> heal) {
    }
}

