/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals.casting;

import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.SpellRegistry;
import org.jetbrains.annotations.Nullable;

public class SpellCast {

    public static enum Animation {
        CASTING,
        RELEASE;

    }

    public static enum Action {
        CHANNEL,
        RELEASE;

    }

    public static enum Mode {
        INSTANT,
        CHARGE,
        CHANNEL,
        ITEM_USE;


        public static Mode from(Spell spell) {
            switch (spell.mode) {
                case CAST: {
                    if (spell.cast.duration <= 0.0f) {
                        return INSTANT;
                    }
                    return SpellHelper.isChanneled(spell) ? CHANNEL : CHARGE;
                }
                case ITEM_USE: {
                    return ITEM_USE;
                }
            }
            return null;
        }
    }

    public record Progress(float ratio, Process process) {
    }

    public record Process(ResourceLocation id, Spell spell, Item item, float speed, int length, long startedAt) {
        public int spellCastTicksSoFar(long worldTime) {
            return (int)Math.max(worldTime - this.startedAt, 0L);
        }

        public Progress progress(int castTicks) {
            if (this.length <= 0) {
                return new Progress(1.0f, this);
            }
            float ratio = Math.min((float)castTicks / (float)this.length(), 1.0f);
            return new Progress(ratio, this);
        }

        public Progress progress(long worldTime) {
            int castTicks = this.spellCastTicksSoFar(worldTime);
            return this.progress(castTicks);
        }

        public SyncFormat sync() {
            return new SyncFormat(SpellRegistry.rawSpellId(this.id), this.speed, this.length);
        }

        public String fastSyncJSON() {
            return "{\"i\":" + SpellRegistry.rawSpellId(this.id) + ",\"s\":" + this.speed + ",\"l\":" + this.length + "}";
        }

        @Nullable
        public static Process fromSync(SyncFormat sync, Item item, long startedAt) {
            Optional<ResourceLocation> spellId = SpellRegistry.fromRawSpellId(sync.i());
            if (spellId.isEmpty()) {
                return null;
            }
            Spell spell = SpellRegistry.getSpell(spellId.get());
            return new Process(spellId.get(), spell, item, sync.s(), sync.l(), startedAt);
        }

        public record SyncFormat(int i, float s, int l) {
        }
    }

    public record Duration(float speed, int length) {
    }

    public record Attempt(Result result, @Nullable MissingItemInfo missingItem, @Nullable OnCooldownInfo onCooldown) {
        public static Attempt none() {
            return new Attempt(Result.NONE, null, null);
        }

        public static Attempt success() {
            return new Attempt(Result.SUCCESS, null, null);
        }

        public static Attempt failMissingItem(MissingItemInfo missingItem) {
            return new Attempt(Result.MISSING_ITEM, missingItem, null);
        }

        public static Attempt failOnCooldown(OnCooldownInfo onCooldown) {
            return new Attempt(Result.ON_COOLDOWN, null, onCooldown);
        }

        public boolean isSuccess() {
            return this.result == Result.SUCCESS;
        }

        public boolean isFail() {
            return this.result != Result.SUCCESS && this.result != Result.NONE;
        }

        public static enum Result {
            SUCCESS,
            MISSING_ITEM,
            ON_COOLDOWN,
            NONE;

        }

        public record MissingItemInfo(Item item) {
        }

        public record OnCooldownInfo() {
        }
    }
}

