/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.internals.criteria;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class EnchantmentSpecificCriteria
extends SimpleCriterionTrigger<Condition> {
    public static final ResourceLocation ID = new ResourceLocation("spell_engine", "enchant_specific");
    public static final EnchantmentSpecificCriteria INSTANCE = new EnchantmentSpecificCriteria();
    private static final String enchant_id_key = "enchant_id";

    protected Condition conditionsFromJson(JsonObject obj, ContextAwarePredicate playerPredicate, DeserializationContext predicateDeserializer) {
        JsonElement element = obj.get(enchant_id_key);
        return new Condition(element.getAsString());
    }

    public ResourceLocation m_7295_() {
        return ID;
    }

    public void trigger(ServerPlayer player, String enchantId) {
        this.m_66234_(player, condition -> condition.test(enchantId));
    }

    public static class Condition
    extends AbstractCriterionTriggerInstance {
        String enchantId;

        public Condition(String enchantId) {
            super(ID, ContextAwarePredicate.f_285567_);
            this.enchantId = enchantId;
        }

        public boolean test(String enchantId) {
            return this.enchantId.equals(enchantId);
        }

        public JsonObject m_7683_(SerializationContext predicateSerializer) {
            JsonObject jsonObject = super.m_7683_(predicateSerializer);
            jsonObject.add(EnchantmentSpecificCriteria.enchant_id_key, (JsonElement)new JsonPrimitive(this.enchantId));
            return jsonObject;
        }
    }
}

