/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.mixin.arrow;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.phys.EntityHitResult;
import net.spell_engine.api.spell.ParticleBatch;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.SpellInfo;
import net.spell_engine.entity.ConfigurableKnockback;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.SpellRegistry;
import net.spell_engine.internals.arrow.ArrowExtension;
import net.spell_engine.particle.ParticleHelper;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractArrow.class})
public abstract class PersistentProjectileEntityMixin
implements ArrowExtension {
    @Shadow
    protected boolean f_36703_;
    private boolean arrowPerksAlreadyApplied = false;
    private ResourceLocation spellId = null;
    private static final String NBT_KEY_SPELL_ID = "spell_id";
    private static final EntityDataAccessor<Integer> SPELL_ID_TRACKER = SynchedEntityData.m_135353_(AbstractArrow.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int client_lastResolvedSpellRawId = 0;
    @Nullable
    private Spell client_lastResolvedSpell = null;
    private boolean allowByPassingIFrames = true;

    @Shadow
    public abstract byte m_36796_();

    @Shadow
    public abstract void m_36767_(byte var1);

    @Shadow
    public abstract void m_36781_(double var1);

    @Shadow
    public abstract double m_36789_();

    private AbstractArrow arrow() {
        return (AbstractArrow)this;
    }

    @Nullable
    Spell spell() {
        if (this.spellId != null) {
            return SpellRegistry.getSpell(this.spellId);
        }
        return null;
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    public void writeCustomDataToNbt_TAIL_SpellEngine(CompoundTag nbt, CallbackInfo ci) {
        if (this.spellId != null) {
            nbt.m_128359_(NBT_KEY_SPELL_ID, this.spellId.toString());
        }
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    public void readCustomDataFromNbt_TAIL_SpellEngine(CompoundTag nbt, CallbackInfo ci) {
        String string;
        if (nbt.m_128441_(NBT_KEY_SPELL_ID) && (string = nbt.m_128461_(NBT_KEY_SPELL_ID)) != null && !string.isEmpty()) {
            this.spellId = new ResourceLocation(nbt.m_128461_(NBT_KEY_SPELL_ID));
        }
    }

    @Inject(method={"initDataTracker"}, at={@At(value="TAIL")})
    private void initDataTracker_TAIL_SpellEngine(CallbackInfo ci) {
        this.arrow().m_20088_().m_135372_(SPELL_ID_TRACKER, (Object)0);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tick_HEAD_SpellEngine(CallbackInfo ci) {
        Integer rawId;
        AbstractArrow arrow = this.arrow();
        if (arrow.m_9236_().f_46443_ && (rawId = (Integer)this.arrow().m_20088_().m_135370_(SPELL_ID_TRACKER)) != this.client_lastResolvedSpellRawId) {
            this.client_lastResolvedSpellRawId = rawId;
            this.spellId = SpellRegistry.fromRawSpellId(rawId).orElse(null);
            this.client_lastResolvedSpell = this.spell();
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tick_TAIL_SpellEngine(CallbackInfo ci) {
        Spell.ArrowPerks perks;
        if (this.client_lastResolvedSpell != null && (perks = this.client_lastResolvedSpell.arrow_perks) != null && perks.travel_particles != null) {
            AbstractArrow arrow = this.arrow();
            for (ParticleBatch travel_particles : perks.travel_particles) {
                ParticleHelper.play(arrow.m_9236_(), (Entity)arrow, arrow.m_146908_(), arrow.m_146909_(), travel_particles);
            }
        }
    }

    @Override
    public void allowByPassingIFrames_SpellEngine(boolean allow) {
        this.allowByPassingIFrames = allow;
    }

    @Override
    public boolean isInGround_SpellEngine() {
        return this.f_36703_;
    }

    @Override
    @Nullable
    public ResourceLocation getCarriedSpellId() {
        return this.spellId;
    }

    @Override
    @Nullable
    public Spell getCarriedSpell() {
        if (this.arrow().m_9236_().m_5776_()) {
            return this.client_lastResolvedSpell;
        }
        return this.spell();
    }

    @Override
    public void applyArrowPerks(SpellInfo spellInfo) {
        if (this.arrowPerksAlreadyApplied) {
            return;
        }
        AbstractArrow arrow = this.arrow();
        Spell.ArrowPerks perks = spellInfo.spell().arrow_perks;
        if (perks != null) {
            if (perks.velocity_multiplier != 1.0f) {
                arrow.m_20256_(arrow.m_20184_().m_82490_((double)perks.velocity_multiplier));
            }
            this.arrowPerksAlreadyApplied = true;
            if (perks.pierce > 0) {
                byte newPierce = (byte)(this.m_36796_() + perks.pierce);
                this.m_36767_(newPierce);
            }
            this.m_36781_(this.m_36789_() * (double)perks.damage_multiplier);
        }
        this.spellId = spellInfo.id();
        arrow.m_20088_().m_135381_(SPELL_ID_TRACKER, (Object)SpellRegistry.rawSpellId(spellInfo.id()));
    }

    @Inject(method={"onEntityHit"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;damage(Lnet/minecraft/entity/damage/DamageSource;F)Z")}, cancellable=true)
    private void onEntityHit_BeforeDamage_SpellEngine(EntityHitResult entityHitResult, CallbackInfo ci) {
        Spell.ArrowPerks arrowPerks;
        Spell spell = this.spell();
        if (spell != null && (arrowPerks = spell.arrow_perks) != null && arrowPerks.skip_arrow_damage) {
            ci.cancel();
            this.arrow().m_146870_();
            Entity entity = entityHitResult.m_82443_();
            if (entity != null) {
                this.performImpacts(entity, entityHitResult);
            }
        }
    }

    @WrapOperation(method={"onEntityHit"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;damage(Lnet/minecraft/entity/damage/DamageSource;F)Z")})
    private boolean wrapDamageEntity(Entity entity, DamageSource damageSource, float amount, Operation<Boolean> original, EntityHitResult entityHitResult) {
        Spell spell = this.spell();
        if (entity.m_9236_().m_5776_() || spell == null) {
            return (Boolean)original.call(new Object[]{entity, damageSource, Float.valueOf(amount)});
        }
        Spell.ArrowPerks arrowPerks = spell.arrow_perks;
        boolean pushedKnockback = false;
        int iFrameToRestore = 0;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (arrowPerks != null) {
                if (arrowPerks.knockback != 1.0f) {
                    ((ConfigurableKnockback)livingEntity).pushKnockbackMultiplier_SpellEngine(arrowPerks.knockback);
                    pushedKnockback = true;
                }
                if (this.allowByPassingIFrames && arrowPerks.bypass_iframes) {
                    iFrameToRestore = entity.f_19802_;
                    entity.f_19802_ = 0;
                }
                if (arrowPerks.iframe_to_set > 0) {
                    iFrameToRestore = arrowPerks.iframe_to_set;
                }
            }
        }
        Boolean result = (Boolean)original.call(new Object[]{entity, damageSource, Float.valueOf(amount)});
        this.performImpacts(entity, entityHitResult);
        if (pushedKnockback) {
            ((ConfigurableKnockback)entity).popKnockbackMultiplier_SpellEngine();
        }
        if (iFrameToRestore != 0) {
            entity.f_19802_ = iFrameToRestore;
        }
        return result;
    }

    private void performImpacts(Entity target, EntityHitResult entityHitResult) {
        Spell spell = this.spell();
        AbstractArrow arrow = this.arrow();
        Entity owner = arrow.m_19749_();
        if (spell != null && spell.impact != null && owner instanceof LivingEntity) {
            LivingEntity shooter = (LivingEntity)owner;
            SpellHelper.projectileImpact(shooter, (Entity)arrow, target, new SpellInfo(spell, this.spellId), new SpellHelper.ImpactContext().position(entityHitResult.m_82450_()));
        }
    }
}

