/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.mixin.client.control;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.spell_engine.api.effect.EntityActionsAllowed;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.client.SpellEngineClient;
import net.spell_engine.client.input.SpellHotbar;
import net.spell_engine.internals.casting.SpellCasterClient;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MultiPlayerGameMode.class})
public class ClientPlayerInteractionManagerMixin {
    @Shadow
    @Final
    private Minecraft f_105189_;

    @Inject(method={"interactItem"}, at={@At(value="HEAD")}, cancellable=true)
    public void interactItem_HEAD_LockHotbar(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        if (player instanceof LocalPlayer) {
            SpellCasterClient caster;
            SpellHotbar.Handle handled;
            LocalPlayer clientPlayer = (LocalPlayer)player;
            if (!SpellEngineClient.config.useKeyHighPriority && (handled = SpellHotbar.INSTANCE.handle(clientPlayer, SpellHotbar.INSTANCE.structuredSlots.onUseKey(), this.f_105189_.f_91066_)) != null && handled.spell().spell().mode != Spell.Mode.ITEM_USE) {
                cir.setReturnValue((Object)InteractionResult.FAIL);
                cir.cancel();
            }
            if ((caster = (SpellCasterClient)clientPlayer).isCastingSpell()) {
                cir.setReturnValue((Object)InteractionResult.FAIL);
                cir.cancel();
            }
        }
        if (EntityActionsAllowed.isImpaired((LivingEntity)player, EntityActionsAllowed.Player.ITEM_USE, true)) {
            cir.setReturnValue((Object)InteractionResult.FAIL);
            cir.cancel();
        }
    }
}

