/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.mixin.entity;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.spell_engine.utils.ItemCooldownManagerExtension;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemCooldowns.class})
public class ItemCooldownManagerMixin
implements ItemCooldownManagerExtension {
    @Unique
    private final Map<Item, Integer> durations = Maps.newHashMap();

    @Override
    public int SE_getLastCooldownDuration(Item item) {
        return this.durations.getOrDefault(item, 0);
    }

    @Inject(method={"set"}, at={@At(value="HEAD")})
    private void set_HEAD(Item item, int duration, CallbackInfo ci) {
        this.durations.put(item, duration);
    }

    @Inject(method={"remove"}, at={@At(value="RETURN")})
    private void remove_RETURN(Item item, CallbackInfo ci) {
        this.durations.remove(item);
    }
}

