/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.network;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.spell_engine.api.spell.ParticleBatch;
import net.spell_engine.config.ServerConfig;
import net.spell_engine.internals.casting.SpellCast;

public class Packets {

    public static class ConfigSync {
        public static ResourceLocation ID = new ResourceLocation("spell_engine", "config_sync");

        public static FriendlyByteBuf write(ServerConfig config) {
            Gson gson = new Gson();
            String json = gson.toJson((Object)config);
            FriendlyByteBuf buffer = PacketByteBufs.create();
            buffer.m_130070_(json);
            return buffer;
        }

        public static ServerConfig read(FriendlyByteBuf buffer) {
            Gson gson = new Gson();
            String json = buffer.m_130277_();
            ServerConfig config = (ServerConfig)gson.fromJson(json, ServerConfig.class);
            return config;
        }
    }

    public static class SpellRegistrySync {
        public static ResourceLocation ID = new ResourceLocation("spell_engine", "spell_registry_sync");
    }

    public record ParticleBatches(SourceType sourceType, List<Spawn> spawns) {
        public static ResourceLocation ID = new ResourceLocation("spell_engine", "particle_effects");

        public FriendlyByteBuf write(float countMultiplier) {
            FriendlyByteBuf buffer = PacketByteBufs.create();
            buffer.writeInt(this.sourceType.ordinal());
            buffer.writeInt(this.spawns.size());
            for (Spawn spawn : this.spawns) {
                buffer.writeInt(spawn.sourceEntityId);
                buffer.writeFloat(spawn.yaw);
                buffer.writeFloat(spawn.pitch);
                buffer.writeDouble(spawn.sourceLocation.f_82479_);
                buffer.writeDouble(spawn.sourceLocation.f_82480_);
                buffer.writeDouble(spawn.sourceLocation.f_82481_);
                ParticleBatches.write(spawn.batch, buffer, countMultiplier);
            }
            return buffer;
        }

        private static void write(ParticleBatch batch, FriendlyByteBuf buffer, float countMultiplier) {
            buffer.m_130070_(batch.particle_id);
            buffer.writeInt(batch.shape.ordinal());
            buffer.writeInt(batch.origin.ordinal());
            buffer.writeInt(batch.rotation != null ? batch.rotation.ordinal() : -1);
            buffer.writeFloat(batch.roll);
            buffer.writeFloat(batch.roll_offset);
            buffer.writeFloat(batch.count * countMultiplier);
            buffer.writeFloat(batch.min_speed);
            buffer.writeFloat(batch.max_speed);
            buffer.writeFloat(batch.angle);
            buffer.writeFloat(batch.extent);
            buffer.writeFloat(batch.pre_spawn_travel);
            buffer.writeBoolean(batch.invert);
        }

        private static ParticleBatch readBatch(FriendlyByteBuf buffer) {
            return new ParticleBatch(buffer.m_130277_(), ParticleBatch.Shape.values()[buffer.readInt()], ParticleBatch.Origin.values()[buffer.readInt()], ParticleBatch.Rotation.from(buffer.readInt()), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readBoolean());
        }

        public static ParticleBatches read(FriendlyByteBuf buffer) {
            SourceType sourceType = SourceType.values()[buffer.readInt()];
            int spawnCount = buffer.readInt();
            ArrayList<Spawn> spawns = new ArrayList<Spawn>();
            for (int i = 0; i < spawnCount; ++i) {
                spawns.add(new Spawn(buffer.readInt(), buffer.readFloat(), buffer.readFloat(), new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()), ParticleBatches.readBatch(buffer)));
            }
            return new ParticleBatches(sourceType, spawns);
        }

        public static enum SourceType {
            ENTITY,
            COORDINATE;

        }

        public record Spawn(int sourceEntityId, float yaw, float pitch, Vec3 sourceLocation, ParticleBatch batch) {
        }
    }

    public record SpellAnimation(int playerId, SpellCast.Animation type, String name, float speed) {
        public static ResourceLocation ID = new ResourceLocation("spell_engine", "spell_animation");

        public FriendlyByteBuf write() {
            FriendlyByteBuf buffer = PacketByteBufs.create();
            buffer.writeInt(this.playerId);
            buffer.writeInt(this.type.ordinal());
            buffer.m_130070_(this.name);
            buffer.writeFloat(this.speed);
            return buffer;
        }

        public static SpellAnimation read(FriendlyByteBuf buffer) {
            int playerId = buffer.readInt();
            SpellCast.Animation type = SpellCast.Animation.values()[buffer.readInt()];
            String name = buffer.m_130277_();
            float speed = buffer.readFloat();
            return new SpellAnimation(playerId, type, name, speed);
        }
    }

    public record SpellCooldown(ResourceLocation spellId, int duration) {
        public static ResourceLocation ID = new ResourceLocation("spell_engine", "spell_cooldown");

        public FriendlyByteBuf write() {
            FriendlyByteBuf buffer = PacketByteBufs.create();
            buffer.m_130070_(this.spellId.toString());
            buffer.writeInt(this.duration);
            return buffer;
        }

        public static SpellCooldown read(FriendlyByteBuf buffer) {
            ResourceLocation spellId = new ResourceLocation(buffer.m_130277_());
            int duration = buffer.readInt();
            return new SpellCooldown(spellId, duration);
        }
    }

    public record SpellRequest(SpellCast.Action action, ResourceLocation spellId, float progress, int[] targets) {
        public static ResourceLocation ID = new ResourceLocation("spell_engine", "release_request");

        public FriendlyByteBuf write() {
            FriendlyByteBuf buffer = PacketByteBufs.create();
            buffer.m_130068_((Enum)this.action);
            buffer.m_130070_(this.spellId.toString());
            buffer.writeFloat(this.progress);
            buffer.m_130089_(this.targets);
            return buffer;
        }

        public static SpellRequest read(FriendlyByteBuf buffer) {
            SpellCast.Action action = (SpellCast.Action)buffer.m_130066_(SpellCast.Action.class);
            ResourceLocation spellId = new ResourceLocation(buffer.m_130277_());
            float progress = buffer.readFloat();
            int[] targets = buffer.m_130100_();
            return new SpellRequest(action, spellId, progress, targets);
        }
    }

    public record SpellCastSync(ResourceLocation spellId, float speed, int length) {
        public static ResourceLocation ID = new ResourceLocation("spell_engine", "cast_sync");

        public FriendlyByteBuf write() {
            FriendlyByteBuf buffer = PacketByteBufs.create();
            if (this.spellId == null) {
                buffer.m_130070_("");
            } else {
                buffer.m_130070_(this.spellId.toString());
            }
            buffer.writeFloat(this.speed);
            buffer.writeInt(this.length);
            return buffer;
        }

        public static SpellCastSync read(FriendlyByteBuf buffer) {
            String string = buffer.m_130277_();
            ResourceLocation spellId = null;
            if (!string.isEmpty()) {
                spellId = new ResourceLocation(string);
            }
            float speed = buffer.readFloat();
            int length = buffer.readInt();
            return new SpellCastSync(spellId, speed, length);
        }
    }
}

