/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.network;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.internals.SpellCastSyncHelper;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.SpellRegistry;
import net.spell_engine.network.Packets;

public class ServerNetwork {
    private static FriendlyByteBuf configSerialized = PacketByteBufs.create();

    public static void initializeHandlers() {
        configSerialized = Packets.ConfigSync.write(SpellEngineMod.config);
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            sender.sendPacket(Packets.SpellRegistrySync.ID, SpellRegistry.encoded);
            sender.sendPacket(Packets.ConfigSync.ID, configSerialized);
        });
        ServerPlayNetworking.registerGlobalReceiver((ResourceLocation)Packets.SpellCastSync.ID, (server, player, handler, buf, responseSender) -> {
            ServerLevel world = (ServerLevel)Iterables.tryFind((Iterable)server.m_129785_(), element -> element == player.m_9236_()).orNull();
            if (world == null || world.f_46443_) {
                return;
            }
            Packets.SpellCastSync packet = Packets.SpellCastSync.read(buf);
            world.m_7654_().m_201446_(() -> {
                if (packet.spellId() == null) {
                    SpellCastSyncHelper.clearCasting((Player)player);
                } else {
                    SpellHelper.startCasting((Player)player, packet.spellId(), packet.speed(), packet.length());
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((ResourceLocation)Packets.SpellRequest.ID, (server, player, handler, buf, responseSender) -> {
            ServerLevel world = (ServerLevel)Iterables.tryFind((Iterable)server.m_129785_(), element -> element == player.m_9236_()).orNull();
            if (world == null || world.f_46443_) {
                return;
            }
            Packets.SpellRequest packet = Packets.SpellRequest.read(buf);
            world.m_7654_().m_201446_(() -> {
                ArrayList<Entity> targets = new ArrayList<Entity>();
                for (int targetId : packet.targets()) {
                    Entity entity = world.m_143317_(targetId);
                    if (entity != null) {
                        targets.add(entity);
                        continue;
                    }
                    System.err.println("Spell Engine: Trying to perform spell " + packet.spellId().toString() + " Entity not found: " + targetId);
                }
                SpellHelper.performSpell((Level)world, (Player)player, packet.spellId(), targets, packet.action(), packet.progress());
            });
        });
    }
}

