/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.particle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.spell_engine.api.spell.ParticleBatch;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.network.Packets;
import net.spell_engine.utils.VectorHelper;

public class ParticleHelper {
    private static Random rng = new Random();

    public static void sendBatches(Entity trackedEntity, ParticleBatch[] batches) {
        ParticleHelper.sendBatches(trackedEntity, batches, true);
    }

    public static void sendBatches(Entity trackedEntity, ParticleBatch[] batches, boolean includeSourceEntity) {
        ParticleHelper.sendBatches(trackedEntity, batches, 1.0f, PlayerLookup.tracking((Entity)trackedEntity), includeSourceEntity);
    }

    public static void sendBatches(Entity trackedEntity, ParticleBatch[] batches, float countMultiplier, Collection<ServerPlayer> trackers) {
        ParticleHelper.sendBatches(trackedEntity, batches, countMultiplier, trackers, true);
    }

    public static void sendBatches(Entity trackedEntity, ParticleBatch[] batches, float countMultiplier, Collection<ServerPlayer> trackers, boolean includeSourceEntity) {
        if (batches == null || batches.length == 0) {
            return;
        }
        int sourceEntityId = trackedEntity.m_19879_();
        Packets.ParticleBatches.SourceType sourceType = Packets.ParticleBatches.SourceType.COORDINATE;
        ArrayList<Packets.ParticleBatches.Spawn> spawns = new ArrayList<Packets.ParticleBatches.Spawn>();
        for (ParticleBatch batch : batches) {
            Vec3 sourceLocation = Vec3.f_82478_;
            switch (sourceType) {
                case ENTITY: {
                    break;
                }
                case COORDINATE: {
                    sourceLocation = ParticleHelper.origin(trackedEntity, batch.origin);
                }
            }
            spawns.add(new Packets.ParticleBatches.Spawn(includeSourceEntity ? sourceEntityId : 0, trackedEntity.m_146908_(), trackedEntity.m_146909_(), sourceLocation, batch));
        }
        FriendlyByteBuf packet = new Packets.ParticleBatches(sourceType, spawns).write(countMultiplier);
        if (trackedEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer2 = (ServerPlayer)trackedEntity;
            ParticleHelper.sendWrittenBatchesToPlayer(serverPlayer2, packet);
        }
        trackers.forEach(serverPlayer -> ParticleHelper.sendWrittenBatchesToPlayer(serverPlayer, packet));
    }

    private static void sendWrittenBatchesToPlayer(ServerPlayer serverPlayer, FriendlyByteBuf packet) {
        try {
            if (ServerPlayNetworking.canSend((ServerPlayer)serverPlayer, (ResourceLocation)Packets.ParticleBatches.ID)) {
                ServerPlayNetworking.send((ServerPlayer)serverPlayer, (ResourceLocation)Packets.ParticleBatches.ID, (FriendlyByteBuf)packet);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void play(Level world, Entity source, ParticleBatch[] batches) {
        if (batches == null) {
            return;
        }
        for (ParticleBatch batch : batches) {
            ParticleHelper.play(world, source, 0.0f, 0.0f, batch);
        }
    }

    public static void play(Level world, Entity source, ParticleBatch batch) {
        ParticleHelper.play(world, source, 0.0f, 0.0f, batch);
    }

    public static void play(Level world, Entity entity, float yaw, float pitch, ParticleBatch batch) {
        ParticleHelper.play(world, entity.f_19797_, ParticleHelper.origin(entity, batch.origin), entity.m_20205_(), yaw, pitch, batch);
    }

    public static void play(Level world, long time, Vec3 origin, float width, float yaw, float pitch, ParticleBatch batch) {
        try {
            ResourceLocation id = new ResourceLocation(batch.particle_id);
            ParticleOptions particle = (ParticleOptions)BuiltInRegistries.f_257034_.m_7745_(id);
            float count = batch.count;
            if (batch.count < 1.0f) {
                count = rng.nextFloat() < batch.count ? 1.0f : 0.0f;
            }
            int i = 0;
            while ((float)i < count) {
                Vec3 direction = ParticleHelper.direction(batch, time, yaw, pitch);
                Vec3 particleSpecificOrigin = origin.m_82549_(ParticleHelper.offset(width, batch.extent, batch.shape, direction.m_82541_(), batch.rotation, yaw, pitch));
                if (batch.pre_spawn_travel != 0.0f) {
                    particleSpecificOrigin = particleSpecificOrigin.m_82549_(direction.m_82490_((double)batch.pre_spawn_travel));
                }
                if (batch.invert) {
                    direction = direction.m_82548_();
                }
                world.m_6493_(particle, true, particleSpecificOrigin.f_82479_, particleSpecificOrigin.f_82480_, particleSpecificOrigin.f_82481_, direction.f_82479_, direction.f_82480_, direction.f_82481_);
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println("Failed to play particle batch - " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static List<SpawnInstruction> convertToInstructions(Level world, Packets.ParticleBatches packet) {
        ArrayList<SpawnInstruction> instructions = new ArrayList<SpawnInstruction>();
        Packets.ParticleBatches.SourceType sourceType = packet.sourceType();
        for (Packets.ParticleBatches.Spawn spawn : packet.spawns()) {
            float yaw = spawn.yaw();
            float pitch = spawn.pitch();
            ParticleBatch batch = spawn.batch();
            Vec3 origin = Vec3.f_82478_;
            float width = 0.5f;
            switch (sourceType) {
                case ENTITY: {
                    Entity entity = world.m_6815_(spawn.sourceEntityId());
                    origin = ParticleHelper.origin(entity, batch.origin);
                    break;
                }
                case COORDINATE: {
                    origin = spawn.sourceLocation();
                }
            }
            ResourceLocation id = new ResourceLocation(batch.particle_id);
            ParticleOptions particle = (ParticleOptions)BuiltInRegistries.f_257034_.m_7745_(id);
            float count = batch.count;
            if (batch.count < 1.0f) {
                count = rng.nextFloat() < batch.count ? 1.0f : 0.0f;
            }
            int i = 0;
            while ((float)i < count) {
                Vec3 direction = ParticleHelper.direction(batch, world.m_46467_(), yaw, pitch);
                Vec3 particleSpecificOrigin = origin.m_82549_(ParticleHelper.offset(width, batch.extent, batch.shape, direction.m_82541_(), batch.rotation, yaw, pitch));
                if (batch.pre_spawn_travel != 0.0f) {
                    particleSpecificOrigin = particleSpecificOrigin.m_82549_(direction.m_82490_((double)batch.pre_spawn_travel));
                }
                if (batch.invert) {
                    direction = direction.m_82548_();
                }
                instructions.add(new SpawnInstruction(particle, particleSpecificOrigin.f_82479_, particleSpecificOrigin.f_82480_, particleSpecificOrigin.f_82481_, direction.f_82479_, direction.f_82480_, direction.f_82481_));
                ++i;
            }
        }
        return instructions;
    }

    private static Vec3 origin(Entity entity, ParticleBatch.Origin origin) {
        switch (origin) {
            case FEET: {
                return entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() * 0.1f), 0.0);
            }
            case CENTER: {
                return entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() * 0.5f), 0.0);
            }
            case LAUNCH_POINT: {
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    return SpellHelper.launchPoint(livingEntity);
                }
                return entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() * 0.5f), 0.0);
            }
        }
        return entity.m_20182_();
    }

    private static Vec3 offset(float width, float extent, ParticleBatch.Shape shape, Vec3 direction, ParticleBatch.Rotation rotation, float yaw, float pitch) {
        Vec3 offset = Vec3.f_82478_;
        if (extent >= 1000.0f) {
            width = 0.0f;
            extent -= 1000.0f;
        }
        switch (shape) {
            case CIRCLE: 
            case CONE: 
            case SPHERE: {
                if (extent > 0.0f) {
                    offset = direction.m_82490_((double)extent);
                }
                return offset;
            }
            case PIPE: {
                float size = width + extent;
                float angle = (float)Math.toRadians(rng.nextFloat() * 360.0f);
                offset = new Vec3((double)size, 0.0, 0.0).m_82524_(angle);
                break;
            }
            case PILLAR: {
                float size = width * 0.5f + extent;
                float x = ParticleHelper.randomInRange(0.0f, size);
                float angle = (float)Math.toRadians(rng.nextFloat() * 360.0f);
                offset = new Vec3((double)x, 0.0, 0.0).m_82524_(angle);
            }
        }
        if (rotation != null) {
            switch (rotation) {
                case LOOK: {
                    offset = offset.m_82496_((float)Math.toRadians(-1.0f * (pitch + 90.0f))).m_82524_((float)Math.toRadians(-yaw));
                }
            }
        }
        return offset;
    }

    private static Vec3 direction(ParticleBatch batch, long time, float yaw, float pitch) {
        Vec3 direction = Vec3.f_82478_;
        float rotateAroundX = 0.0f;
        float rotateAroundY = 0.0f;
        switch (batch.shape) {
            case LINE: {
                direction = new Vec3(0.0, 0.0, (double)ParticleHelper.randomInRange(batch.min_speed, batch.max_speed));
                pitch = -pitch;
                break;
            }
            case CONE: {
                direction = new Vec3(0.0, (double)ParticleHelper.randomInRange(batch.min_speed, batch.max_speed), 0.0);
                rotateAroundX += rng.nextFloat() * batch.angle - batch.angle * 0.5f;
                rotateAroundY += rng.nextFloat() * batch.angle - batch.angle * 0.5f;
                break;
            }
            case CIRCLE: {
                direction = new Vec3(0.0, 0.0, (double)ParticleHelper.randomInRange(batch.min_speed, batch.max_speed)).m_82524_((float)Math.toRadians(rng.nextFloat() * 360.0f));
                break;
            }
            case PIPE: 
            case PILLAR: {
                direction = new Vec3(0.0, (double)ParticleHelper.randomInRange(batch.min_speed, batch.max_speed), 0.0);
                break;
            }
            case SPHERE: {
                direction = new Vec3((double)ParticleHelper.randomInRange(batch.min_speed, batch.max_speed), 0.0, 0.0).m_82535_((float)Math.toRadians(rng.nextFloat() * 360.0f)).m_82524_((float)Math.toRadians(rng.nextFloat() * 360.0f));
            }
        }
        if (batch.rotation != null) {
            switch (batch.rotation) {
                case LOOK: {
                    float pRot = -pitch;
                    float yRot = yaw * -1.0f;
                    direction = direction.m_82496_((float)Math.toRadians(pRot - 90.0f + rotateAroundX)).m_82524_((float)Math.toRadians(yRot + rotateAroundY));
                    if (!(batch.roll > 0.0f)) break;
                    Vec3 axis = VectorHelper.axisFromRotation(yRot, pRot).m_82548_();
                    float diff = (float)time * batch.roll % 360.0f + batch.roll_offset;
                    direction = VectorHelper.rotateAround(direction, axis, diff);
                }
            }
        } else {
            direction = direction.m_82496_((float)Math.toRadians(rotateAroundX)).m_82524_((float)Math.toRadians(rotateAroundY));
            if (batch.roll > 0.0f) {
                float diff = (float)time * batch.roll % 360.0f + batch.roll_offset;
                direction = direction.m_82524_((float)Math.toRadians(diff));
            }
        }
        return direction;
    }

    private static float randomInRange(float min, float max) {
        float range = max - min;
        return min + range * rng.nextFloat();
    }

    private static float randomSignedInRange(float min, float max) {
        float rand = rng.nextFloat();
        float range = max - min;
        float sign = rand > 0.5f ? 1.0f : -1.0f;
        float base = sign * min;
        float varied = sign * range * rand;
        return base + varied;
    }

    public record SpawnInstruction(ParticleOptions particle, double positionX, double positionY, double positionZ, double velocityX, double velocityY, double velocityZ) {
        public void perform(Level world) {
            try {
                world.m_6493_(this.particle, true, this.positionX, this.positionY, this.positionZ, this.velocityX, this.velocityY, this.velocityZ);
            }
            catch (Exception e) {
                System.err.println("Failed to perform particle SpawnInstruction");
            }
        }
    }
}

