/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.spellbinding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.api.item.trinket.SpellBookItem;
import net.spell_engine.api.item.trinket.SpellBooks;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.SpellContainer;
import net.spell_engine.api.spell.SpellPool;
import net.spell_engine.internals.SpellContainerHelper;
import net.spell_engine.internals.SpellRegistry;

public class SpellBinding {
    public static final ResourceLocation ADVANCEMENT_VISIT_ID = new ResourceLocation("spell_engine", "visit_spell_binding_table");
    public static final String name = "spell_binding";
    public static final ResourceLocation ID = new ResourceLocation("spell_engine", "spell_binding");
    private static final float LIBRARY_POWER_BASE = 10.0f;
    private static final float LIBRARY_POWER_MULTIPLIER = 1.5f;
    private static final int LIBRARY_POWER_CAP = 18;
    public static final int BOOK_OFFSET = 1;

    public static OfferResult offersFor(ItemStack itemStack, int libraryPower) {
        if (itemStack.m_41720_() == Items.f_42517_) {
            List<SpellBookItem> books = SpellBooks.sorted();
            ArrayList<Offer> offers = new ArrayList<Offer>();
            if (SpellEngineMod.config.spell_book_creation_enabled) {
                for (int i = 0; i < books.size(); ++i) {
                    offers.add(new Offer(i + 1, SpellEngineMod.config.spell_book_creation_cost, SpellEngineMod.config.spell_book_creation_requirement, true));
                }
            }
            return new OfferResult(Mode.BOOK, offers);
        }
        SpellContainer container = SpellContainerHelper.containerFromItemStack(itemStack);
        SpellPool pool = SpellContainerHelper.getPool(container);
        if (container == null || pool == null || pool.spellIds().isEmpty()) {
            return new OfferResult(Mode.SPELL, List.of());
        }
        HashMap<ResourceLocation, Spell> spells = new HashMap<ResourceLocation, Spell>();
        for (ResourceLocation id : pool.spellIds()) {
            spells.put(id, SpellRegistry.getSpell(id));
        }
        return new OfferResult(Mode.SPELL, spells.entrySet().stream().filter(entry -> ((Spell)entry.getValue()).learn != null && ((Spell)entry.getValue()).learn.tier > 0).sorted(SpellContainerHelper.spellSorter).map(entry -> {
            int cost = ((Spell)entry.getValue()).learn.tier * ((Spell)entry.getValue()).learn.level_cost_per_tier;
            int levelRequirement = ((Spell)entry.getValue()).learn.tier * ((Spell)entry.getValue()).learn.level_requirement_per_tier;
            return new Offer(SpellRegistry.rawSpellId((ResourceLocation)entry.getKey()), cost, levelRequirement, libraryPower == 18 || 10.0f + (float)libraryPower * 1.5f >= (float)levelRequirement);
        }).collect(Collectors.toList()));
    }

    public record Offer(int id, int cost, int levelRequirement, boolean isPowered) {
    }

    public record OfferResult(Mode mode, List<Offer> offers) {
    }

    public static enum Mode {
        SPELL,
        BOOK;

    }

    public static class State {
        public ApplyState state;
        public Requirements requirements;

        public State(ApplyState state, Requirements requirements) {
            this.state = state;
            this.requirements = requirements;
        }

        public static State of(int spellId, ItemStack itemStack, int levelCost, int requiredLevel, int lapisCost) {
            Optional<ResourceLocation> validId = SpellRegistry.fromRawSpellId(spellId);
            if (validId.isEmpty()) {
                return new State(ApplyState.INVALID, null);
            }
            return State.of(validId.get(), itemStack, levelCost, requiredLevel, lapisCost);
        }

        public static State of(ResourceLocation spellId, ItemStack itemStack, int requiredLevel, int levelCost, int lapisCost) {
            SpellContainer container = SpellContainerHelper.containerFromItemStack(itemStack);
            Requirements requirements = new Requirements(lapisCost * SpellEngineMod.config.spell_binding_lapis_cost_multiplier, levelCost * SpellEngineMod.config.spell_binding_level_cost_multiplier, requiredLevel);
            if (container == null) {
                return new State(ApplyState.INVALID, requirements);
            }
            if (container.spell_ids.contains(spellId.toString())) {
                return new State(ApplyState.ALREADY_APPLIED, requirements);
            }
            if (container.max_spell_count > 0 && container.spell_ids.size() >= container.max_spell_count) {
                return new State(ApplyState.NO_MORE_SLOT, requirements);
            }
            return new State(ApplyState.APPLICABLE, requirements);
        }

        public boolean readyToApply(Player player, int lapisCount) {
            return this.state == ApplyState.APPLICABLE && this.requirements != null && this.requirements.satisfiedFor(player, lapisCount);
        }

        public static State forBook(int cost, int requiredLevel) {
            Requirements requirements = new Requirements(0, cost, requiredLevel);
            return new State(ApplyState.APPLICABLE, requirements);
        }

        public static enum ApplyState {
            ALREADY_APPLIED,
            NO_MORE_SLOT,
            APPLICABLE,
            INVALID;

        }

        public record Requirements(int lapisCost, int levelCost, int requiredLevel) {
            public boolean satisfiedFor(Player player, int lapisCount) {
                return player.m_7500_() || this.metRequiredLevel(player) && this.hasEnoughLapis(lapisCount) && this.hasEnoughLevelsToSpend(player);
            }

            public boolean metRequiredLevel(Player player) {
                return player.f_36078_ >= this.requiredLevel;
            }

            public boolean hasEnoughLapis(int lapisCount) {
                return lapisCount >= this.lapisCost;
            }

            public boolean hasEnoughLevelsToSpend(Player player) {
                return player.f_36078_ >= this.levelCost;
            }
        }
    }
}

