/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.spellbinding;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class SpellBookCreationCriteria
extends SimpleCriterionTrigger<Condition> {
    public static final ResourceLocation ID = new ResourceLocation("spell_engine", "spell_book_creation");
    public static final SpellBookCreationCriteria INSTANCE = new SpellBookCreationCriteria();

    protected Condition conditionsFromJson(JsonObject obj, ContextAwarePredicate playerPredicate, DeserializationContext predicateDeserializer) {
        Condition condition = new Condition();
        JsonElement element = obj.get("spell_pool");
        if (element != null) {
            condition.spellPool = new ResourceLocation(element.getAsString());
        }
        return condition;
    }

    public ResourceLocation m_7295_() {
        return ID;
    }

    public void trigger(ServerPlayer player, ResourceLocation spellPoolId) {
        this.m_66234_(player, condition -> condition.test(spellPoolId));
    }

    public static class Condition
    extends AbstractCriterionTriggerInstance {
        ResourceLocation spellPool = null;

        public Condition() {
            super(ID, ContextAwarePredicate.f_285567_);
        }

        public boolean test(ResourceLocation usedSpellPool) {
            if (this.spellPool != null) {
                return this.spellPool.equals((Object)usedSpellPool);
            }
            return true;
        }

        public JsonObject m_7683_(SerializationContext predicateSerializer) {
            JsonObject jsonObject = super.m_7683_(predicateSerializer);
            if (this.spellPool != null) {
                jsonObject.add("spell_pool", (JsonElement)new JsonPrimitive(this.spellPool.toString()));
            }
            return jsonObject;
        }
    }
}

