/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.utils;

import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.spell_engine.api.spell.Sound;
import net.spell_engine.spellbinding.SpellBindingScreenHandler;

public class SoundHelper {
    public static List<String> soundKeys = List.of("generic_arcane_casting", "generic_arcane_release", "generic_fire_casting", "generic_fire_release", "generic_frost_casting", "generic_frost_release", "generic_frost_impact", "generic_healing_casting", "generic_healing_release", "generic_healing_impact_1", "generic_healing_impact_2", "generic_lightning_casting", "generic_lightning_release", "generic_soul_casting", "generic_soul_release", "generic_wind_charging");
    public static Map<String, Float> soundDistances = Map.of();

    public static void registerSounds() {
        for (String soundKey : soundKeys) {
            ResourceLocation soundId = new ResourceLocation("spell_engine", soundKey);
            Float customTravelDistance = soundDistances.get(soundKey);
            SoundEvent soundEvent = customTravelDistance == null ? SoundEvent.m_262824_((ResourceLocation)soundId) : SoundEvent.m_262856_((ResourceLocation)soundId, (float)customTravelDistance.floatValue());
            Registry.m_122965_((Registry)BuiltInRegistries.f_256894_, (ResourceLocation)soundId, (Object)soundEvent);
        }
        Registry.m_122965_((Registry)BuiltInRegistries.f_256894_, (ResourceLocation)SpellBindingScreenHandler.soundId, (Object)SpellBindingScreenHandler.soundEvent);
    }

    public static void playSound(Level world, Entity entity, Sound sound) {
        if (sound == null) {
            return;
        }
        try {
            SoundEvent soundEvent = (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(new ResourceLocation(sound.id()));
            SoundHelper.playSoundEvent(world, entity, soundEvent, sound.volume(), sound.randomizedPitch());
        }
        catch (Exception e) {
            System.err.println("Failed to play sound: " + sound.id());
            e.printStackTrace();
        }
    }

    public static void playSoundEvent(Level world, Entity entity, SoundEvent soundEvent) {
        SoundHelper.playSoundEvent(world, entity, soundEvent, 1.0f, 1.0f);
    }

    public static void playSoundEvent(Level world, Entity entity, SoundEvent soundEvent, float volume, float pitch) {
        world.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), soundEvent, SoundSource.PLAYERS, volume, pitch);
    }
}

