/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.utils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import net.spell_engine.SpellEngineMod;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.compat.MultipartEntityCompat;
import net.spell_engine.config.ServerConfig;
import net.spell_engine.internals.Beam;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.casting.SpellCasterClient;
import net.spell_engine.utils.VectorHelper;
import org.jetbrains.annotations.Nullable;

public class TargetHelper {
    private static final boolean[][] TABLE_OF_ULTIMATE_JUSTICE = new boolean[][]{{false, true, true, true, true}, {false, false, false, true, true}, {true, true, true, false, true}, {true, true, false, false, true}};

    public static Relation getRelation(LivingEntity attacker, Entity target) {
        OwnableEntity tameable;
        LivingEntity owner;
        if (attacker == target) {
            return Relation.FRIENDLY;
        }
        target = MultipartEntityCompat.coalesce(target);
        Team casterTeam = attacker.m_5647_();
        Team targetTeam = target.m_5647_();
        if (target instanceof OwnableEntity && (owner = (tameable = (OwnableEntity)target).m_269323_()) != null) {
            return TargetHelper.getRelation(attacker, (Entity)owner);
        }
        if (target instanceof HangingEntity) {
            return Relation.NEUTRAL;
        }
        ServerConfig config = SpellEngineMod.config;
        if (casterTeam == null || targetTeam == null) {
            ResourceLocation id = BuiltInRegistries.f_256780_.m_7981_((Object)target.m_6095_());
            Relation mappedRelation = config.player_relations.get(id.toString());
            if (mappedRelation != null) {
                return mappedRelation;
            }
            if (target instanceof AgeableMob) {
                return Relation.coalesce(config.player_relation_to_passives, Relation.HOSTILE);
            }
            if (target instanceof Monster) {
                return Relation.coalesce(config.player_relation_to_hostiles, Relation.HOSTILE);
            }
            return Relation.coalesce(config.player_relation_to_other, Relation.HOSTILE);
        }
        return attacker.m_7307_(target) ? Relation.FRIENDLY : Relation.HOSTILE;
    }

    public static boolean actionAllowed(TargetingMode targetingMode, Intent intent, LivingEntity attacker, Entity target) {
        Relation relation = TargetHelper.getRelation(attacker, target);
        int row = 0;
        if (intent == Intent.HELPFUL) {
            row += 2;
        }
        if (targetingMode == TargetingMode.AREA) {
            ++row;
        }
        int column = 0;
        switch (relation) {
            case FRIENDLY: {
                column = 0;
                break;
            }
            case SEMI_FRIENDLY: {
                column = 1;
                break;
            }
            case NEUTRAL: {
                column = 2;
                break;
            }
            case HOSTILE: {
                column = 3;
                break;
            }
            case MIXED: {
                column = 4;
            }
        }
        return TABLE_OF_ULTIMATE_JUSTICE[row][column];
    }

    public static boolean allowedToHurt(Entity e1, Entity e2) {
        Team abstractTeam = e1.m_5647_();
        Team abstractTeam2 = e2.m_5647_();
        if (abstractTeam == null) {
            return true;
        }
        return !abstractTeam.m_83536_(abstractTeam2) || abstractTeam.m_6260_();
    }

    public static Entity targetFromRaycast(Entity caster, float range, Predicate<Entity> predicate) {
        AABB searchAABB;
        Vec3 look;
        Vec3 end;
        Vec3 start = caster.m_146892_();
        EntityHitResult hitResult = ProjectileUtil.m_37287_((Entity)caster, (Vec3)start, (Vec3)(end = start.m_82549_(look = caster.m_20252_(1.0f).m_82541_().m_82490_((double)range))), (AABB)(searchAABB = caster.m_20191_().m_82377_((double)range, (double)range, (double)range)), target -> !target.m_5833_() && target.m_6087_() && predicate.test((Entity)target), (double)(range * range));
        if (hitResult != null && (hitResult.m_82450_() == null || TargetHelper.raycastObstacleFree(caster, start, hitResult.m_82450_()))) {
            return hitResult.m_82443_();
        }
        return null;
    }

    public static List<Entity> targetsFromRaycast(Entity caster, float range, Predicate<Entity> predicate) {
        Vec3 start = caster.m_146892_();
        Vec3 look = caster.m_20252_(1.0f).m_82541_().m_82490_((double)range);
        Vec3 end = start.m_82549_(look);
        AABB searchAABB = caster.m_20191_().m_82377_((double)range, (double)range, (double)range);
        List<EntityHit> entitiesHit = TargetHelper.raycastMultiple(caster, start, end, searchAABB, target -> !target.m_5833_() && target.m_6087_() && predicate.test((Entity)target), range * range);
        return entitiesHit.stream().filter(hit -> hit.position() == null || TargetHelper.raycastObstacleFree(caster, start, hit.position())).sorted(new Comparator<EntityHit>(){

            @Override
            public int compare(EntityHit hit1, EntityHit hit2) {
                if (hit1.squaredDistanceToSource == hit2.squaredDistanceToSource) {
                    return 0;
                }
                return hit1.squaredDistanceToSource < hit2.squaredDistanceToSource ? -1 : 1;
            }
        }).map(hit -> hit.entity).toList();
    }

    @Nullable
    private static List<EntityHit> raycastMultiple(Entity sourceEntity, Vec3 min, Vec3 max, AABB searchBox, Predicate<Entity> predicate, double squaredDistance) {
        Level world = sourceEntity.m_9236_();
        double e = squaredDistance;
        ArrayList<EntityHit> entities = new ArrayList<EntityHit>();
        Vec3 vec3d = null;
        for (Entity entity : world.m_6249_(sourceEntity, searchBox, predicate)) {
            Vec3 hitPosition;
            double f;
            AABB box2 = entity.m_20191_().m_82400_((double)entity.m_6143_());
            Optional raycastResult = box2.m_82371_(min, max);
            if (box2.m_82390_(min)) {
                if (!(e >= 0.0)) continue;
                vec3d = raycastResult.orElse(min);
                entities.add(new EntityHit(entity, vec3d, 0.0));
                e = 0.0;
                continue;
            }
            if (!raycastResult.isPresent() || !((f = min.m_82557_(hitPosition = (Vec3)raycastResult.get())) < e) && e != 0.0) continue;
            if (entity.m_20201_() == sourceEntity.m_20201_()) {
                if (e != 0.0) continue;
                vec3d = hitPosition;
                entities.add(new EntityHit(entity, vec3d, entity.m_20280_(sourceEntity)));
                continue;
            }
            vec3d = hitPosition;
            entities.add(new EntityHit(entity, vec3d, entity.m_20280_(sourceEntity)));
        }
        return entities;
    }

    public static List<Entity> targetsFromArea(Entity caster, float range, Spell.Release.Target.Area area, @Nullable Predicate<Entity> predicate) {
        Vec3 origin = caster.m_146892_();
        return TargetHelper.targetsFromArea(caster, origin, range, area, predicate);
    }

    public static List<Entity> targetsFromArea(Entity centerEntity, Vec3 origin, float range, Spell.Release.Target.Area area, @Nullable Predicate<Entity> predicate) {
        float horizontal = range * area.horizontal_range_multiplier;
        float vertical = range * area.vertical_range_multiplier;
        AABB box = centerEntity.m_20191_().m_82377_((double)(horizontal + 0.5f), (double)(vertical + 0.5f), (double)(horizontal + 0.5f));
        float squaredDistance = range * range;
        Vec3 look = centerEntity.m_20154_();
        float angle = area.angle_degrees / 2.0f;
        return centerEntity.m_9236_().m_6249_(centerEntity, box, target -> {
            Vec3 targetCenter = target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0);
            Vec3 distanceVector = VectorHelper.distanceVector(origin, target.m_20191_());
            return !target.m_5833_() && target.m_6087_() && (predicate == null || predicate.test((Entity)target)) && (range > 1.0f ? targetCenter.m_82557_(origin) <= (double)squaredDistance : distanceVector.m_82553_() <= (double)range) && (angle <= 0.0f || VectorHelper.angleBetween(look, targetCenter.m_82546_(origin)) <= (double)angle || VectorHelper.angleBetween(look, distanceVector) <= (double)angle) && (range < 1.0f || TargetHelper.raycastObstacleFree(centerEntity, origin, targetCenter) || TargetHelper.raycastObstacleFree(centerEntity, origin, origin.m_82549_(distanceVector)));
        });
    }

    public static boolean isInLineOfSight(Entity attacker, Entity target) {
        Vec3 origin = attacker.m_146892_();
        Vec3 targetCenter = target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0);
        Vec3 distanceVector = VectorHelper.distanceVector(origin, target.m_20191_());
        return TargetHelper.raycastObstacleFree(attacker, origin, targetCenter) || TargetHelper.raycastObstacleFree(attacker, origin, origin.m_82549_(distanceVector));
    }

    private static boolean raycastObstacleFree(Entity entity, Vec3 start, Vec3 end) {
        BlockHitResult hit = entity.m_9236_().m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity));
        return hit.m_6662_() != HitResult.Type.BLOCK;
    }

    public static boolean isTargetedByPlayer(Entity entity, Player player) {
        if (entity.m_9236_().f_46443_ && player instanceof SpellCasterClient) {
            SpellCasterClient casterClient = (SpellCasterClient)player;
            List<Entity> targets = casterClient.getCurrentTargets();
            if (entity instanceof EnderDragon) {
                EnderDragon dragon = (EnderDragon)entity;
                for (EnderDragonPart part : dragon.m_31156_()) {
                    if (!targets.contains(part)) continue;
                    return true;
                }
                return false;
            }
            return targets.contains(entity);
        }
        return false;
    }

    public static Beam.Position castBeam(LivingEntity caster, Vec3 direction, float max) {
        Vec3 start = SpellHelper.launchPoint(caster);
        Vec3 end = start.m_82549_(direction.m_82490_((double)max));
        float length = max;
        boolean hitBlock = false;
        BlockHitResult hit = caster.m_9236_().m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)caster));
        if (hit.m_6662_() == HitResult.Type.BLOCK) {
            hitBlock = true;
            end = hit.m_82450_();
            length = (float)start.m_82554_(hit.m_82450_());
        }
        return new Beam.Position(start, end, length, hitBlock);
    }

    @Nullable
    public static Vec3 findSolidBlockBelow(LivingEntity entity, Vec3 position, Level world, float height) {
        BlockHitResult hit = world.m_45547_(new ClipContext(position, position.m_82520_(0.0, (double)height, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity));
        if (hit.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult blockHit = hit;
            return new Vec3(position.m_7096_(), (double)((float)blockHit.m_82425_().m_123342_() + 1.0f), position.m_7094_());
        }
        return null;
    }

    @Nullable
    public static Vec3 findTeleportDestination(LivingEntity entity, Vec3 look, float distance, int clearanceY) {
        Level world = entity.m_9236_();
        Vec3 start = entity.m_146892_();
        Vec3 end = start.m_82549_(look.m_82490_((double)distance));
        BlockHitResult hit = world.m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity));
        Vec3 hitPosition = null;
        if (hit.m_6662_() == HitResult.Type.MISS) {
            hitPosition = end;
        }
        if (hit.m_6662_() == HitResult.Type.BLOCK && hit.m_82425_() != null) {
            hitPosition = hit.m_82450_();
        }
        if (hitPosition != null) {
            Vec3 inverseLook = look.m_82490_(-1.0);
            Vec3 paddedHitPosition = hitPosition.m_82549_(inverseLook.m_82490_(0.5));
            double hitDistance = start.m_82554_(paddedHitPosition);
            float reverted = 0.0f;
            while ((double)reverted < hitDistance) {
                BlockPos blockPos = new BlockPos((int)paddedHitPosition.m_7096_(), (int)paddedHitPosition.m_7098_(), (int)paddedHitPosition.m_7094_());
                if (TargetHelper.isSafeWithClearance(world, blockPos, clearanceY)) {
                    return paddedHitPosition;
                }
                reverted += 1.0f;
                paddedHitPosition = paddedHitPosition.m_82549_(inverseLook);
            }
        }
        return null;
    }

    private static boolean isSafeWithClearance(Level world, BlockPos blockPos, int clearanceY) {
        if (TargetHelper.isSafeTeleportDestination(world, blockPos)) {
            boolean clearanceSafe = true;
            for (int i = 0; i < clearanceY; ++i) {
                BlockPos clearancePos = blockPos.m_6630_(i);
                if (TargetHelper.isSafeTeleportDestination(world, clearancePos)) continue;
                clearanceSafe = false;
                break;
            }
            return clearanceSafe;
        }
        return false;
    }

    private static boolean isSafeTeleportDestination(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return !state.m_280296_() && !state.m_60828_((BlockGetter)world, pos);
    }

    public static enum Relation {
        FRIENDLY,
        SEMI_FRIENDLY,
        NEUTRAL,
        HOSTILE,
        MIXED;


        public static Relation coalesce(Relation value, Relation fallback) {
            if (value != null) {
                return value;
            }
            return fallback;
        }
    }

    public static enum Intent {
        HELPFUL,
        HARMFUL;

    }

    public static enum TargetingMode {
        DIRECT,
        AREA;

    }

    private record EntityHit(Entity entity, Vec3 position, double squaredDistanceToSource) {
    }
}

