/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.compat;

import com.qendolin.betterclouds.compat.IrisCompat;
import com.qendolin.betterclouds.mixin.optional.ExtendedShaderAccessor;
import com.qendolin.betterclouds.mixin.optional.FallbackShaderAccessor;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.gl.framebuffer.GlFramebuffer;
import net.irisshaders.iris.pipeline.IrisRenderingPipeline;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.irisshaders.iris.pipeline.programs.ExtendedShader;
import net.irisshaders.iris.pipeline.programs.FallbackShader;
import net.irisshaders.iris.pipeline.programs.ShaderKey;
import net.minecraft.class_5944;

public class IrisCompatImpl
extends IrisCompat {
    private static final String INCOMPATIBLE_ERROR = "Incompatible Iris version for Better Clouds, please report this issue to Better Clouds. Details: ";

    @Override
    public boolean isShadersEnabled() {
        return Iris.getIrisConfig().areShadersEnabled() && Iris.getCurrentPack().isPresent();
    }

    @Override
    public boolean isFrustumCullingDisabled() {
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipelineNullable();
        if (pipeline == null) {
            return false;
        }
        return pipeline.shouldDisableFrustumCulling();
    }

    @Override
    public void bindFramebuffer() {
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipelineNullable();
        if (!(pipeline instanceof IrisRenderingPipeline)) {
            return;
        }
        IrisRenderingPipeline corePipeline = (IrisRenderingPipeline)pipeline;
        class_5944 program = corePipeline.getShaderMap().getShader(ShaderKey.CLOUDS);
        GlFramebuffer before = null;
        GlFramebuffer after = null;
        if (program instanceof ExtendedShader) {
            ExtendedShader extended = (ExtendedShader)program;
            ExtendedShaderAccessor access = (ExtendedShaderAccessor)extended;
            before = access.getWritingToBeforeTranslucent();
            after = access.getWritingToAfterTranslucent();
        } else if (program instanceof FallbackShader) {
            FallbackShader fallback = (FallbackShader)program;
            FallbackShaderAccessor access = (FallbackShaderAccessor)fallback;
            before = access.getWritingToBeforeTranslucent();
            after = access.getWritingToAfterTranslucent();
        } else {
            throw new RuntimeException("Incompatible Iris version for Better Clouds, please report this issue to Better Clouds. Details: Shader is of type " + String.valueOf(program.getClass()) + ", Iris Version: " + Iris.getVersion());
        }
        GlFramebuffer required = corePipeline.isBeforeTranslucent ? before : after;
        if (required == null) {
            throw new RuntimeException("Incompatible Iris version for Better Clouds, please report this issue to Better Clouds. Details: Required framebuffer is null, Iris Version: " + Iris.getVersion());
        }
        if (corePipeline.isBeforeTranslucent) {
            before.bindAsDrawBuffer();
        } else {
            after.bindAsDrawBuffer();
        }
    }
}

