/*
 * Decompiled with CFR 0.152.
 */
package net.rogues.effect;

import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.rogues.RoguesMod;
import net.rogues.config.TweaksConfig;
import net.rogues.effect.ChargeEffect;
import net.rogues.effect.CustomStatusEffect;
import net.rogues.effect.StealthEffect;
import net.spell_engine.api.effect.ActionImpairing;
import net.spell_engine.api.effect.EntityActionsAllowed;
import net.spell_engine.api.effect.RemoveOnHit;
import net.spell_engine.api.effect.Synchronized;
import net.spell_engine.api.event.CombatEvents;

public class Effects {
    public static final MobEffect SLICE_AND_DICE = new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x993333);
    public static final MobEffect SHOCK = new CustomStatusEffect(MobEffectCategory.HARMFUL, 0xFFFFCC).m_19472_(Attributes.f_22279_, "112f3133-8a44-11ed-a1eb-0242ac120002", -1.0, AttributeModifier.Operation.MULTIPLY_BASE);
    public static final MobEffect SHADOW_STEP = new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0xAAAAAA);
    public static final MobEffect STEALTH = new StealthEffect(MobEffectCategory.BENEFICIAL, 0xAAAAAA);
    public static final MobEffect SHATTER = new CustomStatusEffect(MobEffectCategory.HARMFUL, 0x800000);
    public static final MobEffect DEMORALIZE = new CustomStatusEffect(MobEffectCategory.HARMFUL, 0x800000);
    public static final MobEffect CHARGE = new ChargeEffect(MobEffectCategory.BENEFICIAL, 0xAAAAAA);

    public static int sliceAndDiceMaxStacks() {
        return ((TweaksConfig)RoguesMod.tweaksConfig.value).slice_and_dice_max_stacks;
    }

    public static void register() {
        Synchronized.configure((MobEffect)SLICE_AND_DICE, (boolean)true);
        Synchronized.configure((MobEffect)SHOCK, (boolean)true);
        ActionImpairing.configure((MobEffect)SHOCK, (EntityActionsAllowed)EntityActionsAllowed.STUN);
        Synchronized.configure((MobEffect)STEALTH, (boolean)true);
        RemoveOnHit.configure((MobEffect)STEALTH, (boolean)true);
        Synchronized.configure((MobEffect)SHATTER, (boolean)true);
        Synchronized.configure((MobEffect)DEMORALIZE, (boolean)true);
        Synchronized.configure((MobEffect)CHARGE, (boolean)true);
        TweaksConfig config = (TweaksConfig)RoguesMod.tweaksConfig.value;
        SLICE_AND_DICE.m_19472_(Attributes.f_22281_, "112f3133-8a44-11ed-a1eb-0242ac220002", config.slice_and_dice_damage_multiplier, AttributeModifier.Operation.MULTIPLY_BASE);
        STEALTH.m_19472_(Attributes.f_22279_, "112f3133-8a44-11ed-a1eb-0242ac320003", config.stealth_movement_speed_multiplier, AttributeModifier.Operation.MULTIPLY_BASE);
        SHATTER.m_19472_(Attributes.f_22284_, "112f3133-8a44-11ed-a1eb-0242ac520055", config.shattered_armor_multiplier, AttributeModifier.Operation.MULTIPLY_BASE);
        DEMORALIZE.m_19472_(Attributes.f_22281_, "112f3133-8a44-11ed-a1eb-0242ac620006", config.shout_damage_multiplier, AttributeModifier.Operation.MULTIPLY_BASE);
        CHARGE.m_19472_(Attributes.f_22279_, "112f3133-8a44-11ed-a1eb-0242ac420004", config.charge_speed_multiplier, AttributeModifier.Operation.MULTIPLY_BASE).m_19472_(Attributes.f_22278_, "112f3133-8a44-11ed-a1eb-0242ac420004", config.charge_knockback_resistance_bonus, AttributeModifier.Operation.MULTIPLY_BASE);
        CombatEvents.ENTITY_ATTACK.register(args -> {
            LivingEntity attacker = args.attacker();
            if (attacker.m_21023_(STEALTH)) {
                attacker.m_21195_(STEALTH);
            }
        });
        ResourceLocation vanishId = new ResourceLocation("rogues", "vanish");
        CombatEvents.SPELL_CAST.register(args -> {
            Player caster = args.caster();
            if (caster.m_21023_(STEALTH) && !args.spell().id().equals((Object)vanishId)) {
                caster.m_21195_(STEALTH);
            }
        });
        CombatEvents.ITEM_USE.register(args -> {
            LivingEntity user = args.user();
            if (user.m_21023_(STEALTH)) {
                user.m_21195_(STEALTH);
            }
        });
        int rawId = config.effects_raw_id_start;
        Registry.m_122956_((Registry)BuiltInRegistries.f_256974_, (int)rawId++, (String)new ResourceLocation("rogues", "slice_and_dice").toString(), (Object)SLICE_AND_DICE);
        Registry.m_122956_((Registry)BuiltInRegistries.f_256974_, (int)rawId++, (String)new ResourceLocation("rogues", "shock").toString(), (Object)SHOCK);
        Registry.m_122956_((Registry)BuiltInRegistries.f_256974_, (int)rawId++, (String)new ResourceLocation("rogues", "shadow_step").toString(), (Object)SHADOW_STEP);
        Registry.m_122956_((Registry)BuiltInRegistries.f_256974_, (int)rawId++, (String)new ResourceLocation("rogues", "stealth").toString(), (Object)STEALTH);
        Registry.m_122956_((Registry)BuiltInRegistries.f_256974_, (int)rawId++, (String)new ResourceLocation("rogues", "shatter").toString(), (Object)SHATTER);
        Registry.m_122956_((Registry)BuiltInRegistries.f_256974_, (int)rawId++, (String)new ResourceLocation("rogues", "demoralize").toString(), (Object)DEMORALIZE);
        Registry.m_122956_((Registry)BuiltInRegistries.f_256974_, (int)rawId++, (String)new ResourceLocation("rogues", "charge").toString(), (Object)CHARGE);
    }
}

