/*
 * Decompiled with CFR 0.152.
 */
package net.rogues.item;

import java.util.ArrayList;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.rogues.RoguesMod;
import net.rogues.config.TweaksConfig;
import net.rogues.item.Group;
import net.spell_engine.api.item.ItemConfig;
import net.spell_engine.api.item.weapon.MeleeWeaponItem;
import net.spell_engine.api.item.weapon.SpellWeaponItem;
import net.spell_engine.api.item.weapon.Weapon;

public class Weapons {
    public static final ArrayList<Weapon.Entry> entries = new ArrayList();
    private static final String BETTER_END = "betterend";
    private static final String BETTER_NETHER = "betternether";
    public static final Weapon.Entry flint_dagger = Weapons.dagger("flint_dagger", Weapon.CustomMaterial.matching((Tiers)Tiers.IRON, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42484_})), 2.6f);
    public static final Weapon.Entry iron_dagger = Weapons.dagger("iron_dagger", Weapon.CustomMaterial.matching((Tiers)Tiers.IRON, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42416_})), 3.3f);
    public static final Weapon.Entry golden_dagger = Weapons.dagger("golden_dagger", Weapon.CustomMaterial.matching((Tiers)Tiers.GOLD, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42417_})), 1.8f);
    public static final Weapon.Entry diamond_dagger = Weapons.dagger("diamond_dagger", Weapon.CustomMaterial.matching((Tiers)Tiers.DIAMOND, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_})), 4.0f);
    public static final Weapon.Entry netherite_dagger = Weapons.dagger("netherite_dagger", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42418_})), 4.7f);
    public static final Weapon.Entry iron_sickle = Weapons.sickle("iron_sickle", Weapon.CustomMaterial.matching((Tiers)Tiers.IRON, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42416_})), 4.1f);
    public static final Weapon.Entry golden_sickle = Weapons.sickle("golden_sickle", Weapon.CustomMaterial.matching((Tiers)Tiers.GOLD, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42417_})), 2.4f);
    public static final Weapon.Entry diamond_sickle = Weapons.sickle("diamond_sickle", Weapon.CustomMaterial.matching((Tiers)Tiers.DIAMOND, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_})), 5.0f);
    public static final Weapon.Entry netherite_sickle = Weapons.sickle("netherite_sickle", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42418_})), 5.9f);
    public static final Weapon.Entry stone_double_axe = Weapons.axe("stone_double_axe", Weapon.CustomMaterial.matching((Tiers)Tiers.STONE, () -> Ingredient.m_204132_((TagKey)ItemTags.f_13165_)), 5.6f);
    public static final Weapon.Entry iron_double_axe = Weapons.axe("iron_double_axe", Weapon.CustomMaterial.matching((Tiers)Tiers.IRON, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42416_})), 7.0f);
    public static final Weapon.Entry golden_double_axe = Weapons.axe("golden_double_axe", Weapon.CustomMaterial.matching((Tiers)Tiers.GOLD, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42417_})), 4.3f);
    public static final Weapon.Entry diamond_double_axe = Weapons.axe("diamond_double_axe", Weapon.CustomMaterial.matching((Tiers)Tiers.DIAMOND, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_})), 8.3f);
    public static final Weapon.Entry netherite_double_axe = Weapons.axe("netherite_double_axe", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42418_})), 9.6f);
    public static final Weapon.Entry iron_glaive = Weapons.glaive("iron_glaive", Weapon.CustomMaterial.matching((Tiers)Tiers.IRON, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42416_})), 5.8f);
    public static final Weapon.Entry golden_glaive = Weapons.glaive("golden_glaive", Weapon.CustomMaterial.matching((Tiers)Tiers.GOLD, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42417_})), 3.5f);
    public static final Weapon.Entry diamond_glaive = Weapons.glaive("diamond_glaive", Weapon.CustomMaterial.matching((Tiers)Tiers.DIAMOND, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_})), 7.0f);
    public static final Weapon.Entry netherite_glaive = Weapons.glaive("netherite_glaive", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42418_})), 8.1f);

    private static Weapon.Entry entry(String name, Weapon.CustomMaterial material, Item item, ItemConfig.Weapon defaults) {
        return Weapons.entry(null, name, material, item, defaults);
    }

    private static Weapon.Entry entry(String requiredMod, String name, Weapon.CustomMaterial material, Item item, ItemConfig.Weapon defaults) {
        Weapon.Entry entry = new Weapon.Entry("rogues", name, material, item, defaults, null);
        if (entry.isRequiredModInstalled()) {
            entries.add(entry);
        }
        return entry;
    }

    private static Supplier<Ingredient> ingredient(String idString, boolean requirement, Item fallback) {
        ResourceLocation id = new ResourceLocation(idString);
        if (requirement) {
            return () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{fallback});
        }
        return () -> {
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(id);
            Item ingredient = item != null ? item : fallback;
            return Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient});
        };
    }

    private static Weapon.Entry dagger(String name, Weapon.CustomMaterial material, float damage) {
        return Weapons.dagger(null, name, material, damage);
    }

    private static Weapon.Entry dagger(String requiredMod, String name, Weapon.CustomMaterial material, float damage) {
        Item.Properties settings = new Item.Properties();
        MeleeWeaponItem item = new MeleeWeaponItem((Tier)material, settings);
        return Weapons.entry(requiredMod, name, material, (Item)item, new ItemConfig.Weapon(damage, -1.6f));
    }

    private static Weapon.Entry sickle(String name, Weapon.CustomMaterial material, float damage) {
        return Weapons.sickle(null, name, material, damage);
    }

    private static Weapon.Entry sickle(String requiredMod, String name, Weapon.CustomMaterial material, float damage) {
        Item.Properties settings = new Item.Properties();
        MeleeWeaponItem item = new MeleeWeaponItem((Tier)material, settings);
        return Weapons.entry(requiredMod, name, material, (Item)item, new ItemConfig.Weapon(damage, -2.0f));
    }

    private static Weapon.Entry axe(String name, Weapon.CustomMaterial material, float damage) {
        return Weapons.axe(null, name, material, damage);
    }

    private static Weapon.Entry axe(String requiredMod, String name, Weapon.CustomMaterial material, float damage) {
        Item.Properties settings = new Item.Properties();
        MeleeWeaponItem item = new MeleeWeaponItem((Tier)material, settings);
        return Weapons.entry(requiredMod, name, material, (Item)item, new ItemConfig.Weapon(damage, -2.8f));
    }

    private static Weapon.Entry glaive(String name, Weapon.CustomMaterial material, float damage) {
        return Weapons.glaive(null, name, material, damage);
    }

    private static Weapon.Entry glaive(String requiredMod, String name, Weapon.CustomMaterial material, float damage) {
        Item.Properties settings = new Item.Properties();
        SpellWeaponItem item = new SpellWeaponItem((Tier)material, settings);
        return Weapons.entry(requiredMod, name, material, (Item)item, new ItemConfig.Weapon(damage, -2.6f));
    }

    public static void register(Map<String, ItemConfig.Weapon> configs) {
        Supplier<Ingredient> repair;
        if (((TweaksConfig)RoguesMod.tweaksConfig.value).ignore_items_required_mods || FabricLoader.getInstance().isModLoaded(BETTER_NETHER)) {
            repair = Weapons.ingredient("betternether:nether_ruby", FabricLoader.getInstance().isModLoaded(BETTER_NETHER), Items.f_42418_);
            Weapons.dagger("ruby_dagger", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 5.5f);
            Weapons.sickle("ruby_sickle", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 6.8f);
            Weapons.axe("ruby_double_axe", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 11.0f);
            Weapons.glaive("ruby_glaive", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 9.3f);
        }
        if (((TweaksConfig)RoguesMod.tweaksConfig.value).ignore_items_required_mods || FabricLoader.getInstance().isModLoaded(BETTER_END)) {
            repair = Weapons.ingredient("betterend:aeternium_ingot", FabricLoader.getInstance().isModLoaded(BETTER_END), Items.f_42418_);
            Weapons.dagger("aeternium_dagger", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 5.5f);
            Weapons.sickle("aeternium_sickle", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 6.8f);
            Weapons.axe("aeternium_double_axe", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 11.0f);
            Weapons.glaive("aeternium_glaive", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 9.3f);
        }
        Weapon.register(configs, entries, Group.KEY);
    }
}

