/*
 * Decompiled with CFR 0.152.
 */
package net.rogues.util;

import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.rogues.block.MartialWorkbenchBlock;
import net.rogues.effect.StealthEffect;
import net.rogues.item.armor.RogueArmor;
import net.rogues.item.armor.WarriorArmor;

public class SoundHelper {
    public static List<String> soundKeys = List.of("slice_and_dice", "shock_powder_release", "shock_powder_impact", "shadow_step_arrive", "shadow_step_depart", "vanish_release", "vanish_combined", "throw", "throw_impact", "shout_release", "demoralize_impact", "charge_activate", "whirlwind");
    public static Map<String, Float> soundDistances = Map.of();
    public static final SoundEvent WORKBENCH = SoundEvent.m_262824_((ResourceLocation)MartialWorkbenchBlock.ID);

    public static void registerSounds() {
        for (String soundKey : soundKeys) {
            ResourceLocation soundId = new ResourceLocation("rogues", soundKey);
            Float customTravelDistance = soundDistances.get(soundKey);
            SoundEvent soundEvent = customTravelDistance == null ? SoundEvent.m_262824_((ResourceLocation)soundId) : SoundEvent.m_262856_((ResourceLocation)soundId, (float)customTravelDistance.floatValue());
            Registry.m_122965_((Registry)BuiltInRegistries.f_256894_, (ResourceLocation)soundId, (Object)soundEvent);
        }
        Registry.m_122965_((Registry)BuiltInRegistries.f_256894_, (ResourceLocation)MartialWorkbenchBlock.ID, (Object)WORKBENCH);
        Registry.m_122965_((Registry)BuiltInRegistries.f_256894_, (ResourceLocation)StealthEffect.LEAVE_SOUND_ID, (Object)StealthEffect.LEAVE_SOUND);
        Registry.m_122965_((Registry)BuiltInRegistries.f_256894_, (ResourceLocation)RogueArmor.equipSoundId, (Object)RogueArmor.equipSound);
        Registry.m_122965_((Registry)BuiltInRegistries.f_256894_, (ResourceLocation)WarriorArmor.equipSoundId, (Object)WarriorArmor.equipSound);
    }

    public static void playSoundEvent(Level world, Entity entity, SoundEvent soundEvent) {
        SoundHelper.playSoundEvent(world, entity, soundEvent, 1.0f, 1.0f);
    }

    public static void playSoundEvent(Level world, Entity entity, SoundEvent soundEvent, float volume, float pitch) {
        world.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), soundEvent, SoundSource.PLAYERS, volume, pitch);
    }
}

