/*
 * Decompiled with CFR 0.152.
 */
package net.rogues.village;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import net.fabric_extras.structure_pool.api.StructurePoolAPI;
import net.fabric_extras.structure_pool.api.StructurePoolConfig;
import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.fabricmc.fabric.api.object.builder.v1.world.poi.PointOfInterestHelper;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.rogues.RoguesMod;
import net.rogues.block.CustomBlocks;
import net.rogues.item.Weapons;
import net.rogues.item.armor.Armors;
import net.rogues.util.SoundHelper;

public class RogueVillagers {
    public static final String MERCHANT = "arms_merchant";

    public static PoiType registerPOI(String name, Block block) {
        return PointOfInterestHelper.register((ResourceLocation)new ResourceLocation("rogues", name), (int)1, (int)10, (Iterable)ImmutableSet.copyOf((Collection)block.m_49965_().m_61056_()));
    }

    public static VillagerProfession registerProfession(String name, ResourceKey<PoiType> workStation) {
        ResourceLocation id = new ResourceLocation("rogues", name);
        return (VillagerProfession)Registry.m_122965_((Registry)BuiltInRegistries.f_256735_, (ResourceLocation)new ResourceLocation("rogues", name), (Object)new VillagerProfession(id.toString(), entry -> entry.m_203565_(workStation), entry -> entry.m_203565_(workStation), ImmutableSet.of(), ImmutableSet.of(), SoundHelper.WORKBENCH));
    }

    public static void register() {
        StructurePoolAPI.injectAll((StructurePoolConfig)((StructurePoolConfig)RoguesMod.villagesConfig.value));
        PoiType poi = RogueVillagers.registerPOI(MERCHANT, CustomBlocks.WORKBENCH.block());
        VillagerProfession profession = RogueVillagers.registerProfession(MERCHANT, (ResourceKey<PoiType>)ResourceKey.m_135785_((ResourceKey)BuiltInRegistries.f_256941_.m_123023_(), (ResourceLocation)new ResourceLocation("rogues", MERCHANT)));
        List<Offer> offers = List.of(Offer.buy(1, new ItemStack((ItemLike)Items.f_42454_, 8), 5, 12, 4, 0.01f), Offer.sell(1, Weapons.flint_dagger.item().m_7968_(), 6, 12, 3, 0.1f), Offer.sell(1, Weapons.stone_double_axe.item().m_7968_(), 8, 12, 4, 0.1f), Offer.buy(2, new ItemStack((ItemLike)Items.f_42416_, 12), 8, 12, 5, 0.01f), Offer.sell(2, Weapons.iron_sickle.item().m_7968_(), 12, 12, 10, 0.1f), Offer.sell(2, Weapons.iron_glaive.item().m_7968_(), 18, 12, 10, 0.1f), Offer.sell(2, Armors.RogueArmorSet_t1.head.m_7968_(), 15, 12, 13, 0.05f), Offer.sell(2, Armors.WarriorArmorSet_t1.head.m_7968_(), 15, 12, 13, 0.05f), Offer.sell(3, Weapons.iron_dagger.item().m_7968_(), 14, 12, 12, 0.1f), Offer.sell(3, Weapons.iron_double_axe.item().m_7968_(), 18, 12, 12, 0.1f), Offer.sell(3, Armors.RogueArmorSet_t1.feet.m_7968_(), 15, 12, 13, 0.05f), Offer.sell(3, Armors.WarriorArmorSet_t1.feet.m_7968_(), 15, 12, 13, 0.05f), Offer.sell(3, Armors.RogueArmorSet_t1.legs.m_7968_(), 15, 12, 13, 0.05f), Offer.sell(3, Armors.WarriorArmorSet_t1.legs.m_7968_(), 15, 12, 13, 0.05f), Offer.sell(4, Armors.RogueArmorSet_t1.chest.m_7968_(), 15, 12, 13, 0.05f), Offer.sell(4, Armors.WarriorArmorSet_t1.chest.m_7968_(), 15, 12, 13, 0.05f), Offer.sell(4, new ItemStack((ItemLike)Items.f_220219_, 1), 15, 12, 5, 0.01f));
        for (Offer offer : offers) {
            TradeOfferHelper.registerVillagerOffers((VillagerProfession)profession, (int)offer.level, factories -> factories.add((entity, random) -> new MerchantOffer(offer.input, offer.output, offer.maxUses, offer.experience, offer.priceMultiplier)));
        }
        TradeOfferHelper.registerVillagerOffers((VillagerProfession)profession, (int)5, factories -> {
            factories.add((entity, random) -> new VillagerTrades.EnchantedItemForEmeralds(Weapons.diamond_dagger.item(), 30, 3, 30, 0.0f).m_213663_(entity, random));
            factories.add((entity, random) -> new VillagerTrades.EnchantedItemForEmeralds(Weapons.diamond_sickle.item(), 30, 3, 30, 0.0f).m_213663_(entity, random));
            factories.add((entity, random) -> new VillagerTrades.EnchantedItemForEmeralds(Weapons.diamond_double_axe.item(), 40, 3, 30, 0.0f).m_213663_(entity, random));
            factories.add((entity, random) -> new VillagerTrades.EnchantedItemForEmeralds(Weapons.diamond_glaive.item(), 40, 3, 30, 0.0f).m_213663_(entity, random));
        });
    }

    private static class Offer {
        int level;
        ItemStack input;
        ItemStack output;
        int maxUses;
        int experience;
        float priceMultiplier;

        public Offer(int level, ItemStack input, ItemStack output, int maxUses, int experience, float priceMultiplier) {
            this.level = level;
            this.input = input;
            this.output = output;
            this.maxUses = maxUses;
            this.experience = experience;
            this.priceMultiplier = priceMultiplier;
        }

        public static Offer buy(int level, ItemStack item, int price, int maxUses, int experience, float priceMultiplier) {
            return new Offer(level, item, new ItemStack((ItemLike)Items.f_42616_, price), maxUses, experience, priceMultiplier);
        }

        public static Offer sell(int level, ItemStack item, int price, int maxUses, int experience, float priceMultiplier) {
            return new Offer(level, new ItemStack((ItemLike)Items.f_42616_, price), item, maxUses, experience, priceMultiplier);
        }
    }
}

