/*
 * Decompiled with CFR 0.152.
 */
package net.fabric_extras.shield_api.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.function.Supplier;
import net.fabric_extras.shield_api.ShieldAPI;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public class CustomShieldItem
extends ShieldItem {
    private Multimap<Attribute, AttributeModifier> attributeModifiers;
    @Nullable
    private final SoundEvent equipSound;
    private final Supplier<Ingredient> repairIngredientSupplier;

    public CustomShieldItem(@Nullable SoundEvent equipSound, Supplier<Ingredient> repairIngredientSupplier, List<Tuple<Attribute, AttributeModifier>> attributeModifierList, Item.Properties settings) {
        super(settings);
        this.attributeModifiers = this.buildModifiers(attributeModifierList);
        this.equipSound = equipSound;
        this.repairIngredientSupplier = repairIngredientSupplier;
        ShieldAPI.instances.add(this);
    }

    public boolean m_6832_(ItemStack stack, ItemStack ingredient) {
        return this.repairIngredientSupplier.get().test(ingredient) || super.m_6832_(stack, ingredient);
    }

    public void setAttributeModifiers(List<Tuple<Attribute, AttributeModifier>> attributeModifierList) {
        this.attributeModifiers = this.buildModifiers(attributeModifierList);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        if (slot == EquipmentSlot.OFFHAND) {
            return this.attributeModifiers;
        }
        return super.m_7167_(slot);
    }

    protected Multimap<Attribute, AttributeModifier> buildModifiers(List<Tuple<Attribute, AttributeModifier>> attributeModifierList) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (Tuple<Attribute, AttributeModifier> pair : attributeModifierList) {
            builder.put((Object)((Attribute)pair.m_14418_()), (Object)((AttributeModifier)pair.m_14419_()));
        }
        return builder.build();
    }

    @Nullable
    public SoundEvent m_150681_() {
        return this.equipSound != null ? this.equipSound : super.m_150681_();
    }
}

