/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.api.util;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.api.util.AbilityHelper;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.phys.AABB;

public class AOEHelper {
    public static List<LivingEntity> getEntitiesByConfig(LivingEntity center, float distance) {
        int permissionLevel = Mcdw.CONFIG.mcdwEnchantmentSettingsConfig.aoePermission;
        Predicate<LivingEntity> predicate = livingEntity -> {
            if (!AbilityHelper.isAoeTarget(center, livingEntity)) return false;
            switch (permissionLevel) {
                case 1: {
                    if (AbilityHelper.isTrueAlly(center, livingEntity)) return false;
                    break;
                }
                case 2: {
                    if (AbilityHelper.isTrueAlly(center, livingEntity)) return false;
                    if (livingEntity instanceof Animal) return false;
                    break;
                }
                case 3: {
                    if (AbilityHelper.isPotentialAlly(livingEntity)) return false;
                    break;
                }
                case 4: {
                    if (!(livingEntity instanceof Monster)) return false;
                }
            }
            return true;
        };
        return AOEHelper.getEntitiesByPredicate(center, distance, predicate);
    }

    public static List<LivingEntity> getEntitiesByConfig(LivingEntity center, LivingEntity owner, float distance) {
        int permissionLevel = Mcdw.CONFIG.mcdwEnchantmentSettingsConfig.aoePermission;
        Predicate<LivingEntity> predicate = livingEntity -> {
            if (!AbilityHelper.isAoeTarget(center, owner, livingEntity)) return false;
            switch (permissionLevel) {
                case 1: {
                    if (AbilityHelper.isTrueAlly(owner, livingEntity)) return false;
                    break;
                }
                case 2: {
                    if (AbilityHelper.isTrueAlly(owner, livingEntity)) return false;
                    if (livingEntity instanceof Animal) return false;
                    break;
                }
                case 3: {
                    if (AbilityHelper.isPotentialAlly(livingEntity)) return false;
                    break;
                }
                case 4: {
                    if (!(livingEntity instanceof Monster)) return false;
                }
            }
            return true;
        };
        return AOEHelper.getEntitiesByPredicate(center, distance, predicate);
    }

    public static List<LivingEntity> getEntitiesByPredicate(LivingEntity center, float distance, Predicate<? super LivingEntity> predicate) {
        return center.m_20193_().m_6443_(LivingEntity.class, new AABB(center.m_20183_()).m_82400_((double)distance), predicate);
    }

    public static List<? extends LivingEntity> getEntitiesByPredicate(Class<? extends LivingEntity> entityType, LivingEntity center, float distance, Predicate<? super LivingEntity> predicate) {
        return center.m_20193_().m_6443_(entityType, new AABB(center.m_20183_()).m_82400_((double)distance), predicate);
    }

    public static void afflictNearbyEntities(LivingEntity user, float distance, MobEffectInstance ... statusEffectInstances) {
        for (LivingEntity nearbyEntity : AOEHelper.getEntitiesByConfig(user, distance)) {
            for (MobEffectInstance instance : statusEffectInstances) {
                nearbyEntity.m_7292_(instance);
            }
        }
    }

    public static boolean satisfySweepConditions(LivingEntity attackingEntity, Entity targetEntity, LivingEntity collateralEntity, float distanceToCollateral) {
        ArmorStand armorStand;
        return collateralEntity != attackingEntity && collateralEntity != targetEntity && !attackingEntity.m_7307_((Entity)collateralEntity) && (!(collateralEntity instanceof ArmorStand) || !(armorStand = (ArmorStand)collateralEntity).m_31677_()) && attackingEntity.m_20270_((Entity)collateralEntity) < distanceToCollateral;
    }
}

