/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.api.util;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.enchants.goals.GoalUtils;
import chronosacaria.mcdw.enums.SettingsID;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;

public class AbilityHelper {
    public static void stealSpeedFromTarget(LivingEntity user, LivingEntity target, int amplifier) {
        MobEffectInstance speed = new MobEffectInstance(MobEffects.f_19596_, 80, amplifier);
        MobEffectInstance slowness = new MobEffectInstance(MobEffects.f_19597_, 80, amplifier);
        user.m_7292_(speed);
        target.m_7292_(slowness);
    }

    public static void causeFreezing(LivingEntity target, int amplifier) {
        MobEffectInstance freezing = new MobEffectInstance(MobEffects.f_19597_, 60, amplifier);
        MobEffectInstance miningFatigue = new MobEffectInstance(MobEffects.f_19599_, 60, amplifier);
        target.m_7292_(freezing);
        target.m_7292_(miningFatigue);
    }

    public static boolean isPetOf(LivingEntity owner, LivingEntity animal) {
        if (animal instanceof TamableAnimal) {
            TamableAnimal pet = (TamableAnimal)animal;
            return pet.m_269323_() == owner;
        }
        if (animal instanceof AbstractHorse) {
            AbstractHorse horseBaseEntity = (AbstractHorse)animal;
            return GoalUtils.getOwner(horseBaseEntity) == owner;
        }
        return false;
    }

    public static boolean isTrueAlly(LivingEntity self, LivingEntity foreignEntity) {
        return self.m_7307_((Entity)foreignEntity) || AbilityHelper.isPetOf(self, foreignEntity) || AbilityHelper.isVillagerTyped(foreignEntity);
    }

    public static boolean isPotentialAlly(LivingEntity foreignEntity) {
        return AbilityHelper.isPet(foreignEntity) || AbilityHelper.isVillagerTyped(foreignEntity) || foreignEntity instanceof Player;
    }

    private static boolean isPet(LivingEntity animal) {
        if (animal instanceof TamableAnimal) {
            TamableAnimal pet = (TamableAnimal)animal;
            return pet.m_269323_() != null;
        }
        if (animal instanceof AbstractHorse) {
            AbstractHorse horseBaseEntity = (AbstractHorse)animal;
            return GoalUtils.getOwner(horseBaseEntity) != null;
        }
        return false;
    }

    private static boolean isVillagerTyped(LivingEntity nearbyEntity) {
        return nearbyEntity instanceof Villager || nearbyEntity instanceof IronGolem;
    }

    public static boolean isAoeTarget(LivingEntity self, LivingEntity foreignEntity) {
        return foreignEntity != self && foreignEntity.m_6084_() && AbilityHelper.isAffectedByAoe(foreignEntity) && self.m_142582_((Entity)foreignEntity);
    }

    public static boolean isAoeTarget(LivingEntity center, LivingEntity owner, LivingEntity foreignEntity) {
        return foreignEntity != owner && foreignEntity.m_6084_() && AbilityHelper.isAffectedByAoe(foreignEntity) && center.m_142582_((Entity)foreignEntity);
    }

    private static boolean isAffectedByAoe(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_7500_()) {
                return false;
            }
            return Mcdw.CONFIG.mcdwEnchantmentSettingsConfig.ENABLE_ENCHANTMENT_SETTINGS.get((Object)SettingsID.AREA_OF_EFFECT_ENCHANTS_DONT_AFFECT_PLAYERS) == false;
        }
        return true;
    }

    public static float getAnimaRepairAmount(float experience, int level) {
        return experience *= (float)(0.2 * (double)level);
    }

    public static boolean entityCanCrit(LivingEntity livingEntity) {
        return !livingEntity.m_6147_() && !livingEntity.m_20069_() && !livingEntity.m_20096_() && !livingEntity.m_20142_() && !livingEntity.m_20159_() && !livingEntity.m_21023_(MobEffects.f_19610_) && livingEntity.f_19789_ > 0.0f;
    }
}

