/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.api.util;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.api.interfaces.IMcdwEnchantedArrow;
import chronosacaria.mcdw.api.interfaces.IOffhandAttack;
import chronosacaria.mcdw.bases.McdwLongbow;
import chronosacaria.mcdw.bases.McdwShortbow;
import chronosacaria.mcdw.configs.CompatibilityFlags;
import chronosacaria.mcdw.enums.EnchantmentsID;
import chronosacaria.mcdw.enums.SettingsID;
import chronosacaria.mcdw.registries.EnchantsRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;

public class CleanlinessHelper {
    public static final RandomSource random = RandomSource.m_216337_();

    public static boolean percentToOccur(int chance) {
        return random.m_188503_(100) < chance;
    }

    public static boolean canRepairCheck(String[] repairIngredient, ItemStack ingredient) {
        ArrayList potentialIngredients = new ArrayList(List.of());
        AtomicBoolean isWood = new AtomicBoolean(false);
        AtomicBoolean isStone = new AtomicBoolean(false);
        if (repairIngredient != null && repairIngredient.length > 0) {
            Arrays.stream(repairIngredient).toList().forEach(repIngredient -> {
                if (repIngredient != null) {
                    if (repIngredient.contentEquals("minecraft:planks")) {
                        isWood.set(true);
                    } else if (repIngredient.contentEquals("minecraft:stone_crafting_materials")) {
                        isStone.set(true);
                    }
                    potentialIngredients.add((Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(repIngredient)));
                }
            });
        }
        return potentialIngredients.contains(ingredient.m_41720_()) || isWood.get() && ingredient.m_204117_(ItemTags.f_13168_) || isStone.get() && ingredient.m_204117_(ItemTags.f_13166_);
    }

    public static void playCenteredSound(LivingEntity center, SoundEvent soundEvent, float volume, float pitch) {
        CleanlinessHelper.playCenteredSound(center, soundEvent, SoundSource.PLAYERS, volume, pitch);
    }

    public static void playCenteredSound(LivingEntity center, SoundEvent soundEvent, SoundSource soundCategory, float volume, float pitch) {
        center.m_9236_().m_6263_(null, center.m_20185_(), center.m_20186_(), center.m_20189_(), soundEvent, soundCategory, volume, pitch);
    }

    public static void mcdw$dropItem(LivingEntity le, Item item) {
        CleanlinessHelper.mcdw$dropItem(le, item, 1);
    }

    public static void mcdw$dropItem(LivingEntity le, ItemStack itemStack) {
        ItemEntity it = new ItemEntity(le.m_9236_(), le.m_20185_(), le.m_20186_(), le.m_20189_(), itemStack);
        le.m_9236_().m_7967_((Entity)it);
    }

    public static void mcdw$dropItem(LivingEntity le, Item item, int amount) {
        CleanlinessHelper.mcdw$dropItem(le, new ItemStack((ItemLike)item, amount));
    }

    public static void mcdw$tooltipHelper(ItemStack stack, List<Component> tooltip, int subStringIndex) {
        int i = 1;
        String str = stack.m_41720_().m_5524_().toLowerCase(Locale.ROOT).substring(subStringIndex);
        String translationKey = String.format("tooltip_info_item.mcdw.%s_", str);
        while (I18n.m_118936_((String)(translationKey + i))) {
            tooltip.add((Component)Component.m_237115_((String)(translationKey + i)).m_130940_(ChatFormatting.ITALIC));
            ++i;
        }
        if (stack.m_41720_() instanceof IOffhandAttack && CompatibilityFlags.noOffhandConflicts) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip_info_item.mcdw.gap").m_130940_(ChatFormatting.ITALIC));
            tooltip.add((Component)Component.m_237115_((String)"tooltip_note_item.mcdw.dualwield").m_130940_(ChatFormatting.GREEN));
        }
        if (stack.m_41720_() instanceof McdwShortbow) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip_info_item.mcdw.gap").m_130940_(ChatFormatting.ITALIC));
            tooltip.add((Component)Component.m_237115_((String)"tooltip_note_item.mcdw.shortbow").m_130940_(ChatFormatting.GREEN));
        }
        if (stack.m_41720_() instanceof McdwLongbow) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip_info_item.mcdw.gap").m_130940_(ChatFormatting.ITALIC));
            tooltip.add((Component)Component.m_237115_((String)"tooltip_note_item.mcdw.longbow").m_130940_(ChatFormatting.GREEN));
        }
    }

    public static void addPPEEnchantments(ItemStack itemStack, IMcdwEnchantedArrow ppe) {
        int wildRageLevel;
        int voidShotLevel;
        int thunderingLevel;
        int tempoTheftLevel;
        int shadowShotLevel;
        int ricochetLevel;
        int replenishLevel;
        int radianceLevel;
        int poisonCloudLevel;
        int phantomsMarkLevel;
        int levitationShotLevel;
        int growingLevel;
        int gravityLevel;
        int freezingLevel;
        int fuseShotLevel;
        int enigmaResonatorLevel;
        int dynamoLevel;
        int cobwebShotLevel;
        int chargeLevel;
        int chainReactionLevel = EnchantmentHelper.m_44843_((Enchantment)EnchantsRegistry.enchantments.get((Object)EnchantmentsID.CHAIN_REACTION), (ItemStack)itemStack);
        if (chainReactionLevel > 0) {
            ppe.mcdw$setChainReactionLevel(chainReactionLevel);
        }
        if ((chargeLevel = EnchantmentHelper.m_44843_((Enchantment)EnchantsRegistry.enchantments.get((Object)EnchantmentsID.CHARGE), (ItemStack)itemStack)) > 0) {
            ppe.mcdw$setChargeLevel(chargeLevel);
        }
        if ((cobwebShotLevel = EnchantmentHelper.m_44843_((Enchantment)EnchantsRegistry.enchantments.get((Object)EnchantmentsID.COBWEB_SHOT), (ItemStack)itemStack)) > 0) {
            ppe.mcdw$setCobwebShotLevel(cobwebShotLevel);
        }
        if ((dynamoLevel = EnchantmentHelper.m_44843_((Enchantment)EnchantsRegistry.enchantments.get((Object)EnchantmentsID.DYNAMO), (ItemStack)itemStack)) > 0) {
            ppe.mcdw$setDynamoLevel(dynamoLevel);
        }
        if ((enigmaResonatorLevel = EnchantmentHelper.m_44843_((Enchantment)EnchantsRegistry.enchantments.get((Object)EnchantmentsID.ENIGMA_RESONATOR), (ItemStack)itemStack)) > 0) {
            ppe.mcdw$setEnigmaResonatorLevel(enigmaResonatorLevel);
        }
        if ((fuseShotLevel = EnchantmentHelper.m_44843_((Enchantment)EnchantsRegistry.enchantments.get((Object)EnchantmentsID.FUSE_SHOT), (ItemStack)itemStack)) > 0) {
            ppe.mcdw$setFuseShotLevel(fuseShotLevel);
        }
        if ((freezingLevel = EnchantmentHelper.m_44843_((Enchantment)EnchantsRegistry.enchantments.get((Object)EnchantmentsID.FREEZING), (ItemStack)itemStack)) > 0) {
            ppe.mcdw$setFreezingLevel(freezingLevel);
        }
        if ((gravityLevel = EnchantmentHelper.m_44843_((Enchantment)EnchantsRegistry.enchantments.get((Object)EnchantmentsID.GRAVITY), (ItemStack)itemStack)) > 0) {
            ppe.mcdw$setGravityLevel(gravityLevel);
        }
        if ((growingLevel = EnchantmentHelper.m_44843_((Enchantment)EnchantsRegistry.enchantments.get((Object)EnchantmentsID.GROWING), (ItemStack)itemStack)) > 0) {
            ppe.mcdw$setGrowingLevel(growingLevel);
        }
        if ((levitationShotLevel = EnchantmentHelper.m_44843_((Enchantment)EnchantsRegistry.enchantments.get((Object)EnchantmentsID.LEVITATION_SHOT), (ItemStack)itemStack)) > 0) {
            ppe.mcdw$setLevitationShotLevel(levitationShotLevel);
        }
        if ((phantomsMarkLevel = EnchantmentHelper.m_44843_((Enchantment)EnchantsRegistry.enchantments.get((Object)EnchantmentsID.PHANTOMS_MARK), (ItemStack)itemStack)) > 0) {
            ppe.mcdw$setPhantomsMarkLevel(phantomsMarkLevel);
        }
        if ((poisonCloudLevel = EnchantmentHelper.m_44843_((Enchantment)EnchantsRegistry.enchantments.get((Object)EnchantmentsID.POISON_CLOUD), (ItemStack)itemStack)) > 0) {
            ppe.mcdw$setPoisonCloudLevel(poisonCloudLevel);
        }
        if ((radianceLevel = EnchantmentHelper.m_44843_((Enchantment)EnchantsRegistry.enchantments.get((Object)EnchantmentsID.RADIANCE), (ItemStack)itemStack)) > 0) {
            ppe.mcdw$setRadianceLevel(radianceLevel);
        }
        if ((replenishLevel = EnchantmentHelper.m_44843_((Enchantment)EnchantsRegistry.enchantments.get((Object)EnchantmentsID.REPLENISH), (ItemStack)itemStack)) > 0) {
            ppe.mcdw$setReplenishLevel(replenishLevel);
        }
        if ((ricochetLevel = EnchantmentHelper.m_44843_((Enchantment)EnchantsRegistry.enchantments.get((Object)EnchantmentsID.RICOCHET), (ItemStack)itemStack)) > 0) {
            ppe.mcdw$setRicochetLevel(ricochetLevel);
        }
        if ((shadowShotLevel = EnchantmentHelper.m_44843_((Enchantment)EnchantsRegistry.enchantments.get((Object)EnchantmentsID.SHADOW_SHOT), (ItemStack)itemStack)) > 0) {
            ppe.mcdw$setShadowShotLevel(shadowShotLevel);
        }
        if ((tempoTheftLevel = EnchantmentHelper.m_44843_((Enchantment)EnchantsRegistry.enchantments.get((Object)EnchantmentsID.TEMPO_THEFT), (ItemStack)itemStack)) > 0) {
            ppe.mcdw$setTempoTheftLevel(tempoTheftLevel);
        }
        if ((thunderingLevel = EnchantmentHelper.m_44843_((Enchantment)EnchantsRegistry.enchantments.get((Object)EnchantmentsID.THUNDERING), (ItemStack)itemStack)) > 0) {
            ppe.mcdw$setThunderingLevel(thunderingLevel);
        }
        if ((voidShotLevel = EnchantmentHelper.m_44843_((Enchantment)EnchantsRegistry.enchantments.get((Object)EnchantmentsID.VOID_SHOT), (ItemStack)itemStack)) > 0) {
            ppe.mcdw$setVoidShotLevel(voidShotLevel);
        }
        if ((wildRageLevel = EnchantmentHelper.m_44843_((Enchantment)EnchantsRegistry.enchantments.get((Object)EnchantmentsID.WILD_RAGE), (ItemStack)itemStack)) > 0) {
            ppe.mcdw$setWildRageLevel(wildRageLevel);
        }
    }

    public static Map<Enchantment, Integer> mcdw$checkInnateEnchantmentEnabled(int level, Object ... enchantments) {
        LinkedHashMap<Enchantment, Integer> enchantmentIntegerLinkedHashMap = new LinkedHashMap<Enchantment, Integer>();
        for (Object enchantment : enchantments) {
            if (enchantment instanceof EnchantmentsID) {
                EnchantmentsID id = (EnchantmentsID)((Object)enchantment);
                if (!Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)id).mcdw$getIsEnabled() || !Mcdw.CONFIG.mcdwEnchantmentSettingsConfig.ENABLE_ENCHANTMENT_SETTINGS.get((Object)SettingsID.ENABLE_INNATE_ENCHANTMENTS).booleanValue()) continue;
                enchantmentIntegerLinkedHashMap.put(EnchantsRegistry.enchantments.get((Object)id), level);
                continue;
            }
            if (!(enchantment instanceof Enchantment)) continue;
            Enchantment vanillaEnchantment = (Enchantment)enchantment;
            if (!Mcdw.CONFIG.mcdwEnchantmentSettingsConfig.ENABLE_ENCHANTMENT_SETTINGS.get((Object)SettingsID.ENABLE_INNATE_ENCHANTMENTS).booleanValue()) continue;
            enchantmentIntegerLinkedHashMap.put(vanillaEnchantment, level);
        }
        return enchantmentIntegerLinkedHashMap;
    }

    public static String materialToString(Tier toolMaterial) {
        if (toolMaterial == Tiers.WOOD) {
            return "wood";
        }
        if (toolMaterial == Tiers.STONE) {
            return "stone";
        }
        if (toolMaterial == Tiers.GOLD) {
            return "gold";
        }
        if (toolMaterial == Tiers.IRON) {
            return "iron";
        }
        if (toolMaterial == Tiers.DIAMOND) {
            return "diamond";
        }
        if (toolMaterial == Tiers.NETHERITE) {
            return "netherite";
        }
        return "none";
    }

    public static Tier stringToMaterial(String material) {
        return switch (material) {
            case "wood" -> Tiers.WOOD;
            case "stone" -> Tiers.STONE;
            case "gold" -> Tiers.GOLD;
            case "diamond" -> Tiers.DIAMOND;
            case "netherite" -> Tiers.NETHERITE;
            default -> Tiers.IRON;
        };
    }
}

