/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.api.util;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;

public final class EnchantmentRestriction {
    private static final ArrayListMultimap<Enchantment, Condition> PERMISSIONS = ArrayListMultimap.create();
    private static final ArrayList<TypeCondition> PERMISSIBLE_TARGETS = new ArrayList();
    private static final ArrayListMultimap<Enchantment, Condition> PROHIBITIONS = ArrayListMultimap.create();
    private static final ArrayList<TypeCondition> PROHIBITED_TARGETS = new ArrayList();

    public static void permit(Enchantment enchantment, Condition condition) {
        PERMISSIONS.put((Object)enchantment, (Object)condition);
    }

    public static void permitTarget(TypeCondition typeCondition) {
        PERMISSIBLE_TARGETS.add(typeCondition);
    }

    public static void prohibit(Enchantment enchantment, Condition condition) {
        PROHIBITIONS.put((Object)enchantment, (Object)condition);
    }

    public static void prohibitTarget(TypeCondition typeCondition) {
        PROHIBITED_TARGETS.add(typeCondition);
    }

    public static boolean isPermitted(Enchantment enchantment, ItemStack itemStack) {
        List conditions = PERMISSIONS.get((Object)enchantment);
        for (Condition condition : conditions) {
            if (!condition.isAcceptableItem(itemStack)) continue;
            return true;
        }
        for (TypeCondition typeCondition : PERMISSIBLE_TARGETS) {
            if (!typeCondition.isAcceptableItem(enchantment, itemStack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isProhibited(Enchantment enchantment, ItemStack itemStack) {
        List conditions = PROHIBITIONS.get((Object)enchantment);
        for (Condition condition : conditions) {
            if (!condition.isAcceptableItem(itemStack)) continue;
            return true;
        }
        for (TypeCondition typeCondition : PROHIBITED_TARGETS) {
            if (!typeCondition.isAcceptableItem(enchantment, itemStack)) continue;
            return true;
        }
        return false;
    }

    public static interface Condition {
        public boolean isAcceptableItem(ItemStack var1);
    }

    public static interface TypeCondition {
        public boolean isAcceptableItem(Enchantment var1, ItemStack var2);
    }
}

